/*
 * Decompiled with CFR 0.152.
 */
package mage.server.managers;

import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import mage.MageException;
import mage.cards.decks.DeckCardLists;
import mage.game.GameException;
import mage.game.Table;
import mage.game.draft.Draft;
import mage.game.match.Match;
import mage.game.match.MatchOptions;
import mage.game.tournament.Tournament;
import mage.game.tournament.TournamentOptions;
import mage.game.tournament.TournamentPlayer;
import mage.players.PlayerType;
import mage.server.TableController;

public interface TableManager {
    public Table createTable(UUID var1, UUID var2, MatchOptions var3);

    public Table createTable(UUID var1, MatchOptions var2);

    public Table createTournamentTable(UUID var1, UUID var2, TournamentOptions var3);

    public Table getTable(UUID var1);

    public Optional<Match> getMatch(UUID var1);

    public Collection<Table> getTables();

    public Collection<TableController> getControllers();

    public Optional<TableController> getController(UUID var1);

    public boolean joinTable(UUID var1, UUID var2, String var3, PlayerType var4, int var5, DeckCardLists var6, String var7) throws MageException;

    public boolean joinTournament(UUID var1, UUID var2, String var3, PlayerType var4, int var5, DeckCardLists var6, String var7) throws GameException;

    public boolean submitDeck(UUID var1, UUID var2, DeckCardLists var3) throws MageException;

    public void updateDeck(UUID var1, UUID var2, DeckCardLists var3) throws MageException;

    public void userQuitTournamentSubTables(UUID var1);

    public void userQuitTournamentSubTables(UUID var1, UUID var2);

    public boolean isTableOwner(UUID var1, UUID var2);

    public boolean removeTable(UUID var1, UUID var2);

    public void leaveTable(UUID var1, UUID var2);

    public Optional<UUID> getChatId(UUID var1);

    public void startMatch(UUID var1, UUID var2, UUID var3);

    public void startTournamentSubMatch(UUID var1, UUID var2);

    public void startTournament(UUID var1, UUID var2, UUID var3);

    public void startDraft(UUID var1, Draft var2);

    public boolean watchTable(UUID var1, UUID var2);

    public void endGame(UUID var1);

    public void endDraft(UUID var1, Draft var2);

    public void endTournament(UUID var1, Tournament var2);

    public void swapSeats(UUID var1, UUID var2, int var3, int var4);

    public void construct(UUID var1);

    public void initTournament(UUID var1);

    public void addPlayer(UUID var1, UUID var2, TournamentPlayer var3) throws GameException;

    public void removeTable(UUID var1);

    public void debugServerState();

    public void checkHealth();
}

