/*
 * Decompiled with CFR 0.152.
 */
package mage.server.rating;

import java.util.Date;
import mage.server.rating.GlickoRating;

public class GlickoRatingSystem {
    public static final double C = 0.0013793431476706133;
    public static final double BASE_RATING = 1500.0;
    public static final double BASE_RD = 350.0;
    public static final double MIN_RD = 30.0;
    private static final double Q = Math.log(10.0) / 400.0;

    public static GlickoRating getInitialRating() {
        return new GlickoRating(1500.0, 350.0, 0L);
    }

    public static int getDisplayedRating(GlickoRating rating) {
        long currentTime = new Date().getTime();
        double updatedRatingDeviation = GlickoRatingSystem.getUpdatedRD(rating, currentTime);
        return (int)Math.max(rating.getRating() - 2.0 * updatedRatingDeviation, 0.0);
    }

    public static int getDefaultDisplayedRating() {
        return GlickoRatingSystem.getDisplayedRating(GlickoRatingSystem.getInitialRating());
    }

    public void updateRating(GlickoRating playerRating, GlickoRating opponentRating, double outcome, long gameTimeMs) {
        playerRating.setRatingDeviation(GlickoRatingSystem.getUpdatedRD(playerRating, gameTimeMs));
        opponentRating.setRatingDeviation(GlickoRatingSystem.getUpdatedRD(opponentRating, gameTimeMs));
        GlickoRating newPlayerRating = this.getNewRating(playerRating, opponentRating, outcome);
        GlickoRating newOpponentRating = this.getNewRating(opponentRating, playerRating, 1.0 - outcome);
        playerRating.setRating(newPlayerRating.getRating());
        playerRating.setRatingDeviation(newPlayerRating.getRatingDeviation());
        playerRating.setLastGameTimeMs(gameTimeMs);
        opponentRating.setRating(newOpponentRating.getRating());
        opponentRating.setRatingDeviation(newOpponentRating.getRatingDeviation());
        opponentRating.setLastGameTimeMs(gameTimeMs);
    }

    private static double getUpdatedRD(GlickoRating rating, long gameTimeMs) {
        double newRatingDeviation;
        if (rating.getLastGameTimeMs() != 0L) {
            double newRD = Math.sqrt(rating.getRatingDeviation() * rating.getRatingDeviation() + 1.9025875190258753E-6 * (double)Math.max(gameTimeMs - rating.getLastGameTimeMs(), 0L));
            newRatingDeviation = Math.max(Math.min(350.0, newRD), 30.0);
        } else {
            newRatingDeviation = 350.0;
        }
        return newRatingDeviation;
    }

    private GlickoRating getNewRating(GlickoRating playerRating, GlickoRating opponentRating, double outcome) {
        double playerRatingDeviation = playerRating.getRatingDeviation();
        double g = this.gFunc(opponentRating.getRatingDeviation());
        double p = -g * (playerRating.getRating() - opponentRating.getRating()) / 400.0;
        double e = 1.0 / (1.0 + Math.pow(10.0, p));
        double d2 = 1.0 / (Q * Q * g * g * e * (1.0 - e));
        double newRating = playerRating.getRating() + Q / (1.0 / playerRatingDeviation / playerRatingDeviation + 1.0 / d2) * g * (outcome - e);
        double newRD = Math.sqrt(1.0 / (1.0 / playerRatingDeviation / playerRatingDeviation + 1.0 / d2));
        return new GlickoRating(newRating, newRD);
    }

    private double gFunc(double rd) {
        return 1.0 / Math.sqrt(1.0 + 3.0 * Q * Q * rd * rd / Math.PI / Math.PI);
    }
}

