/*
 * Decompiled with CFR 0.152.
 */
package mage.server.util;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mage.util.XmageThreadFactory;
import mage.utils.StreamUtils;
import org.apache.log4j.Logger;

public enum ServerMessagesUtil {
    instance;

    private static final Logger LOGGER;
    private static final String SERVER_MSG_TXT_FILE = "server.msg.txt";
    private static final int SERVER_MSG_REFRESH_RATE_SECS = 60;
    private final List<String> newsMessages = new ArrayList<String>();
    private String statsMessage = "";
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static boolean ignore;
    private static long startDate;
    private static int maxUsersOnline;
    private static final AtomicInteger gamesStarted;
    private static final AtomicInteger gamesEnded;
    private static final AtomicInteger tournamentsStarted;
    private static final AtomicInteger tournamentsEnded;
    private static final AtomicInteger lostConnection;
    private static final AtomicInteger reconnects;

    private ServerMessagesUtil() {
        ScheduledExecutorService NEWS_MESSAGES_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new XmageThreadFactory("XMAGE news refresh"));
        NEWS_MESSAGES_EXECUTOR.scheduleAtFixedRate(this::reloadMessages, 5L, 60L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMessages() {
        Lock r = this.lock.readLock();
        r.lock();
        try {
            ArrayList<String> res = new ArrayList<String>(this.newsMessages);
            res.add(this.statsMessage);
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        finally {
            r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadMessages() {
        LOGGER.debug((Object)"Reading server messages...");
        ArrayList<String> updatedMessages = new ArrayList<String>(this.readFromFile());
        String updatedStats = this.getServerStatsMessage();
        Lock w = this.lock.writeLock();
        w.lock();
        try {
            this.newsMessages.clear();
            this.newsMessages.addAll(updatedMessages);
            this.statsMessage = updatedStats;
        }
        finally {
            w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFromFile() {
        if (ignore) {
            return Collections.emptyList();
        }
        InputStream is = null;
        File file = new File(SERVER_MSG_TXT_FILE);
        if (!file.exists() || !file.canRead()) {
            if (!file.getAbsolutePath().contains("Mage.Server")) {
                LOGGER.warn((Object)("Can't find server messages file: " + file.getAbsolutePath()));
            }
        } else {
            try {
                is = Files.newInputStream(file.toPath(), new OpenOption[0]);
                ignore = false;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Can't read server messages file: " + file.getAbsolutePath() + " - " + e.getMessage()), (Throwable)e);
                ignore = true;
            }
        }
        if (is == null) {
            return Collections.emptyList();
        }
        ArrayList<String> newMessages = new ArrayList<String>();
        try (Scanner scanner = new Scanner(is);){
            while (scanner.hasNextLine()) {
                String message = scanner.nextLine().trim();
                if (message.startsWith("//") || message.isEmpty()) continue;
                newMessages.add(message.trim());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Can't read message from server messages file: " + e.getMessage()), (Throwable)e);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)is);
        }
        return newMessages;
    }

    private String getServerStatsMessage() {
        long current = System.currentTimeMillis();
        long hours = startDate <= 0L ? 0L : (current - startDate) / 3600000L;
        String updated = new Date().toInstant().atOffset(ZoneOffset.UTC).toLocalDateTime().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        return String.format("Server uptime: %d hours; max online: %d; active games: %d of %d, tourneys: %d of %d; stats from %s", hours, maxUsersOnline, gamesStarted.get() - gamesEnded.get(), gamesStarted.get(), tournamentsStarted.get() - tournamentsEnded.get(), tournamentsStarted.get(), updated);
    }

    public void setStartDate(long milliseconds) {
        startDate = milliseconds;
    }

    public void setMaxUsersOnline(int newOnline) {
        maxUsersOnline = newOnline;
    }

    public void incGamesStarted() {
        gamesStarted.incrementAndGet();
    }

    public void incGamesEnded() {
        gamesEnded.incrementAndGet();
    }

    public void incTournamentsStarted() {
        tournamentsStarted.incrementAndGet();
    }

    public void incTournamentsEnded() {
        tournamentsEnded.incrementAndGet();
    }

    public void incReconnects() {
        reconnects.incrementAndGet();
    }

    public void incLostConnection() {
        lostConnection.incrementAndGet();
    }

    static {
        LOGGER = Logger.getLogger(ServerMessagesUtil.class);
        ignore = false;
        maxUsersOnline = 0;
        gamesStarted = new AtomicInteger(0);
        gamesEnded = new AtomicInteger(0);
        tournamentsStarted = new AtomicInteger(0);
        tournamentsEnded = new AtomicInteger(0);
        lostConnection = new AtomicInteger(0);
        reconnects = new AtomicInteger(0);
    }
}

