/*
 * Decompiled with CFR 0.152.
 */
package mage.server.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import mage.server.managers.ConfigSettings;
import mage.server.managers.ThreadExecutor;
import mage.util.ThreadUtils;
import mage.util.XmageThreadFactory;
import org.apache.log4j.Logger;

public class ThreadExecutorImpl
implements ThreadExecutor {
    private static final Logger logger = Logger.getLogger(ThreadExecutorImpl.class);
    private static final int GAMES_PER_TOURNEY_RATIO = 5;
    private final ExecutorService callExecutor = new CachedThreadPoolWithException();
    private final ExecutorService gameExecutor;
    private final ExecutorService tourneyExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final ScheduledExecutorService timeoutIdleExecutor;
    private final ScheduledExecutorService serverHealthExecutor;

    public ThreadExecutorImpl(ConfigSettings config) {
        ((ThreadPoolExecutor)this.callExecutor).setKeepAliveTime(60L, TimeUnit.SECONDS);
        ((ThreadPoolExecutor)this.callExecutor).allowCoreThreadTimeOut(true);
        ((ThreadPoolExecutor)this.callExecutor).setThreadFactory(new XmageThreadFactory("CALL"));
        this.gameExecutor = new FixedThreadPoolWithException(config.getMaxGameThreads());
        ((ThreadPoolExecutor)this.gameExecutor).setKeepAliveTime(60L, TimeUnit.SECONDS);
        ((ThreadPoolExecutor)this.gameExecutor).allowCoreThreadTimeOut(true);
        ((ThreadPoolExecutor)this.gameExecutor).setThreadFactory(new XmageThreadFactory("GAME"));
        this.tourneyExecutor = new FixedThreadPoolWithException(Math.max(2, config.getMaxGameThreads() / 5));
        ((ThreadPoolExecutor)this.tourneyExecutor).setKeepAliveTime(60L, TimeUnit.SECONDS);
        ((ThreadPoolExecutor)this.tourneyExecutor).allowCoreThreadTimeOut(true);
        ((ThreadPoolExecutor)this.tourneyExecutor).setThreadFactory(new XmageThreadFactory("TOURNEY"));
        this.timeoutExecutor = Executors.newScheduledThreadPool(4);
        ((ThreadPoolExecutor)((Object)this.timeoutExecutor)).setKeepAliveTime(60L, TimeUnit.SECONDS);
        ((ThreadPoolExecutor)((Object)this.timeoutExecutor)).allowCoreThreadTimeOut(true);
        ((ThreadPoolExecutor)((Object)this.timeoutExecutor)).setThreadFactory(new XmageThreadFactory("XMAGE timeout"));
        this.timeoutIdleExecutor = Executors.newScheduledThreadPool(4);
        ((ThreadPoolExecutor)((Object)this.timeoutIdleExecutor)).setKeepAliveTime(60L, TimeUnit.SECONDS);
        ((ThreadPoolExecutor)((Object)this.timeoutIdleExecutor)).allowCoreThreadTimeOut(true);
        ((ThreadPoolExecutor)((Object)this.timeoutIdleExecutor)).setThreadFactory(new XmageThreadFactory("XMAGE timeout_idle"));
        this.serverHealthExecutor = Executors.newSingleThreadScheduledExecutor(new XmageThreadFactory("XMAGE service health"));
    }

    @Override
    public int getActiveThreads(ExecutorService executerService) {
        if (executerService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)executerService).getActiveCount();
        }
        return -1;
    }

    @Override
    public ExecutorService getCallExecutor() {
        return this.callExecutor;
    }

    @Override
    public ExecutorService getTourneyExecutor() {
        return this.tourneyExecutor;
    }

    @Override
    public ExecutorService getGameExecutor() {
        return this.gameExecutor;
    }

    @Override
    public ScheduledExecutorService getTimeoutExecutor() {
        return this.timeoutExecutor;
    }

    @Override
    public ScheduledExecutorService getTimeoutIdleExecutor() {
        return this.timeoutIdleExecutor;
    }

    @Override
    public ScheduledExecutorService getServerHealthExecutor() {
        return this.serverHealthExecutor;
    }

    static class FixedThreadPoolWithException
    extends ThreadPoolExecutor {
        FixedThreadPoolWithException(int nThreads) {
            super(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            t = ThreadUtils.findRunnableException(r, t);
            if (t != null && !(t instanceof CancellationException)) {
                logger.error((Object)("Catch unhandled error in GAME thread: " + t.getMessage()), t);
            }
        }
    }

    static class CachedThreadPoolWithException
    extends ThreadPoolExecutor {
        CachedThreadPoolWithException() {
            super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            t = ThreadUtils.findRunnableException(r, t);
            if (t != null && !(t instanceof CancellationException)) {
                logger.error((Object)("Catch unhandled error in CALL thread: " + t.getMessage()), t);
            }
        }
    }
}

