/*
 * Decompiled with CFR 0.152.
 */
package mage.client.cards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mage.abilities.icon.CardIcon;
import mage.abilities.icon.CardIconColor;
import mage.abilities.icon.CardIconComparator;
import mage.abilities.icon.CardIconImpl;
import mage.abilities.icon.CardIconOrder;
import mage.abilities.icon.CardIconPosition;
import mage.abilities.icon.CardIconRenderSettings;
import mage.abilities.icon.CardIconType;
import mage.abilities.icon.system.CombinedCountIcon;
import mage.client.components.StretchIcon;
import mage.client.dialog.PreferencesDialog;
import mage.client.util.GUISizeHelper;
import mage.util.DebugUtil;
import org.mage.card.arcane.CardRendererUtils;
import org.mage.card.arcane.ManaSymbols;
import org.mage.card.arcane.SvgUtils;
import org.mage.plugins.card.images.ImageCache;
import org.mage.plugins.card.utils.impl.ImageManagerImpl;

public class CardIconsPanel
extends JPanel {
    private static final CardIconPosition DEFAULT_POSITION = CardIconPosition.LEFT;
    private static final CardIconOrder DEFAULT_ORDER = CardIconOrder.START;
    private static final CardIconColor DEFAULT_COLOR = CardIconColor.DEFAULT;
    private static final int DEFAULT_MAX_VISIBLE_COUNT = 5;
    private static final int DEFAULT_ICON_SIZE_PERCENT = 30;
    private static final int MINIMUM_ICON_SIZE = 32;
    private static final int KEEP_ICON_IN_CARD_INSIDE_PERCENT = 70;
    private static final int MAXIMUM_CARD_WIDTH_FOR_ICONS_SMALL_MODE = 100;
    private final CardIconPosition position;
    private final CardIconOrder order;
    private final CardIconColor color;
    private final int iconSizePercent;
    private final List<CardIcon> icons;
    private final int cellsMaxCount;
    private final int cellsVisibleCount;
    private final int cellsOffset;
    private int iconsGap = 3;
    private int halfSize = 0;
    private Font font = null;
    private int calcedCellsMaxCount = 1;
    private int calcedCellsVisibleCount = 1;
    private int calcedSizeSizePercent = 30;
    private int calcedCellsOffset = 1;
    private CardIconPosition calcedPosition;
    private CardIconOrder calcedOrder;

    public CardIconsPanel(CardIconRenderSettings render) {
        this(render.getCustomPosition() != null ? render.getCustomPosition() : DEFAULT_POSITION, render.getCustomOrder() != null ? render.getCustomOrder() : DEFAULT_ORDER, render.getCustomColor() != null ? render.getCustomColor() : DEFAULT_COLOR, render.getCustomMaxVisibleCount() > 0 ? render.getCustomMaxVisibleCount() : 5, render.getCustomIconSizePercent() > 0 ? render.getCustomIconSizePercent() : 30);
    }

    public CardIconsPanel(CardIconPosition position, CardIconOrder order, CardIconColor color, int cellsVisibleCount, int iconSizePercent) {
        this(position, order, color, cellsVisibleCount, iconSizePercent, new ArrayList<CardIcon>(), new Rectangle(100, 100));
    }

    public CardIconsPanel(CardIconPosition position, CardIconOrder order, CardIconColor color, int cellsVisibleCount, int iconSizePercent, List<CardIcon> icons, Rectangle startingCardSize) {
        super(null);
        this.position = position != null ? position : DEFAULT_POSITION;
        this.color = color != null ? color : DEFAULT_COLOR;
        this.iconSizePercent = iconSizePercent;
        this.icons = icons;
        if (this.position.getMaxIconsAmount() == 1) {
            this.order = CardIconOrder.START;
            this.cellsOffset = 0;
            this.cellsMaxCount = 1;
        } else {
            this.order = order != null ? order : DEFAULT_ORDER;
            this.cellsOffset = 1;
            this.cellsMaxCount = 7;
        }
        int maxIcons = Math.max(1, Math.min(this.cellsMaxCount, cellsVisibleCount));
        this.cellsVisibleCount = Math.min(maxIcons, this.position.getMaxIconsAmount());
        this.setVisible(false);
        this.setOpaque(false);
        if (DebugUtil.GUI_CARD_ICONS_DRAW_PANEL_BORDER) {
            this.setBorder(BorderFactory.createLineBorder(Color.red));
        }
        this.updateSizes(startingCardSize);
    }

    public void updateSizes(Rectangle cardSize) {
        Point panelTranslate;
        Rectangle panelRect;
        this.calcSizes(cardSize);
        int panelFullSize = this.halfSize * 2 + cardSize.height;
        int panelIconSize = (panelFullSize - 8 * this.iconsGap) / 7;
        int cornerHalfSize = Math.min(panelIconSize, this.halfSize * 2) / 2;
        int panelOffset = Math.round((float)(this.halfSize * 2 * 70) / 100.0f) - this.halfSize;
        switch (this.calcedPosition) {
            case TOP: {
                panelRect = new Rectangle(cardSize.x - this.halfSize, cardSize.y - this.halfSize, cardSize.width + this.halfSize * 2, this.halfSize * 2);
                panelTranslate = new Point(0, panelOffset);
                this.setLayout(new GridLayout(1, this.calcedCellsMaxCount, this.iconsGap, 0));
                break;
            }
            case LEFT: {
                panelRect = new Rectangle(cardSize.x - this.halfSize, cardSize.y - this.halfSize, this.halfSize * 2, cardSize.height + this.halfSize * 2);
                panelTranslate = new Point(panelOffset, 0);
                this.setLayout(new GridLayout(this.calcedCellsMaxCount, 1, 0, this.iconsGap));
                break;
            }
            case RIGHT: {
                panelRect = new Rectangle(cardSize.x + cardSize.width - this.halfSize, cardSize.y - this.halfSize, this.halfSize * 2, cardSize.height + this.halfSize * 2);
                panelTranslate = new Point(-panelOffset, 0);
                this.setLayout(new GridLayout(this.calcedCellsMaxCount, 1, 0, this.iconsGap));
                break;
            }
            case BOTTOM: {
                panelRect = new Rectangle(cardSize.x - this.halfSize, cardSize.y + cardSize.height - this.halfSize, cardSize.width + this.halfSize * 2, this.halfSize * 2);
                panelTranslate = new Point(0, -panelOffset);
                this.setLayout(new GridLayout(1, this.calcedCellsMaxCount, this.iconsGap, 0));
                break;
            }
            case CORNER_TOP_LEFT: {
                panelRect = new Rectangle(cardSize.x - cornerHalfSize, cardSize.y - cornerHalfSize, cornerHalfSize * 2, cornerHalfSize * 2);
                panelTranslate = new Point(panelOffset, panelOffset);
                this.setLayout(new GridLayout(1, 1, 0, 0));
                break;
            }
            case CORNER_TOP_RIGHT: {
                panelRect = new Rectangle(cardSize.x + cardSize.width - cornerHalfSize, cardSize.y - cornerHalfSize, cornerHalfSize * 2, cornerHalfSize * 2);
                panelTranslate = new Point(-panelOffset, panelOffset);
                this.setLayout(new GridLayout(1, 1, 0, 0));
                break;
            }
            case CORNER_BOTTOM_LEFT: {
                panelRect = new Rectangle(cardSize.x - cornerHalfSize, cardSize.y + cardSize.height - cornerHalfSize, cornerHalfSize * 2, cornerHalfSize * 2);
                panelTranslate = new Point(panelOffset, -panelOffset);
                this.setLayout(new GridLayout(1, 1, 0, 0));
                break;
            }
            case CORNER_BOTTOM_RIGHT: {
                panelRect = new Rectangle(cardSize.x + cardSize.width - cornerHalfSize, cardSize.y + cardSize.height - cornerHalfSize, cornerHalfSize * 2, cornerHalfSize * 2);
                panelTranslate = new Point(-panelOffset, -panelOffset);
                this.setLayout(new GridLayout(1, 1, 0, 0));
                break;
            }
            default: {
                throw new IllegalArgumentException("Card icons do not support position " + (Object)((Object)this.calcedPosition));
            }
        }
        panelRect.translate(panelTranslate.x, panelTranslate.y);
        this.setBounds(panelRect);
        this.updateIcons();
    }

    public void updateIcons() {
        this.updateIcons(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateIcons(List<CardIcon> newIcons) {
        this.removeAll();
        if (newIcons != null) {
            this.icons.clear();
            TreeMap cardIconMap = new TreeMap();
            newIcons.forEach(icon -> cardIconMap.computeIfAbsent(icon.getIconType(), k -> new ArrayList()).add(icon));
            for (Map.Entry entry : cardIconMap.entrySet()) {
                List combined = ((List)entry.getValue()).stream().filter(icon -> icon != null && icon.canBeCombined()).sorted(CardIconComparator.instance).collect(Collectors.toList());
                if (combined.size() > 1) {
                    ((List)entry.getValue()).removeAll(combined);
                    String combinedHint = combined.stream().map(CardIcon::getCombinedInfo).collect(Collectors.joining("<br>"));
                    CardIconImpl combinedIcon = new CardIconImpl((CardIconType)((Object)entry.getKey()), combinedHint);
                    this.icons.add(combinedIcon);
                    this.icons.addAll((Collection)entry.getValue());
                    continue;
                }
                this.icons.addAll((Collection)entry.getValue());
            }
        }
        if (this.icons.isEmpty()) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        int actualMaxVisibleCount = Math.min(this.calcedCellsVisibleCount, this.calcedCellsMaxCount - this.calcedCellsOffset * 2);
        ArrayList<Component> visibleComponents = new ArrayList<Component>();
        ArrayList combinedComponents = new ArrayList();
        ArrayList<Component> orderedComponents = new ArrayList<Component>();
        HashMap cardLinks = new HashMap();
        this.icons.stream().sorted(CardIconComparator.instance).forEach(icon -> {
            Component iconComponent = this.createIconComponent((CardIcon)icon);
            if (iconComponent != null) {
                visibleComponents.add(iconComponent);
                cardLinks.put(iconComponent, icon);
            }
        });
        if (visibleComponents.size() > actualMaxVisibleCount) {
            while (visibleComponents.size() > actualMaxVisibleCount - 1) {
                combinedComponents.add(visibleComponents.remove(visibleComponents.size() - 1));
            }
            String combinedHint = combinedComponents.stream().map(cardLinks::get).filter(Objects::nonNull).sorted(CardIconComparator.instance).map(CardIcon::getCombinedInfo).collect(Collectors.joining("<br>"));
            CombinedCountIcon combinedIcon = new CombinedCountIcon(combinedComponents.size(), combinedHint);
            Component combinedComponent = this.createIconComponent(combinedIcon);
            if (combinedComponent != null) {
                visibleComponents.add(combinedComponent);
            }
        }
        if (this.calcedOrder == CardIconOrder.START || this.calcedOrder == CardIconOrder.END) {
            for (int i2 = 0; i2 < this.calcedCellsOffset; ++i2) {
                JPanel panel = new JPanel(null);
                panel.setOpaque(false);
                visibleComponents.add(0, panel);
            }
        }
        while (visibleComponents.size() < this.calcedCellsMaxCount) {
            JPanel panel = new JPanel(null);
            panel.setOpaque(false);
            visibleComponents.add(panel);
        }
        if (this.calcedOrder == CardIconOrder.CENTER) {
            if (this.calcedCellsMaxCount == 1) {
                Arrays.asList(1).forEach(i -> orderedComponents.add((Component)visibleComponents.get(i - 1)));
            } else if (this.calcedCellsMaxCount == 3) {
                Arrays.asList(2, 1, 3).forEach(i -> orderedComponents.add((Component)visibleComponents.get(i - 1)));
            } else if (this.calcedCellsMaxCount == 5) {
                Arrays.asList(4, 2, 1, 3, 5).forEach(i -> orderedComponents.add((Component)visibleComponents.get(i - 1)));
            } else {
                if (this.calcedCellsMaxCount != 7) throw new IllegalArgumentException("Card icons do not support max size as " + this.calcedCellsMaxCount);
                Arrays.asList(6, 4, 2, 1, 3, 5, 7).forEach(i -> orderedComponents.add((Component)visibleComponents.get(i - 1)));
            }
        } else if (this.calcedOrder == CardIconOrder.START) {
            orderedComponents.addAll(visibleComponents);
        } else {
            if (this.calcedOrder != CardIconOrder.END) throw new IllegalArgumentException("Card icons do not support order type " + (Object)((Object)this.calcedOrder));
            orderedComponents.addAll(visibleComponents);
            Collections.reverse(orderedComponents);
        }
        orderedComponents.forEach(this::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component createIconComponent(CardIcon icon) {
        if (!SvgUtils.haveSvgSupport()) {
            return null;
        }
        BufferedImage iconImageCached = ImageCache.getCardIconImage(icon.getIconType().getResourceName(), this.halfSize * 2, this.color.toString()).getImage();
        if (iconImageCached != null && this.font != null) {
            BufferedImage iconImageWithText = ImageManagerImpl.deepCopy(iconImageCached);
            String hint = ManaSymbols.replaceSymbolsWithHTML(icon.getHint(), ManaSymbols.Type.CARD_ICON_HINT);
            hint = GUISizeHelper.textToHtmlWithSize(hint, GUISizeHelper.cardTooltipFont.getSize());
            JLabel label = new JLabel();
            label.setToolTipText("<html>" + hint);
            if (!icon.getText().isEmpty()) {
                Graphics2D g2 = iconImageWithText.createGraphics();
                try {
                    g2.setColor(PreferencesDialog.getCurrentTheme().getCardIconsTextColor(this.color));
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    Rectangle rect = CardRendererUtils.reduceRect(new Rectangle(0, 0, iconImageWithText.getWidth(), iconImageWithText.getHeight()), 0.8f);
                    CardRendererUtils.drawCenteredText(g2, icon.getText(), rect, this.font, true);
                }
                finally {
                    g2.dispose();
                }
            }
            StretchIcon s = new StretchIcon((Image)iconImageWithText, true);
            label.setIcon(s);
            label.setIconTextGap(0);
            if (DebugUtil.GUI_CARD_ICONS_DRAW_ICON_BORDER) {
                label.setBorder(BorderFactory.createLineBorder(Color.green));
            }
            return label;
        }
        return null;
    }

    private void calcSizes(Rectangle cardSize) {
        boolean smallMode = false;
        int minW = GUISizeHelper.battlefieldCardMinDimension.width;
        int maxW = GUISizeHelper.battlefieldCardMaxDimension.width;
        if (minW > maxW) {
            maxW = GUISizeHelper.battlefieldCardMinDimension.width;
            minW = GUISizeHelper.battlefieldCardMaxDimension.width;
        }
        if (cardSize.width < 100 && (float)cardSize.width < (float)minW + (float)(maxW - minW) * 0.2f) {
            smallMode = true;
        }
        this.calcedSizeSizePercent = this.iconSizePercent;
        if (smallMode) {
            this.calcedSizeSizePercent = Math.round((float)this.calcedSizeSizePercent * 1.5f);
        }
        this.calcedCellsMaxCount = this.cellsMaxCount;
        this.calcedCellsVisibleCount = this.cellsVisibleCount;
        this.calcedCellsOffset = this.cellsOffset;
        this.calcedPosition = this.position;
        this.calcedOrder = this.order;
        if (smallMode) {
            this.calcedCellsMaxCount = Math.min(5, this.calcedCellsMaxCount);
            this.calcedCellsVisibleCount = Math.min(1, this.calcedCellsVisibleCount);
            this.calcedCellsOffset = Math.min(1, this.calcedCellsOffset);
            if (this.calcedPosition.getMaxIconsAmount() > 1) {
                this.calcedOrder = CardIconOrder.CENTER;
            }
        }
        this.iconsGap = Math.floorDiv(cardSize.width, 100) * 2;
        this.halfSize = Math.max(16, Math.round((float)cardSize.width / 100.0f * (float)this.calcedSizeSizePercent / 2.0f));
        this.font = new Font("Arial", 1, Math.round((float)this.halfSize * 1.5f));
    }

    public int getHalfSize() {
        return this.halfSize;
    }
}

