/*
 * Decompiled with CFR 0.152.
 */
package mage.client.cards;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import mage.client.cards.Slice;

public class ManaPieChart
extends JComponent {
    private List<Slice> slices = new ArrayList<Slice>();

    ManaPieChart() {
    }

    ManaPieChart(Integer w, Integer u, Integer b, Integer r, Integer g, Integer c) {
        if (w != null && w > 0) {
            this.slices.add(new Slice(w.intValue(), Color.WHITE));
        }
        if (u != null && u > 0) {
            this.slices.add(new Slice(u.intValue(), Color.BLUE));
        }
        if (b != null && b > 0) {
            this.slices.add(new Slice(b.intValue(), Color.BLACK));
        }
        if (r != null && r > 0) {
            this.slices.add(new Slice(r.intValue(), Color.RED));
        }
        if (g != null && g > 0) {
            this.slices.add(new Slice(g.intValue(), Color.GREEN));
        }
        if (c != null && c > 0) {
            this.slices.add(new Slice(c.intValue(), Color.LIGHT_GRAY));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferred = super.getPreferredSize();
        Dimension minimum = this.getMinimumSize();
        Dimension maximum = this.getMaximumSize();
        preferred.width = Math.min(Math.max(preferred.width, minimum.width), maximum.width);
        preferred.height = Math.min(Math.max(preferred.height, minimum.height), maximum.height);
        return preferred;
    }

    @Override
    public void paint(Graphics g) {
        this.drawPie((Graphics2D)g, this.getBounds(), this.slices.toArray(new Slice[this.slices.size()]));
    }

    void drawPie(Graphics2D g, Rectangle area, Slice[] slices) {
        double total = 0.0;
        for (int i = 0; i < slices.length; ++i) {
            total += slices[i].value;
        }
        if (total == 0.0) {
            return;
        }
        double curValue = 0.0;
        int startAngle = 0;
        int lastAngle = 0;
        for (int i = 0; i < slices.length; ++i) {
            startAngle = lastAngle;
            int arcAngle = (int)(slices[i].value * 360.0 / total);
            g.setColor(slices[i].color);
            g.fillArc(area.x, area.y, area.width - 20, area.height - 20, startAngle, arcAngle);
            curValue += slices[i].value;
            lastAngle += arcAngle;
        }
    }
}

