/*
 * Decompiled with CFR 0.152.
 */
package mage.client.cards;

import java.awt.Dimension;
import java.awt.Point;
import java.util.UUID;
import mage.abilities.icon.CardIconRenderSettings;
import mage.cards.MageCard;
import mage.cards.action.TransferData;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.client.cards.BigCard;
import mage.client.dialog.PreferencesDialog;
import mage.client.plugins.adapters.MageActionCallback;
import mage.client.plugins.impl.Plugins;
import mage.client.util.ClientDefaultSettings;
import mage.util.ThreadUtils;
import mage.view.CardView;

public class VirtualCardInfo {
    CardView cardView;
    MageCard cardComponent;
    BigCard bigCard;
    MageActionCallback actionCallback;
    TransferData data = new TransferData();
    Dimension cardDimension = null;
    int viewMode = 1;

    private void clear() {
        this.cardView = null;
        this.cardComponent = null;
    }

    public void init(String cardName, BigCard bigCard, UUID gameId) {
        CardInfo cardInfo = CardRepository.instance.findCards(cardName).stream().findFirst().orElse(null);
        if (cardInfo == null) {
            this.clear();
            return;
        }
        this.init(new CardView(cardInfo.createCard()), bigCard, gameId);
    }

    public void init(CardView cardView, BigCard bigCard, UUID gameId) {
        this.clear();
        this.bigCard = bigCard != null ? bigCard : new BigCard();
        this.cardDimension = new Dimension(ClientDefaultSettings.dimensions.getFrameWidth(), ClientDefaultSettings.dimensions.getFrameHeight());
        this.actionCallback = (MageActionCallback)Plugins.instance.getActionCallback();
        this.cardView = cardView;
        this.cardComponent = Plugins.instance.getMageCard(this.cardView, this.bigCard, new CardIconRenderSettings(), this.cardDimension, null, true, true, PreferencesDialog.getRenderMode(), true);
        this.cardComponent.update(cardView);
        this.data.setComponent(this.cardComponent);
        this.data.setCard(this.cardView);
        this.data.setGameId(gameId);
    }

    public void setTooltipDelay(int tooltipDelay) {
        this.data.setTooltipDelay(tooltipDelay);
    }

    public void setPopupAutoLocationMode(TransferData.PopupAutoLocationMode mode) {
        this.data.setPopupAutoLocationMode(mode);
    }

    public CardView getCardView() {
        return this.cardView;
    }

    public boolean prepared() {
        ThreadUtils.ensureRunInGUISwingThread();
        return this.cardView != null && this.cardComponent != null && this.actionCallback != null;
    }

    private void updateLocation(Point point) {
        Point newPoint = new Point(point);
        if (this.cardComponent != null) {
            newPoint.translate(50, 50);
        }
        this.data.setLocationOnScreen(newPoint);
    }

    public void onMouseEntered(Point newLocation) {
        if (!this.prepared()) {
            return;
        }
        if (newLocation != null) {
            this.updateLocation(newLocation);
        }
        this.actionCallback.mouseEntered(null, this.data);
    }

    public void onMouseMoved(Point newLocation) {
        if (!this.prepared()) {
            return;
        }
        if (newLocation != null) {
            this.updateLocation(newLocation);
        }
        this.actionCallback.mouseMoved(null, this.data);
    }

    public void onMouseWheel(Point newLocation) {
        if (!this.prepared()) {
            return;
        }
        if (newLocation != null) {
            this.updateLocation(newLocation);
        }
        this.viewMode = -this.viewMode;
        this.actionCallback.mouseWheelMoved(this.viewMode, this.data);
    }

    public void onMouseExited() {
        if (!this.prepared()) {
            return;
        }
        this.actionCallback.mouseExited(null, this.data);
    }
}

