/*
 * Decompiled with CFR 0.152.
 */
package mage.client.chat;

import java.awt.Font;
import java.util.Date;
import mage.client.SessionHandler;
import mage.client.chat.ChatPanelBasic;
import mage.client.components.ColorPane;
import mage.client.util.GUISizeHelper;
import mage.view.ChatMessage;
import org.mage.card.arcane.ManaSymbols;

public class ChatPanelSeparated
extends ChatPanelBasic {
    private ColorPane systemMessagesPane = null;

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.systemMessagesPane != null) {
            this.systemMessagesPane.cleanUp();
        }
    }

    @Override
    public void receiveMessage(String username, String message, Date time, String turnInfo, ChatMessage.MessageType messageType, ChatMessage.MessageColor color) {
        String userColor;
        String textColor;
        String userSeparator = " ";
        StringBuilder text = new StringBuilder();
        switch (messageType) {
            case TALK: 
            case WHISPER_TO: 
            case WHISPER_FROM: 
            case USER_INFO: {
                super.receiveMessage(username, message, time, turnInfo, messageType, color);
                return;
            }
            case STATUS: {
                textColor = "#FFCC33";
                userColor = "#FFCC33";
                break;
            }
            default: {
                userColor = SessionHandler.getUserName().equals(username) ? "#7FFFD4" : "#FF7F50";
                textColor = "White";
                userSeparator = ": ";
            }
        }
        if (time != null) {
            text.append(this.getColoredText("#CCCC33", this.timeFormatter.format(time) + this.getTurnInfoPart(turnInfo) + ": "));
        }
        if (color == ChatMessage.MessageColor.ORANGE) {
            textColor = "Orange";
        }
        if (color == ChatMessage.MessageColor.YELLOW) {
            textColor = "Yellow";
        }
        if (username != null && !username.isEmpty()) {
            text.append(this.getColoredText(userColor, username + userSeparator));
        }
        text.append(this.getColoredText(textColor, ManaSymbols.replaceSymbolsWithHTML(message, ManaSymbols.Type.CHAT)));
        this.systemMessagesPane.append(text.toString());
    }

    public ColorPane getSystemMessagesPane() {
        return this.systemMessagesPane;
    }

    public void setSystemMessagesPane(ColorPane systemMessagesPane) {
        this.systemMessagesPane = systemMessagesPane;
        this.changeGUISize(GUISizeHelper.chatFont);
    }

    @Override
    public void changeGUISize(Font font) {
        if (this.systemMessagesPane != null) {
            this.systemMessagesPane.setFont(font);
        }
        super.changeGUISize(font);
    }
}

