/*
 * Decompiled with CFR 0.152.
 */
package mage.client.chat;

import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.UUID;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.util.IgnoreList;
import mage.interfaces.callback.ClientCallback;
import mage.interfaces.callback.ClientCallbackMethod;
import mage.view.ChatMessage;

public final class LocalCommands {
    private LocalCommands() {
    }

    private static String getRemainingTokens(StringTokenizer st) {
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return String.join((CharSequence)" ", list);
    }

    public static boolean handleLocalCommands(UUID chatId, String text) {
        String command;
        StringTokenizer st = new StringTokenizer(text.trim());
        int tokens = st.countTokens();
        if (tokens == 0) {
            return false;
        }
        String serverAddress = SessionHandler.getSession().getServerHost();
        Optional<Object> response = Optional.empty();
        switch (command = st.nextToken()) {
            case "/ignore": 
            case "\\ignore": {
                String ignoreTarget = LocalCommands.getRemainingTokens(st);
                response = Optional.of(IgnoreList.ignore(serverAddress, ignoreTarget));
                break;
            }
            case "/unignore": 
            case "\\unignore": {
                String unignoreTarget = LocalCommands.getRemainingTokens(st);
                response = Optional.of(IgnoreList.unignore(serverAddress, unignoreTarget));
                break;
            }
        }
        if (response.isPresent()) {
            LocalCommands.displayLocalCommandResponse(chatId, (String)response.get());
            return true;
        }
        return false;
    }

    private static void displayLocalCommandResponse(UUID chatId, String response) {
        String text = "<font color=yellow>" + response + "</font>";
        ClientCallback chatMessage = new ClientCallback(ClientCallbackMethod.CHATMESSAGE, chatId, (Object)new ChatMessage("", text, new Date(), null, ChatMessage.MessageColor.BLUE));
        MageFrame.getInstance().onCallback(chatMessage);
    }
}

