/*
 * Decompiled with CFR 0.152.
 */
package mage.client.combat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.SwingUtilities;
import mage.cards.MageCard;
import mage.client.MageFrame;
import mage.client.game.PlayAreaPanel;
import mage.client.util.SettingsManager;
import mage.client.util.audio.AudioManager;
import mage.client.util.gui.ArrowBuilder;
import mage.view.CardView;
import mage.view.CombatGroupView;

public enum CombatManager {
    instance;

    private final Map<UUID, Integer> combatAttackers = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> combatBlockers = new HashMap<UUID, Integer>();
    private int globalBlockersCount;
    private static final Color ARROW_COLOR_ATTACKER;
    private static final Color ARROW_COLOR_BLOCKED_ATTACKER;
    private Point parentPoint;

    public void showCombat(List<CombatGroupView> combatView, UUID gameId) {
        ArrowBuilder.getBuilder().removeArrowsByType(gameId, ArrowBuilder.Type.COMBAT);
        this.displayArrows(combatView, gameId);
    }

    public void hideCombat(UUID gameId) {
        ArrowBuilder.getBuilder().removeArrowsByType(gameId, ArrowBuilder.Type.COMBAT);
        this.combatAttackers.remove(gameId);
        this.combatBlockers.remove(gameId);
    }

    private void displayArrows(List<CombatGroupView> combatView, UUID gameId) {
        this.parentPoint = null;
        int count = 0;
        this.globalBlockersCount = 0;
        for (CombatGroupView group : combatView) {
            for (CardView attacker : group.getAttackers().values()) {
                this.drawAttacker(group, attacker, gameId);
                ++count;
            }
        }
        this.playAddAttackersSound(gameId, count);
        this.playAddBlockersSound(gameId, this.globalBlockersCount);
    }

    private void playAddAttackersSound(UUID gameId, int count) {
        int prevCount = 0;
        if (this.combatAttackers.containsKey(gameId)) {
            prevCount = this.combatAttackers.get(gameId);
        }
        if (prevCount < count) {
            AudioManager.playAttack();
        }
        this.combatAttackers.put(gameId, count);
    }

    private void drawAttacker(CombatGroupView group, CardView attacker, UUID gameId) {
        for (PlayAreaPanel pa2 : MageFrame.getGamePlayers(gameId).values()) {
            MageCard attackerCard = pa2.getBattlefieldPanel().getPermanentPanels().get(attacker.getId());
            if (attackerCard == null) continue;
            this.drawDefender(group, attackerCard, gameId);
            this.drawBlockers(group, attackerCard, gameId);
        }
    }

    private void drawDefender(CombatGroupView group, MageCard attackerCard, UUID gameId) {
        UUID defenderId = group.getDefenderId();
        if (defenderId != null) {
            Color attackColor = group.isBlocked() ? ARROW_COLOR_BLOCKED_ATTACKER : ARROW_COLOR_ATTACKER;
            this.parentPoint = this.getParentPoint(attackerCard);
            PlayAreaPanel p = MageFrame.getGamePlayers(gameId).get(defenderId);
            if (p != null) {
                Point target = p.getLocationOnScreen();
                target.translate(-this.parentPoint.x, -this.parentPoint.y);
                Point attackerPoint = attackerCard.getCardLocationOnScreen().getCardPoint();
                attackerPoint.translate(-this.parentPoint.x, -this.parentPoint.y);
                ArrowBuilder.getBuilder().addArrow(gameId, (int)attackerPoint.getX() + 45, (int)attackerPoint.getY() + 25, (int)target.getX() + 40, (int)target.getY() - 20, attackColor, ArrowBuilder.Type.COMBAT);
            } else {
                for (PlayAreaPanel pa : MageFrame.getGamePlayers(gameId).values()) {
                    MageCard permanent = pa.getBattlefieldPanel().getPermanentPanels().get(defenderId);
                    if (permanent == null) continue;
                    Point target = permanent.getCardLocationOnScreen().getCardPoint();
                    target.translate(-this.parentPoint.x, -this.parentPoint.y);
                    Point attackerPoint = attackerCard.getCardLocationOnScreen().getCardPoint();
                    attackerPoint.translate(-this.parentPoint.x, -this.parentPoint.y);
                    ArrowBuilder.getBuilder().addArrow(gameId, (int)attackerPoint.getX() + 45, (int)attackerPoint.getY() + 25, (int)target.getX() + 40, (int)target.getY() + 10, attackColor, ArrowBuilder.Type.COMBAT);
                }
            }
        }
    }

    private void drawBlockers(CombatGroupView group, MageCard attackerCard, UUID gameId) {
        for (CardView blocker : group.getBlockers().values()) {
            for (PlayAreaPanel pa : MageFrame.getGamePlayers(gameId).values()) {
                MageCard blockerCard = pa.getBattlefieldPanel().getPermanentPanels().get(blocker.getId());
                if (blockerCard == null) continue;
                this.parentPoint = this.getParentPoint(blockerCard);
                Point blockerPoint = blockerCard.getCardLocationOnScreen().getCardPoint();
                blockerPoint.translate(-this.parentPoint.x, -this.parentPoint.y);
                Point attackerPoint = attackerCard.getCardLocationOnScreen().getCardPoint();
                attackerPoint.translate(-this.parentPoint.x, -this.parentPoint.y);
                double yRateA = attackerCard.getCardLocation().getCardHeight() / SettingsManager.instance.getCardSize().height;
                double xRateA = attackerCard.getCardLocation().getCardWidth() / SettingsManager.instance.getCardSize().width;
                double yRateB = blockerCard.getCardLocation().getCardHeight() / SettingsManager.instance.getCardSize().height;
                double xRateB = blockerCard.getCardLocation().getCardWidth() / SettingsManager.instance.getCardSize().width;
                ArrowBuilder.getBuilder().addArrow(gameId, (int)blockerPoint.getX() + (int)(55.0 * xRateB), (int)blockerPoint.getY() + (int)(25.0 * xRateB), (int)attackerPoint.getX() + (int)(70.0 * xRateA), (int)attackerPoint.getY() + (int)(25.0 * yRateA), Color.blue, ArrowBuilder.Type.COMBAT);
                ++this.globalBlockersCount;
            }
        }
    }

    private void playAddBlockersSound(UUID gameId, int count) {
        int prevCount = 0;
        if (this.combatBlockers.containsKey(gameId)) {
            prevCount = this.combatBlockers.get(gameId);
        }
        if (prevCount < count) {
            AudioManager.playBlock();
        }
        this.combatBlockers.put(gameId, count);
    }

    private Point getParentPoint(MageCard permanent) {
        if (this.parentPoint == null) {
            Component parentComponent = SwingUtilities.getRoot((Component)permanent);
            this.parentPoint = parentComponent.getLocationOnScreen();
        }
        return this.parentPoint;
    }

    static {
        ARROW_COLOR_ATTACKER = Color.red;
        ARROW_COLOR_BLOCKED_ATTACKER = Color.gray;
    }
}

