/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import mage.MageObject;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.client.components.LegalityLabel;
import mage.client.util.GUISizeHelper;
import org.apache.log4j.Logger;

public class BracketLegalityLabel
extends LegalityLabel {
    private static final Logger logger = Logger.getLogger(BracketLegalityLabel.class);
    private static final String GROUP_GAME_CHANGES = "Game Changers";
    private static final String GROUP_INFINITE_COMBOS = "Infinite Combos";
    private static final String GROUP_MASS_LAND_DESTRUCTION = "Mass Land Destruction";
    private static final String GROUP_EXTRA_TURN = "Extra Turns";
    private static final String GROUP_TUTORS = "Tutors";
    private static final Map<String, List<Integer>> MAX_GROUP_LIMITS = new LinkedHashMap<String, List<Integer>>();
    private static final String RESOURCE_INFINITE_COMBOS = "brackets/infinite-combos.txt";
    private final String fullName;
    private final String shortName;
    private final int maxLevel;
    private final List<String> foundGameChangers = new ArrayList<String>();
    private final List<String> foundInfiniteCombos = new ArrayList<String>();
    private final List<String> foundMassLandDestruction = new ArrayList<String>();
    private final List<String> foundExtraTurn = new ArrayList<String>();
    private final List<String> foundTutors = new ArrayList<String>();
    private final List<String> badCards = new ArrayList<String>();
    private final List<String> fullGameChanges = new ArrayList<String>();
    private final Set<String> fullInfiniteCombos = new HashSet<String>();

    public BracketLegalityLabel(String fullName, String shortName, int maxLevel) {
        super(shortName, null);
        this.fullName = fullName;
        this.shortName = shortName;
        this.maxLevel = maxLevel;
        this.setPreferredSize(DIM_PREFERRED_1_OF_5);
    }

    @Override
    public List<String> selectCards() {
        return new ArrayList<String>(this.badCards);
    }

    private void validateBracketLevel() {
        this.badCards.clear();
        if (this.foundGameChangers.size() > this.getMaxCardsLimit(GROUP_GAME_CHANGES)) {
            this.badCards.addAll(this.foundGameChangers);
        }
        if (this.foundInfiniteCombos.size() > this.getMaxCardsLimit(GROUP_INFINITE_COMBOS)) {
            this.badCards.addAll(this.foundInfiniteCombos);
        }
        if (this.foundMassLandDestruction.size() > this.getMaxCardsLimit(GROUP_MASS_LAND_DESTRUCTION)) {
            this.badCards.addAll(this.foundMassLandDestruction);
        }
        if (this.foundExtraTurn.size() > this.getMaxCardsLimit(GROUP_EXTRA_TURN)) {
            this.badCards.addAll(this.foundExtraTurn);
        }
        if (this.foundTutors.size() > this.getMaxCardsLimit(GROUP_TUTORS)) {
            this.badCards.addAll(this.foundTutors);
        }
    }

    private Integer getMaxCardsLimit(String groupName) {
        return MAX_GROUP_LIMITS.get(groupName).get(this.maxLevel);
    }

    @Override
    public void validateDeck(Deck deck) {
        this.collectAll(deck);
        this.validateBracketLevel();
        int infoFontHeaderSize = Math.round((float)GUISizeHelper.cardTooltipFont.getSize() * 1.0f);
        int infoFontTextSize = Math.round((float)GUISizeHelper.cardTooltipFont.getSize() * 0.6f);
        Color showColor = this.badCards.isEmpty() ? COLOR_LEGAL : COLOR_NOT_LEGAL;
        ArrayList<String> showInfo = new ArrayList<String>();
        if (this.badCards.isEmpty()) {
            showInfo.add(String.format("<span style='font-weight:bold;font-size:%dpx;'><p>Deck is <span style='color:green;'>GOOD</span> for %s</p></span>", infoFontHeaderSize, this.fullName));
        } else {
            showInfo.add(String.format("<span style='font-weight:bold;font-size:%dpx;'><p>Deck is <span style='color:#BF544A;'>BAD</span> for %s</p></span>", infoFontHeaderSize, this.fullName));
            showInfo.add("<p>(click here to select all bad cards)</p>");
        }
        LinkedHashMap<String, List> groups = new LinkedHashMap<String, List>();
        groups.put(GROUP_GAME_CHANGES + this.getStats(GROUP_GAME_CHANGES), this.foundGameChangers);
        groups.put(GROUP_INFINITE_COMBOS + this.getStats(GROUP_INFINITE_COMBOS), this.foundInfiniteCombos);
        groups.put(GROUP_MASS_LAND_DESTRUCTION + this.getStats(GROUP_MASS_LAND_DESTRUCTION), this.foundMassLandDestruction);
        groups.put(GROUP_EXTRA_TURN + this.getStats(GROUP_EXTRA_TURN), this.foundExtraTurn);
        groups.put(GROUP_TUTORS + this.getStats(GROUP_TUTORS), this.foundTutors);
        groups.forEach((group, cards) -> {
            showInfo.add("<br>");
            showInfo.add("<span style='font-weight:bold;font-size: " + infoFontTextSize + "px;'>" + group + "</span>");
            if (cards.isEmpty()) {
                showInfo.add("<ul style=\"font-size: " + infoFontTextSize + "px; width: " + 400 + "px; padding-left: 10px; margin: 0;\">");
                showInfo.add("<li style=\"margin-bottom: 2px;\">no cards</li>");
                showInfo.add("</ul>");
            } else {
                showInfo.add("<ul style=\"font-size: " + infoFontTextSize + "px; width: " + 400 + "px; padding-left: 10px; margin: 0;\">");
                cards.forEach(s -> showInfo.add(String.format("<li style=\"margin-bottom: 2px;\">%s</li>", s)));
                showInfo.add("</ul>");
            }
        });
        String showText = "<html><body>" + String.join((CharSequence)"\n", showInfo) + "</body></html>";
        this.showState(showColor, showText, false);
    }

    private String getStats(String groupName) {
        int currentAmount = 0;
        switch (groupName) {
            case "Game Changers": {
                currentAmount = this.foundGameChangers.size();
                break;
            }
            case "Infinite Combos": {
                currentAmount = this.foundInfiniteCombos.size();
                break;
            }
            case "Mass Land Destruction": {
                currentAmount = this.foundMassLandDestruction.size();
                break;
            }
            case "Extra Turns": {
                currentAmount = this.foundExtraTurn.size();
                break;
            }
            case "Tutors": {
                currentAmount = this.foundTutors.size();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown group " + groupName);
            }
        }
        int maxAmount = MAX_GROUP_LIMITS.get(groupName).get(this.maxLevel);
        String info = currentAmount > maxAmount ? " (<span style='color:#BF544A;'>%s of %s</span>)" : " (<span>%s of %s</span>)";
        return String.format(info, currentAmount, maxAmount == 99 ? "any" : Integer.valueOf(maxAmount));
    }

    private void collectAll(Deck deck) {
        this.collectGameChangers(deck);
        this.collectInfiniteCombos(deck);
        this.collectMassLandDestruction(deck);
        this.collectExtraTurn(deck);
        this.collectTutors(deck);
    }

    private void collectGameChangers(Deck deck) {
        this.foundGameChangers.clear();
        if (this.fullGameChanges.isEmpty()) {
            this.fullGameChanges.addAll(Arrays.asList("Ad Nauseam", "Ancient Tomb", "Aura Shards", "Bolas's Citadel", "Braids, Cabal Minion", "Demonic Tutor", "Drannith Magistrate", "Chrome Mox", "Coalition Victory", "Consecrated Sphinx", "Crop Rotation", "Cyclonic Rift", "Deflecting Swat", "Enlightened Tutor", "Expropriate", "Field of the Dead", "Fierce Guardianship", "Food Chain", "Force of Will", "Gaea's Cradle", "Gamble", "Gifts Ungiven", "Glacial Chasm", "Grand Arbiter Augustin IV", "Grim Monolith", "Humility", "Imperial Seal", "Intuition", "Jeska's Will", "Jin-Gitaxias, Core Augur", "Kinnan, Bonder Prodigy", "Lion's Eye Diamond", "Mana Vault", "Mishra's Workshop", "Mox Diamond", "Mystical Tutor", "Narset, Parter of Veils", "Natural Order", "Necropotence", "Notion Thief", "Rhystic Study", "Opposition Agent", "Orcish Bowmasters", "Panoptic Mirror", "Seedborn Muse", "Serra's Sanctum", "Smothering Tithe", "Survival of the Fittest", "Sway of the Stars", "Teferi's Protection", "Tergrid, God of Fright", "Thassa's Oracle", "The One Ring", "The Tabernacle at Pendrell Vale", "Underworld Breach", "Urza, Lord High Artificer", "Vampiric Tutor", "Vorinclex, Voice of Hunger", "Yuriko, the Tiger's Shadow", "Winota, Joiner of Forces", "Worldly Tutor"));
        }
        Stream.concat(deck.getCards().stream(), deck.getSideboard().stream()).map(MageObject::getName).filter(this.fullGameChanges::contains).sorted().forEach(this.foundGameChangers::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectInfiniteCombos(Deck deck) {
        this.foundInfiniteCombos.clear();
        if (this.fullInfiniteCombos.isEmpty()) {
            InputStream in = BracketLegalityLabel.class.getClassLoader().getResourceAsStream(RESOURCE_INFINITE_COMBOS);
            if (in == null) {
                throw new RuntimeException("Commander brackets: can't load infinite combos list");
            }
            try {
                InputStreamReader input = new InputStreamReader(in);
                Object object = null;
                try {
                    BufferedReader reader = new BufferedReader(input);
                    Object object2 = null;
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            try {
                                if ((line = line.trim()).startsWith("#")) continue;
                                List<String> cards = Arrays.asList(line.split("@"));
                                if (cards.size() != 2) {
                                    logger.warn((Object)("wrong line format in commander brackets file: " + line));
                                    continue;
                                }
                                Collections.sort(cards);
                                this.fullInfiniteCombos.add(String.join((CharSequence)"@", cards));
                            }
                            finally {
                                line = reader.readLine();
                            }
                        }
                    }
                    catch (Throwable line) {
                        object2 = line;
                        throw line;
                    }
                    finally {
                        if (reader != null) {
                            if (object2 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable line) {
                                    ((Throwable)object2).addSuppressed(line);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                catch (Throwable reader) {
                    object = reader;
                    throw reader;
                }
                finally {
                    if (input != null) {
                        if (object != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable reader) {
                                ((Throwable)object).addSuppressed(reader);
                            }
                        } else {
                            input.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Tokens brackets: can't load infinite combos list - " + e);
            }
        }
        ArrayList<Card> deckCards = new ArrayList<Card>();
        HashSet<Card> foundCards = new HashSet<Card>();
        deckCards.addAll(deck.getCards());
        deckCards.addAll(deck.getSideboard());
        block26: for (Card card1 : deckCards) {
            for (Card card2 : deckCards) {
                if (card1 == card2) continue;
                List<String> names = Arrays.asList(card1.getName(), card2.getName());
                Collections.sort(names);
                String deckCombo = String.join((CharSequence)"@", names);
                if (!this.fullInfiniteCombos.contains(deckCombo)) continue;
                foundCards.add(card1);
                foundCards.add(card2);
                continue block26;
            }
        }
        foundCards.stream().map(MageObject::getName).sorted().forEach(this.foundInfiniteCombos::add);
    }

    private void collectMassLandDestruction(Deck deck) {
        this.foundMassLandDestruction.clear();
        Stream.concat(deck.getCards().stream(), deck.getSideboard().stream()).filter(card -> card.getRules().stream().map(s -> s.toLowerCase(Locale.ENGLISH)).anyMatch(s -> !(!s.contains("destroy") && !s.contains("sacrifice") || !s.contains("all") && !s.contains("x target") && !s.contains("{x} target") || !this.isTextContainsLandName((String)s)))).map(MageObject::getName).sorted().forEach(this.foundMassLandDestruction::add);
    }

    private void collectExtraTurn(Deck deck) {
        this.foundExtraTurn.clear();
        Stream.concat(deck.getCards().stream(), deck.getSideboard().stream()).filter(card -> card.getRules().stream().map(s -> s.toLowerCase(Locale.ENGLISH)).anyMatch(s -> s.contains("extra turn"))).map(MageObject::getName).sorted().forEach(this.foundExtraTurn::add);
    }

    private void collectTutors(Deck deck) {
        this.foundTutors.clear();
        Stream.concat(deck.getCards().stream(), deck.getSideboard().stream()).filter(card -> card.getRules().stream().map(s -> s.toLowerCase(Locale.ENGLISH)).anyMatch(s -> s.contains("search your library") && !this.isTextContainsLandCard((String)s))).map(MageObject::getName).sorted().forEach(this.foundTutors::add);
    }

    private boolean isTextContainsLandCard(String lowerText) {
        return lowerText.contains("basic ") || lowerText.contains("plains card") || lowerText.contains("island card") || lowerText.contains("swamp card") || lowerText.contains("mountain card") || lowerText.contains("forest card");
    }

    private boolean isTextContainsLandName(String lowerText) {
        return lowerText.contains("lands") || lowerText.contains("plains") || lowerText.contains("island") || lowerText.contains("swamp") || lowerText.contains("mountain") || lowerText.contains("forest");
    }

    static {
        MAX_GROUP_LIMITS.put(GROUP_GAME_CHANGES, Arrays.asList(0, 0, 0, 3, 99, 99));
        MAX_GROUP_LIMITS.put(GROUP_INFINITE_COMBOS, Arrays.asList(0, 0, 0, 0, 99, 99));
        MAX_GROUP_LIMITS.put(GROUP_MASS_LAND_DESTRUCTION, Arrays.asList(0, 0, 0, 0, 99, 99));
        MAX_GROUP_LIMITS.put(GROUP_EXTRA_TURN, Arrays.asList(0, 0, 0, 3, 99, 99));
        MAX_GROUP_LIMITS.put(GROUP_TUTORS, Arrays.asList(0, 3, 3, 99, 99, 99));
    }
}

