/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import mage.client.util.Command;
import mage.client.util.GUISizeHelper;

public class HoverButton
extends JPanel
implements MouseListener {
    float guiScaleMod = 1.0f;
    private Image image;
    private Image hoverImage;
    private Image disabledImage;
    private Image selectedImage;
    protected Image overlayImage;
    private Rectangle imageSize;
    private Rectangle buttonSize;
    private String text;
    private boolean textAlwaysVisible = false;
    private int textOffsetY = 0;
    private int textOffsetButtonY = 2;
    private int textOffsetX = -1;
    private int topTextOffsetX = -1;
    private Dimension overlayImageSize;
    private String topText;
    private Image topTextImage;
    private final List<Image> topTextImagesRight = new ArrayList<Image>();
    private String centerText;
    private boolean wasHovered = false;
    private boolean isHovered = false;
    private boolean isSelected = false;
    private boolean drawSet = false;
    private String set = null;
    private Command observer = null;
    private Command onHover = null;
    private Color textColor = Color.white;
    private Color topTextColor = null;
    private final Rectangle centerTextArea;
    private Color centerTextColor = new Color(200, 210, 0, 200);
    private Color origCenterTextColor = new Color(200, 210, 0, 200);
    private final Color textBGColor = Color.black;
    final Font textFont;
    final Font textFontMini;
    final Font textSetFontBoldMini;
    final Font textSetFontBold;
    private boolean useMiniFont = false;
    private boolean alignTextLeft = false;
    Timer faderGainLife = null;
    Timer faderLoseLife = null;
    private int loseX = 0;
    private int gainX = 0;
    private boolean doLoseFade = true;
    private boolean doGainFade = true;

    public HoverButton(String text, Image image, Rectangle size) {
        this(text, image, image, image, image, size);
        if (image == null) {
            throw new IllegalArgumentException("Image can't be null");
        }
    }

    public HoverButton(String text, Image image, Image hover, Image disabled, Rectangle size) {
        this(text, image, hover, null, disabled, size, 1.0f);
    }

    public HoverButton(String text, Image image, Image hover, Image disabled, Rectangle size, float guiScaleMod) {
        this(text, image, hover, null, disabled, size, guiScaleMod);
    }

    public HoverButton(String text, Image image, Image hover, Image selected, Image disabled, Rectangle size) {
        this(text, image, hover, selected, disabled, size, 1.0f);
    }

    public HoverButton(String text, Image image, Image hover, Image selected, Image disabled, Rectangle size, float guiScaleMod) {
        this.image = image;
        this.hoverImage = hover;
        this.selectedImage = selected;
        this.disabledImage = disabled;
        this.imageSize = size;
        this.text = text;
        this.guiScaleMod = guiScaleMod;
        this.setOpaque(false);
        this.addMouseListener(this);
        this.setFont(this.getFont().deriveFont(this.sizeMod(this.getFont().getSize2D())));
        this.centerTextArea = new Rectangle(this.sizeMod(5), this.sizeMod(18), this.sizeMod(75), this.sizeMod(40));
        this.textFont = new Font("Arial", 0, this.sizeMod(12));
        this.textFontMini = new Font("Arial", 0, this.sizeMod(11));
        this.textSetFontBoldMini = new Font("Arial", 1, this.sizeMod(12));
        this.textSetFontBold = new Font("Arial", 1, this.sizeMod(14));
        this.textOffsetY = 0;
        this.textOffsetButtonY = this.sizeMod(2);
        this.textOffsetX = -1;
        this.topTextOffsetX = -1;
    }

    private int sizeMod(int value) {
        return GUISizeHelper.guiSizeScale(value, this.guiScaleMod);
    }

    private float sizeMod(float value) {
        return GUISizeHelper.guiSizeScale(value, this.guiScaleMod);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.isEnabled()) {
            if (this.isHovered || this.textAlwaysVisible) {
                if (this.isHovered) {
                    this.wasHovered = true;
                    this.setCenterColor(Color.YELLOW);
                }
                g.drawImage(this.hoverImage, 0, 0, this.imageSize.width, this.imageSize.height, this);
                if (this.text != null) {
                    if (this.textColor != null) {
                        g2d.setColor(this.textColor);
                    }
                    if (this.useMiniFont) {
                        g2d.setFont(this.textFontMini);
                    } else {
                        g2d.setFont(this.textFont);
                    }
                    this.textOffsetX = this.calculateOffset(g2d);
                    g2d.drawString(this.text, this.textOffsetX, this.textOffsetY);
                }
            } else {
                if (this.wasHovered) {
                    this.wasHovered = false;
                    this.setCenterColor(this.origCenterTextColor);
                }
                g.drawImage(this.image, 0, 0, this.imageSize.width, this.imageSize.height, this);
            }
            if (this.isSelected) {
                if (this.selectedImage != null) {
                    g.drawImage(this.selectedImage, 0, 0, this.imageSize.width, this.imageSize.height, this);
                } else {
                    System.err.println("No selectedImage for button.");
                }
            }
        } else {
            g.drawImage(this.disabledImage, 0, 0, this.imageSize.width, this.imageSize.height, this);
        }
        if (this.topText != null) {
            if (this.useMiniFont) {
                g2d.setFont(this.textFontMini);
            } else {
                g2d.setFont(this.textFont);
            }
            this.topTextOffsetX = this.calculateOffsetForTop(g2d, this.topText);
            g2d.setColor(this.textBGColor);
            g2d.drawString(this.topText, this.topTextOffsetX + this.sizeMod(1), this.sizeMod(14));
            g2d.setColor(this.topTextColor != null ? this.topTextColor : this.textColor);
            g2d.drawString(this.topText, this.topTextOffsetX, this.sizeMod(13));
        }
        if (this.topTextImage != null) {
            g.drawImage(this.topTextImage, this.sizeMod(4), this.sizeMod(3), this);
        }
        int offset = 0;
        for (Image img : this.topTextImagesRight) {
            g.drawImage(img, this.getWidth() - this.sizeMod(20), this.sizeMod(3) + offset, this);
            offset += this.sizeMod(20);
        }
        if (this.centerText != null) {
            g2d.setColor(this.centerTextColor);
            int fontSize = 40;
            int val = Integer.parseInt(this.centerText);
            if (val > 9999) {
                fontSize = 24;
            } else if (val > 999) {
                fontSize = 28;
            } else if (val > 99) {
                fontSize = 34;
            }
            this.drawCenteredStringWOutline(g2d, this.centerText, this.centerTextArea, new Font("Arial", 1, this.sizeMod(fontSize)));
        }
        g2d.setColor(this.textColor);
        if (this.overlayImage != null) {
            g.drawImage(this.overlayImage, (this.imageSize.width - this.overlayImageSize.width) / 2, this.sizeMod(10), this);
        } else if (this.set != null && !this.drawSet) {
            g2d.setFont(this.textSetFontBoldMini);
            g2d.drawString(this.set, this.sizeMod(5), this.sizeMod(25));
        }
        if (this.drawSet && this.set != null) {
            g2d.setFont(this.textSetFontBold);
            int w = (int)((double)this.getWidth() / 2.0);
            int h = (int)((double)this.getHeight() / 2.0);
            int dy = this.overlayImage == null ? this.sizeMod(15) : this.sizeMod(25);
            g2d.translate(w + this.sizeMod(5), h + dy);
            g2d.rotate(-1.5707963267948966);
            g2d.drawString(this.set, 0, 0);
        }
    }

    public void setCenterColor(Color c) {
        this.centerTextColor = c;
    }

    private int calculateOffset(Graphics2D g2d) {
        if (this.textOffsetX == -1) {
            FontRenderContext frc = g2d.getFontRenderContext();
            int textWidth = (int)this.textFont.getStringBounds(this.text, frc).getWidth();
            if (textWidth > this.buttonSize.width) {
                g2d.setFont(this.textFontMini);
                this.useMiniFont = true;
                frc = g2d.getFontRenderContext();
                textWidth = (int)this.textFontMini.getStringBounds(this.text, frc).getWidth();
            }
            this.textOffsetX = this.alignTextLeft ? 0 : (this.imageSize.width - textWidth) / 2;
        }
        return this.textOffsetX;
    }

    private int calculateOffsetForTop(Graphics2D g2d, String text) {
        if (this.topTextOffsetX == -1) {
            FontRenderContext frc = g2d.getFontRenderContext();
            int textWidth = (int)this.textFont.getStringBounds(text, frc).getWidth();
            int neededImageWidth = this.topTextImage == null ? 0 : this.topTextImage.getWidth(this);
            int availableXWidth = this.imageSize.width - neededImageWidth;
            this.topTextOffsetX = (availableXWidth - textWidth) / 2 + neededImageWidth;
        }
        return this.topTextOffsetX;
    }

    public void setTopTextColor(Color textColor) {
        this.topTextColor = textColor;
    }

    public void setOverlayImage(Image image) {
        this.overlayImage = image;
        this.overlayImageSize = new Dimension(image.getWidth(null), image.getHeight(null));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isHovered = true;
        this.repaint();
        if (this.onHover != null) {
            this.onHover.execute();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isHovered = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (this.isEnabled() && this.observer != null) {
            this.observer.execute();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void setObserver(Command observer) {
        this.observer = observer;
    }

    public void setOnHover(Command onHover) {
        this.onHover = onHover;
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.textOffsetY = r.height - this.textOffsetButtonY;
        this.buttonSize = r;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.textOffsetY = height - this.textOffsetButtonY;
        this.buttonSize = new Rectangle(x, y, width, height);
    }

    public void setTextOffsetButtonY(int textOffsetButtonY) {
        this.textOffsetButtonY = textOffsetButtonY;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public void changeSelected() {
        this.isSelected = !this.isSelected;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setSet(String set) {
        this.set = set;
    }

    public void drawSet() {
        this.drawSet = true;
    }

    public void update(String text, Image image, Image hover, Image selected, Image disabled, Rectangle size) {
        this.text = text;
        this.image = image;
        this.hoverImage = hover;
        this.selectedImage = selected;
        this.disabledImage = disabled;
        this.imageSize = size;
        this.invalidate();
    }

    public void execute() {
        if (this.isEnabled() && this.observer != null) {
            this.observer.execute();
        }
    }

    public void setTopText(String topText) {
        this.topText = topText;
    }

    public void setTopTextImage(Image topTextImage) {
        this.topTextImage = topTextImage;
        this.textOffsetX = -1;
    }

    public void addTopTextImageRight(Image topTextImage) {
        this.topTextImagesRight.add(topTextImage);
    }

    public void clearTopTextImagesRight() {
        this.topTextImagesRight.clear();
    }

    public void setCenterText(String centerText) {
        this.centerText = centerText;
    }

    public void setTextAlwaysVisible(boolean textAlwaysVisible) {
        this.textAlwaysVisible = textAlwaysVisible;
    }

    public void setAlignTextLeft(boolean alignTextLeft) {
        this.alignTextLeft = alignTextLeft;
    }

    public void drawCenteredStringWOutline(Graphics2D g, String text, Rectangle rect, Font font) {
        FontMetrics metrics = g.getFontMetrics(font);
        int x = rect.x + (rect.width - metrics.stringWidth(text)) / 2;
        int y = rect.y + (rect.height - metrics.getHeight()) / 2 + metrics.getAscent();
        g.setFont(font);
        GlyphVector gv = font.createGlyphVector(g.getFontRenderContext(), text);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.drawGlyphVector(gv, x, y);
        g.translate(x - 1, y - 1);
        for (int i = 0; i < text.length(); ++i) {
            g.setColor(Color.BLACK);
            g.draw(gv.getGlyphOutline(i));
        }
        g.translate(-x + 1, -y + 1);
    }

    public void gainLifeDisplay() {
        if (this.faderGainLife == null && this.doGainFade) {
            this.doGainFade = false;
            this.faderGainLife = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    HoverButton.this.gainX++;
                    int alpha = Math.max(250 - HoverButton.this.gainX, 200);
                    HoverButton.this.setCenterColor(new Color(2 * HoverButton.this.gainX, 210, 255, alpha));
                    HoverButton.this.repaint();
                    if (HoverButton.this.gainX >= 100) {
                        HoverButton.this.setCenterColor(new Color(200, 210, 0, 200));
                        HoverButton.this.gainX = 100;
                        if (HoverButton.this.faderGainLife != null) {
                            HoverButton.this.faderGainLife.stop();
                            HoverButton.this.faderGainLife.setRepeats(false);
                            HoverButton.this.faderGainLife.setDelay(50000);
                        }
                    }
                }
            });
            this.gainX = 0;
            this.faderGainLife.setInitialDelay(25);
            this.faderGainLife.setRepeats(true);
            this.faderGainLife.start();
        }
    }

    public void loseLifeDisplay() {
        if (this.faderLoseLife == null && this.doLoseFade) {
            this.doLoseFade = false;
            this.faderLoseLife = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    HoverButton.this.loseX++;
                    int alpha = Math.max(250 - HoverButton.this.loseX, 200);
                    HoverButton.this.setCenterColor(new Color(250 - HoverButton.this.loseX / 2, 130 + HoverButton.this.loseX, 0, alpha));
                    HoverButton.this.repaint();
                    if (HoverButton.this.loseX >= 100) {
                        HoverButton.this.setCenterColor(new Color(200, 210, 0, 200));
                        HoverButton.this.loseX = 100;
                        HoverButton.this.stopLifeDisplay();
                        if (HoverButton.this.faderLoseLife != null) {
                            HoverButton.this.faderLoseLife.stop();
                            HoverButton.this.faderLoseLife.setRepeats(false);
                            HoverButton.this.faderLoseLife.setDelay(50000);
                        }
                    }
                }
            });
            this.loseX = 0;
            this.faderLoseLife.setInitialDelay(25);
            this.faderLoseLife.setRepeats(true);
            this.faderLoseLife.start();
        }
    }

    public void stopLifeDisplay() {
        if (this.faderGainLife != null && this.gainX >= 100) {
            this.faderGainLife.stop();
            this.faderGainLife = null;
        }
        this.doGainFade = true;
        if (this.faderLoseLife != null && this.loseX >= 100) {
            this.faderLoseLife.stop();
            this.faderLoseLife = null;
        }
        this.doLoseFade = true;
    }
}

