/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components;

import java.awt.Component;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import mage.client.components.MageComponents;
import mage.util.ThreadUtils;
import org.apache.log4j.Logger;

public class MageUI {
    private static final Logger logger = Logger.getLogger(MageUI.class);
    private final Map<MageComponents, Component> ui = new EnumMap<MageComponents, Component>(MageComponents.class);
    private final Map<MageComponents, Object> sync = new EnumMap<MageComponents, Object>(MageComponents.class);
    public static final ThreadPoolExecutor threadPoolPopups = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            threadCount++;
            Thread thread = new Thread(runnable, "POPUP-" + threadCount);
            thread.setDaemon(true);
            return thread;
        }
    }){

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            t = ThreadUtils.findRunnableException(r, t);
            if (t != null && !(t instanceof CancellationException)) {
                logger.error((Object)("Catch unhandled error in POPUP thread: " + t.getMessage()), t);
            }
        }
    };
    private static int threadCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JButton getButton(MageComponents name) throws InterruptedException {
        Object buttonSync;
        Object object = this.ui;
        synchronized (object) {
            if (this.ui.containsKey((Object)name)) {
                return (JButton)this.ui.get((Object)name);
            }
            buttonSync = new Object();
            this.sync.put(name, buttonSync);
        }
        object = buttonSync;
        synchronized (object) {
            buttonSync.wait();
            if (!this.ui.containsKey((Object)name)) {
                throw new IllegalStateException("Component wasn't initialized. This should not happen.");
            }
            return (JButton)this.ui.get((Object)name);
        }
    }

    public Component getComponent(MageComponents name) throws InterruptedException {
        return this.getComponent(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(MageComponents name, boolean waitComponentInit) throws InterruptedException {
        Object object = this.ui;
        synchronized (object) {
            if (this.ui.containsKey((Object)name)) {
                return this.ui.get((Object)name);
            }
        }
        if (waitComponentInit) {
            Object componentSync = new Object();
            object = this.sync;
            synchronized (object) {
                this.sync.put(name, componentSync);
            }
            object = componentSync;
            synchronized (object) {
                componentSync.wait();
                if (!this.ui.containsKey((Object)name)) {
                    throw new IllegalStateException("Component wasn't initialized. This should not happen.");
                }
                return this.ui.get((Object)name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addButton(MageComponents name, JButton button) {
        Map<MageComponents, Component> map = this.ui;
        synchronized (map) {
            this.ui.put(name, button);
            if (this.sync.containsKey((Object)name)) {
                Object object = this.sync.get((Object)name);
                synchronized (object) {
                    this.sync.get((Object)name).notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeButton(MageComponents name) {
        Map<MageComponents, Component> map = this.ui;
        synchronized (map) {
            this.ui.remove((Object)name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponent(MageComponents name, Component component) {
        Map<MageComponents, Component> map = this.ui;
        synchronized (map) {
            this.ui.put(name, component);
            if (this.sync.containsKey((Object)name)) {
                Object object = this.sync.get((Object)name);
                synchronized (object) {
                    this.sync.get((Object)name).notifyAll();
                }
            }
        }
    }

    public void doClick(MageComponents name) throws InterruptedException {
        this.doClick(name, 0);
    }

    public void doClick(MageComponents name, int waitBeforeClick) throws InterruptedException {
        JButton j = this.getButton(name);
        TimeUnit.MILLISECONDS.sleep(waitBeforeClick);
        while (!j.isEnabled()) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        Thread t = new Thread(() -> j.doClick());
        t.start();
    }

    static {
        threadPoolPopups.prestartAllCoreThreads();
    }
}

