/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components.ext.dlg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import mage.client.components.ext.MessageDialogType;
import mage.client.components.ext.dlg.DialogManager;
import mage.client.components.ext.dlg.DlgParams;
import mage.client.components.ext.dlg.impl.ChoiceDialog;

public class DialogContainer
extends JPanel {
    private static final int X_OFFSET = 30;
    private static final int Y_OFFSET = 30;
    private final BufferedImage shadow = null;
    private Color backgroundColor = new Color(0, 255, 255, 60);
    private int alpha = 50;
    private static final boolean isGradient = false;
    private final TexturePaint tp = null;
    private final Image gradient = null;
    private BufferedImage b;
    private boolean drawContainer = true;
    private final DialogManager.MTGDialogs dialogType;
    private static final long serialVersionUID = 1L;

    public DialogContainer(DialogManager.MTGDialogs dialogType, DlgParams params) {
        this.setOpaque(false);
        this.dialogType = dialogType;
        this.setLayout(null);
        this.drawContainer = true;
        switch (dialogType) {
            case MESSAGE: {
                this.backgroundColor = params.type == MessageDialogType.WARNING ? new Color(255, 0, 0, 90) : new Color(0, 0, 0, 90);
                this.alpha = 0;
                break;
            }
            case CHOICE: {
                this.backgroundColor = new Color(0, 0, 0, 110);
                this.alpha = 0;
                ChoiceDialog dlg = new ChoiceDialog(params, "Choose");
                this.add((Component)((Object)dlg));
                dlg.setLocation(40, 40);
                dlg.updateSize(params.rect.width - 80, params.rect.height - 80);
                break;
            }
            case GRAVEYARD: {
                this.backgroundColor = new Color(0, 0, 0, 110);
                this.alpha = 0;
                ChoiceDialog dlg = new ChoiceDialog(params, "Graveyard");
                this.add((Component)((Object)dlg));
                dlg.setLocation(40, 40);
                dlg.updateSize(params.rect.width - 80, params.rect.height - 80);
                break;
            }
            case EXILE: {
                this.backgroundColor = new Color(250, 250, 250, 50);
                this.alpha = 0;
                ChoiceDialog dlg = new ChoiceDialog(params, "Exile");
                this.add((Component)((Object)dlg));
                dlg.setLocation(40, 40);
                dlg.updateSize(params.rect.width - 80, params.rect.height - 80);
                break;
            }
            case EMBLEMS: {
                this.backgroundColor = new Color(0, 0, 50, 110);
                this.alpha = 0;
                ChoiceDialog dlg = new ChoiceDialog(params, "Command Zone (Commanders, Emblems, and Planes)");
                this.add((Component)((Object)dlg));
                dlg.setLocation(40, 40);
                dlg.updateSize(params.rect.width - 80, params.rect.height - 80);
                break;
            }
        }
    }

    public void cleanUp() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof ChoiceDialog)) continue;
            ((ChoiceDialog)((Object)component)).cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        if (!this.drawContainer) {
            return;
        }
        int x = 30;
        int y = 30;
        int w = this.getWidth() - 60;
        int h = this.getHeight() - 60;
        int arc = 30;
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.shadow != null) {
                int xOffset = (this.shadow.getWidth() - w) / 2;
                int yOffset = (this.shadow.getHeight() - h) / 2;
                g2.drawImage((Image)this.shadow, x - xOffset, y - yOffset, null);
            }
            if (this.alpha != 0) {
                g2.setColor(new Color(255, 255, 255, this.alpha));
                g2.fillRoundRect(x, y, w, h, arc, arc);
            }
            g2.setColor(this.backgroundColor);
            g2.fillRoundRect(x, y, w, h, arc, arc);
            g2.setStroke(new BasicStroke(3.0f));
            g2.setColor(Color.BLACK);
            g2.drawRoundRect(x, y, w, h, arc, arc);
        }
        finally {
            g2.dispose();
        }
    }

    public void showDialog(boolean bShow) {
        this.setVisible(bShow);
    }

    public DialogManager.MTGDialogs getType() {
        return this.dialogType;
    }
}

