/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components.ext.dlg;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import mage.client.cards.BigCard;
import mage.client.components.ext.dlg.DialogContainer;
import mage.client.components.ext.dlg.DlgParams;
import mage.view.CardsView;

public class DialogManager
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final Map<UUID, DialogManager> dialogManagers = new HashMap<UUID, DialogManager>();
    private MTGDialogs currentDialog = MTGDialogs.NONE;
    private DialogContainer dialogContainer = null;
    private int screen_width = 0;
    private int screen_height = 0;
    private boolean bDragged = false;
    private int dx;
    private int dy;
    private int mx;
    private int my;
    private Rectangle rec;
    private Rectangle oldRec;
    private JComponent j;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DialogManager getManager(UUID gameId) {
        if (!dialogManagers.containsKey(gameId)) {
            Map<UUID, DialogManager> map = dialogManagers;
            synchronized (map) {
                if (!dialogManagers.containsKey(gameId)) {
                    DialogManager dialogManager = new DialogManager();
                    dialogManager.screen_width = 768;
                    dialogManager.screen_height = 1024;
                    dialogManager.setBounds(0, 0, 768, 1024);
                    dialogManager.setVisible(false);
                    dialogManagers.put(gameId, dialogManager);
                }
            }
        }
        return dialogManagers.get(gameId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeGame(UUID gameId) {
        if (dialogManagers.containsKey(gameId)) {
            Map<UUID, DialogManager> map = dialogManagers;
            synchronized (map) {
                DialogManager dialogManager = dialogManagers.get(gameId);
                dialogManager.cleanUp();
                dialogManagers.remove(gameId);
            }
        }
    }

    public DialogManager() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void cleanUp() {
        this.currentDialog = null;
        if (this.dialogContainer != null) {
            this.dialogContainer.cleanUp();
            this.dialogContainer = null;
        }
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public void setScreenWidth(int screen_width) {
        this.screen_width = screen_width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateParams(int width, int height, boolean isVisible) {
        Map<UUID, DialogManager> map = dialogManagers;
        synchronized (map) {
            for (DialogManager dialogManager : dialogManagers.values()) {
                dialogManager.screen_width = width;
                dialogManager.screen_height = height;
                dialogManager.setBounds(0, 0, width, height);
            }
        }
    }

    public void setScreenHeight(int screen_height) {
        this.screen_height = screen_height;
    }

    public void showExileDialog(CardsView cards, BigCard bigCard, UUID gameId) {
        int w = 720;
        int h = 550;
        int height = this.getHeight();
        int width = this.getWidth();
        int x = (width - w) / 2;
        int y = (height - h) / 2;
        DlgParams params = new DlgParams();
        params.rect = new Rectangle(x, y, w, h);
        params.bigCard = bigCard;
        params.gameId = gameId;
        params.setCards(cards);
        this.dialogContainer = new DialogContainer(MTGDialogs.EXILE, params);
        this.dialogContainer.setVisible(true);
        this.add(this.dialogContainer);
        this.currentDialog = MTGDialogs.DialogContainer;
        this.setDlgBounds(new Rectangle(x, y, w, h));
        this.dialogContainer.showDialog(true);
        this.setVisible(true);
    }

    public void showEmblemsDialog(CardsView cards, BigCard bigCard, UUID gameId) {
        int w = 720;
        int h = 550;
        int height = this.getHeight();
        int width = this.getWidth();
        int x = (width - w) / 2;
        int y = (height - h) / 2;
        DlgParams params = new DlgParams();
        params.rect = new Rectangle(x, y, w, h);
        params.bigCard = bigCard;
        params.gameId = gameId;
        params.setCards(cards);
        this.dialogContainer = new DialogContainer(MTGDialogs.EMBLEMS, params);
        this.dialogContainer.setVisible(true);
        this.add(this.dialogContainer);
        this.currentDialog = MTGDialogs.DialogContainer;
        this.setDlgBounds(new Rectangle(x, y, w, h));
        this.dialogContainer.showDialog(true);
        this.setVisible(true);
    }

    public void setDlgBounds(Rectangle r) {
        if (this.currentDialog == MTGDialogs.DialogContainer) {
            this.dialogContainer.setBounds(r.x, r.y, r.width, r.height);
        }
    }

    public void fadeOut() {
        if (this.dialogContainer != null) {
            this.dialogContainer.showDialog(false);
            this.removeAll();
        }
        this.currentDialog = MTGDialogs.NONE;
        this.setVisible(false);
        this.repaint();
    }

    public void fadeOut(DialogContainer dc) {
        dc.showDialog(false);
        this.remove(dc);
        Component[] components = this.getComponents();
        boolean bFound = false;
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof DialogContainer)) continue;
            bFound = true;
        }
        if (!bFound) {
            this.setVisible(false);
        }
        this.validate();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.bDragged) {
            int i;
            this.dx = e.getX() - this.mx;
            this.dy = e.getY() - this.my;
            this.rec.x += this.dx;
            this.rec.y += this.dy;
            this.mx = e.getX();
            this.my = e.getY();
            if (this.oldRec == null) {
                this.oldRec = new Rectangle(this.rec);
            }
            if ((i = Math.abs(this.oldRec.x - this.rec.x) + Math.abs(this.oldRec.y - this.rec.y)) > 3) {
                this.oldRec = new Rectangle(this.rec);
                this.j.setBounds(this.oldRec);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.j = (JComponent)this.getComponentAt(e.getX(), e.getY());
        if (this.j instanceof DialogContainer) {
            this.rec = this.j.getBounds();
            this.bDragged = true;
            this.mx = e.getX();
            this.my = e.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.bDragged = false;
        if (this.j instanceof DialogManager) {
            return;
        }
        if (this.j != null && this.rec != null) {
            this.j.setBounds(this.rec);
        }
        this.oldRec = null;
        if (this.rec == null) {
            return;
        }
        if (this.rec.x < 0) {
            this.rec.x = 0;
            if (this.j != null) {
                this.j.setBounds(this.rec);
            }
        }
        if (this.rec.y < 0) {
            this.rec.y = 0;
            if (this.j != null) {
                this.j.setBounds(this.rec);
            }
        }
        this.j = null;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
    }

    public static enum MTGDialogs {
        NONE,
        ABOUT,
        MESSAGE,
        ASSIGN_DAMAGE,
        MANA_CHOICE,
        CHOICE,
        EMBLEMS,
        GRAVEYARD,
        DialogContainer,
        COMBAT,
        CHOOSE_DECK,
        CHOOSE_COMMON,
        REVEAL,
        EXILE;

    }
}

