/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components.ext.dlg.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.UUID;
import javax.swing.JButton;
import mage.abilities.icon.CardIconRenderSettings;
import mage.cards.MageCard;
import mage.client.cards.BigCard;
import mage.client.components.HoverButton;
import mage.client.components.ext.ShadowLabel;
import mage.client.components.ext.dlg.DialogContainer;
import mage.client.components.ext.dlg.DialogManager;
import mage.client.components.ext.dlg.DlgParams;
import mage.client.components.ext.dlg.IDialogPanel;
import mage.client.dialog.PreferencesDialog;
import mage.client.plugins.impl.Plugins;
import mage.client.util.Command;
import mage.client.util.SettingsManager;
import mage.client.util.audio.AudioManager;
import mage.view.CardView;
import mage.view.CardsView;
import org.mage.plugins.card.utils.impl.ImageManagerImpl;

public class ChoiceDialog
extends IDialogPanel {
    private static final long serialVersionUID = 1L;
    private ShadowLabel jTitle = null;
    private HoverButton jButtonOK = null;
    private HoverButton jButtonPrevPage = null;
    private HoverButton jButtonNextPage = null;
    private HoverButton jButtonCancel = null;
    private JButton jButtonSort = null;
    private final CardsView cards;
    private final UUID gameId;
    private int page = 1;
    private int maxPages;
    private int in_a_row = 4;
    private int rows = 2;
    private boolean isOptional = false;
    private boolean isChooseAbility = false;
    private boolean isCancelStopsPlaying = true;
    private final DlgParams params;
    private final String title;

    public ChoiceDialog(DlgParams params, String title) {
        super(params);
        this.params = params;
        this.gameId = params.gameId;
        this.title = title;
        this.cards = params.getCards();
        this.isOptional = params.isOptional();
        this.isCancelStopsPlaying = params.isCancelStopsPlaying();
        this.isChooseAbility = params.isChooseAbility();
        this.in_a_row = 5;
        this.rows = 2;
        this.maxPages = this.cards.size() / (this.in_a_row * this.rows);
        if (this.cards.size() % (this.in_a_row * this.rows) != 0) {
            ++this.maxPages;
        }
        this.initialize();
    }

    private void initialize() {
        this.jTitle = new ShadowLabel(this.title, 14);
        this.jTitle.setBounds(new Rectangle(5, 4, 500, 16));
        this.jTitle.setFont(new Font("Dialog", 1, 14));
        this.setLayout(null);
        this.add(this.jTitle, null);
        this.add(this.getJButtonOK(), null);
        this.add(this.getJButtonPrevPage(), null);
        this.add(this.getJButtonNextPage(), null);
        this.add(this.getJButtonSort(), null);
        this.add(this.getJButtonCancel(), null);
        this.makeTransparent();
        this.displayCards(this.params.getCards(), this.params.gameId, this.params.bigCard);
    }

    public void cleanUp() {
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof MageCard)) continue;
            ((MageCard)comp).cleanUp();
            this.remove(comp);
        }
    }

    private void displayCards(CardsView cards, UUID gameId, BigCard bigCard) {
        if (cards.isEmpty()) {
            return;
        }
        ArrayList<Component> toRemove = new ArrayList<Component>();
        for (int i = this.getComponentCount() - 1; i > 0; --i) {
            Component o = this.getComponent(i);
            if (!(o instanceof MageCard)) continue;
            toRemove.add(o);
        }
        for (Component aToRemove : toRemove) {
            this.remove(aToRemove);
        }
        ArrayList cardList = new ArrayList(cards.values());
        int width = SettingsManager.instance.getCardSize().width;
        int height = SettingsManager.instance.getCardSize().height;
        int dx = 0;
        int dy = 30;
        int startIndex = (this.page - 1) * (this.in_a_row * this.rows);
        int countPerPage = this.in_a_row * this.rows;
        int j = 0;
        for (int i = startIndex; i < cards.size() && i < startIndex + countPerPage; ++i) {
            if (i > startIndex && i % this.in_a_row == 0) {
                ++j;
                dx = 0;
            }
            CardView card = (CardView)cardList.get(i);
            MageCard cardImg = Plugins.instance.getMageCard(card, bigCard, new CardIconRenderSettings(), this.getCardDimension(), gameId, true, true, PreferencesDialog.getRenderMode(), true);
            cardImg.setCardContainerRef((Container)((Object)this));
            cardImg.update(card);
            cardImg.setCardBounds(dx, dy + j * (height + 30), width, height);
            this.add((Component)cardImg);
            dx += width + 20;
        }
        this.repaint();
    }

    private HoverButton getJButtonOK() {
        if (this.jButtonOK == null) {
            this.jButtonOK = new HoverButton("", ImageManagerImpl.instance.getDlgAcceptButtonImage(), ImageManagerImpl.instance.getDlgActiveAcceptButtonImage(), ImageManagerImpl.instance.getDlgAcceptButtonImage(), new Rectangle(60, 60));
            int w = this.getDlgParams().rect.width - 75;
            int h = this.getDlgParams().rect.height - 90;
            this.jButtonOK.setBounds(new Rectangle(w / 2 - 40, h - 50, 60, 60));
            this.jButtonOK.setToolTipText("Ok");
            this.jButtonOK.setObserver(() -> DialogManager.getManager(this.gameId).fadeOut((DialogContainer)this.getParent()));
        }
        return this.jButtonOK;
    }

    private HoverButton getJButtonPrevPage() {
        if (this.jButtonPrevPage == null) {
            this.jButtonPrevPage = new HoverButton("", ImageManagerImpl.instance.getDlgPrevButtonImage(), ImageManagerImpl.instance.getDlgActivePrevButtonImage(), ImageManagerImpl.instance.getDlgPrevButtonImage(), new Rectangle(60, 60));
            int w = this.getDlgParams().rect.width - 75;
            int h = this.getDlgParams().rect.height - 90;
            this.jButtonPrevPage.setBounds(new Rectangle(w / 2 - 125, h - 50, 60, 60));
            this.jButtonPrevPage.setVisible(false);
            this.jButtonPrevPage.setObserver(() -> {
                if (this.page == 1) {
                    return;
                }
                AudioManager.playPrevPage();
                --this.page;
                this.getJButtonPrevPage().setVisible(false);
                this.getJButtonOK().setVisible(false);
                this.getJButtonNextPage().setVisible(false);
                this.revalidate();
                this.displayCards(this.params.getCards(), this.params.gameId, this.params.bigCard);
                if (this.page != 1) {
                    this.getJButtonPrevPage().setVisible(true);
                }
                this.getJButtonOK().setVisible(true);
                this.getJButtonNextPage().setVisible(true);
            });
        }
        return this.jButtonPrevPage;
    }

    private HoverButton getJButtonNextPage() {
        if (this.jButtonNextPage == null) {
            this.jButtonNextPage = new HoverButton("", ImageManagerImpl.instance.getDlgNextButtonImage(), ImageManagerImpl.instance.getDlgActiveNextButtonImage(), ImageManagerImpl.instance.getDlgNextButtonImage(), new Rectangle(60, 60));
            int w = this.getDlgParams().rect.width - 75;
            int h = this.getDlgParams().rect.height - 90;
            this.jButtonNextPage.setBounds(new Rectangle(w / 2 + 45, h - 50, 60, 60));
            this.jButtonNextPage.setVisible(this.maxPages > 1);
            this.jButtonNextPage.setObserver(new Command(){
                private static final long serialVersionUID = -3174360416099554104L;

                @Override
                public void execute() {
                    if (ChoiceDialog.this.page == ChoiceDialog.this.maxPages) {
                        return;
                    }
                    AudioManager.playNextPage();
                    ChoiceDialog.this.page++;
                    ChoiceDialog.this.getJButtonPrevPage().setVisible(false);
                    ChoiceDialog.this.getJButtonOK().setVisible(false);
                    ChoiceDialog.this.getJButtonNextPage().setVisible(false);
                    ChoiceDialog.this.revalidate();
                    ChoiceDialog.this.displayCards(ChoiceDialog.this.params.getCards(), ((ChoiceDialog)ChoiceDialog.this).params.gameId, ((ChoiceDialog)ChoiceDialog.this).params.bigCard);
                    ChoiceDialog.this.getJButtonPrevPage().setVisible(true);
                    ChoiceDialog.this.getJButtonOK().setVisible(true);
                    if (ChoiceDialog.this.page != ChoiceDialog.this.maxPages) {
                        ChoiceDialog.this.getJButtonNextPage().setVisible(true);
                    }
                }
            });
        }
        return this.jButtonNextPage;
    }

    private JButton getJButtonSort() {
        if (this.jButtonSort == null) {
            this.jButtonSort = new JButton();
            int w = this.getDlgParams().rect.width - 75;
            int h = this.getDlgParams().rect.height - 75;
            this.jButtonSort.setBounds(new Rectangle(w / 2 + 150, h - 30, 78, 22));
            this.jButtonSort.setText("Sort");
            this.jButtonSort.setVisible(false);
            if (this.maxPages == 1) {
                this.jButtonSort.setVisible(false);
            }
        }
        return this.jButtonSort;
    }

    private HoverButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new HoverButton("", ImageManagerImpl.instance.getDlgCancelButtonImage(), ImageManagerImpl.instance.getDlgActiveCancelButtonImage(), ImageManagerImpl.instance.getDlgCancelButtonImage(), new Rectangle(60, 60));
            int w = this.getDlgParams().rect.width - 75;
            int h = this.getDlgParams().rect.height - 90;
            this.jButtonCancel.setBounds(new Rectangle(w / 2 + 150, h - 50, 60, 60));
            this.jButtonCancel.setToolTipText("Cancel");
            this.jButtonCancel.setVisible(this.isOptional);
            if (!this.isCancelStopsPlaying) {
                this.jButtonCancel.setToolTipText("Done (enough)");
                this.jButtonCancel.setBounds(new Rectangle(w / 2 + 150, h - 50, 60, 60));
            }
            this.jButtonCancel.setObserver(new Command(){
                private static final long serialVersionUID = -567322540616089486L;

                @Override
                public void execute() {
                    DialogManager.getManager(ChoiceDialog.this.gameId).fadeOut((DialogContainer)ChoiceDialog.this.getParent());
                }
            });
        }
        return this.jButtonCancel;
    }

    public void changeTitle(String cardName) {
        this.jTitle.setText("Choose a card (by double-click), chosen card: " + cardName);
    }
}

