/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deck.generator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckFormats;
import mage.client.MageFrame;
import mage.client.deck.generator.DeckGeneratorCMC;
import mage.client.deck.generator.RatioAdjustingSliderPanel;
import mage.client.dialog.PreferencesDialog;
import mage.client.util.gui.ColorsChooser;
import mage.client.util.gui.FastSearchUtil;
import mage.client.util.sets.ConstructedFormats;
import org.apache.log4j.Logger;

public class DeckGeneratorDialog {
    private static final Logger logger = Logger.getLogger(DeckGeneratorDialog.class);
    private static JDialog dlg;
    private static String selectedColors;
    private static JComboBox cbSets;
    private static JComboBox cbDeckSize;
    private static JComboBox cbCMC;
    private static JButton btnGenerate;
    private static JButton btnCancel;
    private static JButton btnReset;
    private static JCheckBox cArtifacts;
    private static JCheckBox cSingleton;
    private static JCheckBox cNonBasicLands;
    private static JCheckBox cColorless;
    private static JCheckBox cAdvanced;
    private static JCheckBox cCommander;
    private static JLabel averageCMCLabel;
    private static SimpleDateFormat dateFormat;
    private static RatioAdjustingSliderPanel adjustingSliderPanel;

    public DeckGeneratorDialog() {
        this.initDialog();
        dateFormat = new SimpleDateFormat("dd-MM-yyyy-hh-mm-ss-SSS");
    }

    private void initDialog() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 15, 0, 0);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.1;
        JLabel text = new JLabel("Choose color for your deck:");
        mainPanel.add((Component)text, c);
        c.fill = 2;
        c.weightx = 0.8;
        c.ipadx = 30;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridx = 1;
        c.gridy = 0;
        String chosen = PreferencesDialog.getCachedValue("newDeckGeneratorDeckColors", "u");
        ColorsChooser colorsChooser = new ColorsChooser(chosen);
        mainPanel.add((Component)colorsChooser, c);
        c.insets = new Insets(0, 15, 0, 0);
        c.fill = 2;
        c.weightx = 0.1;
        c.gridx = 2;
        c.gridy = 0;
        c.ipadx = 0;
        JLabel text2 = new JLabel("(X = random color)");
        mainPanel.add(text2);
        JLabel formatSetText = new JLabel("Choose format/set for your deck:");
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.1;
        mainPanel.add((Component)formatSetText, c);
        JPanel setPanel = new JPanel();
        setPanel.setLayout(new BoxLayout(setPanel, 2));
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.ipadx = 30;
        c.insets = new Insets(5, 10, 0, 10);
        c.weightx = 0.8;
        mainPanel.add((Component)setPanel, c);
        cbSets = new JComboBox<Object>(ConstructedFormats.getTypes(false).toArray());
        cbSets.setSelectedIndex(0);
        cbSets.setAlignmentX(0.0f);
        setPanel.add(cbSets);
        String prefSet = PreferencesDialog.getCachedValue("newDeckGeneratorSet", null);
        if (prefSet != null) {
            cbSets.setSelectedItem(prefSet);
        }
        JButton btn = new JButton();
        btn.setIcon(new ImageIcon(this.getClass().getResource("/buttons/search_32.png")));
        btn.setToolTipText("Fast search set or expansion");
        btn.setAlignmentX(1.0f);
        btn.setPreferredSize(new Dimension(32, 32));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FastSearchUtil.showFastSearchForStringComboBox(cbSets, "Select set or expansion");
            }
        });
        c.fill = 2;
        c.insets = new Insets(0, 15, 0, 0);
        c.ipadx = 0;
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.1;
        JLabel textDeckSize = new JLabel("Deck size:");
        mainPanel.add((Component)textDeckSize, c);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 2;
        c.ipadx = 30;
        c.insets = new Insets(5, 10, 0, 10);
        c.weightx = 0.9;
        cbDeckSize = new JComboBox<String>(new String[]{"40", "60", "100"});
        cbDeckSize.setSelectedIndex(0);
        cbDeckSize.setAlignmentX(0.0f);
        mainPanel.add((Component)cbDeckSize, c);
        String prefSize = PreferencesDialog.getCachedValue("newDeckGeneratorDeckSize", "60");
        if (prefSet != null) {
            cbDeckSize.setSelectedItem(prefSize);
        }
        JPanel jCheckBoxes = new JPanel(new FlowLayout(0));
        boolean commanderEnabled = Boolean.parseBoolean(PreferencesDialog.getCachedValue("newDeckGeneratorCommander", "false"));
        cSingleton = new JCheckBox("Singleton", false);
        cSingleton.setToolTipText("Allow only a single copy of each non-land card in your deck.");
        String singletonEnabled = PreferencesDialog.getCachedValue("newDeckGeneratorSingleton", "false");
        cSingleton.setSelected(Boolean.parseBoolean(singletonEnabled));
        jCheckBoxes.add(cSingleton);
        cSingleton.setEnabled(!commanderEnabled);
        cArtifacts = new JCheckBox("Artifacts", false);
        cArtifacts.setToolTipText("Use artifacts and artifact creatures in your deck.");
        String artifactEnabled = PreferencesDialog.getCachedValue("newDeckGeneratorArtifacts", "false");
        cArtifacts.setSelected(Boolean.parseBoolean(artifactEnabled));
        jCheckBoxes.add(cArtifacts);
        cNonBasicLands = new JCheckBox("Non-basic Lands", false);
        cNonBasicLands.setToolTipText("Use non-basic lands in your deck (if applicable).");
        String nonBasicEnabled = PreferencesDialog.getCachedValue("newDeckGeneratorNonBasicLands", "false");
        cNonBasicLands.setSelected(Boolean.parseBoolean(nonBasicEnabled));
        jCheckBoxes.add(cNonBasicLands);
        cColorless = new JCheckBox("Colorless mana", false);
        cColorless.setToolTipText("Allow cards with colorless mana cost.");
        String colorlessEnabled = PreferencesDialog.getCachedValue("newDeckGeneratorColorless", "false");
        cColorless.setSelected(Boolean.parseBoolean(colorlessEnabled));
        jCheckBoxes.add(cColorless);
        c.ipadx = 0;
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 1.0;
        c.gridwidth = 3;
        mainPanel.add((Component)jCheckBoxes, c);
        cCommander = new JCheckBox("Commander", false);
        cCommander.setToolTipText("Add legendary creature as commander");
        cCommander.setSelected(commanderEnabled);
        jCheckBoxes.add(cCommander);
        c.ipadx = 0;
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 1.0;
        c.gridwidth = 3;
        mainPanel.add((Component)jCheckBoxes, c);
        cCommander.addItemListener(itemEvent -> cSingleton.setEnabled(!cCommander.isSelected()));
        JPanel advancedPanel = this.createAdvancedPanel();
        cAdvanced = new JCheckBox("Customize distribution");
        cAdvanced.setToolTipText("Customize cards distribution due mana values and types");
        cAdvanced.addItemListener(itemEvent -> {
            boolean enable = cAdvanced.isSelected();
            this.enableAdvancedPanel(enable);
        });
        String advancedSavedValue = PreferencesDialog.getCachedValue("newDeckGeneratorAdvanced", "false");
        boolean advancedEnabled = Boolean.parseBoolean(advancedSavedValue);
        this.enableAdvancedPanel(advancedEnabled);
        cAdvanced.setSelected(advancedEnabled);
        c.gridy = 4;
        c.weightx = 0.0;
        c.insets = new Insets(10, 15, 10, 0);
        mainPanel.add((Component)cAdvanced, c);
        c.gridy = 5;
        c.weightx = 1.0;
        c.insets = new Insets(5, 10, 0, 5);
        mainPanel.add((Component)advancedPanel, c);
        btnGenerate = new JButton("Ok");
        btnGenerate.addActionListener(e -> {
            btnGenerate.setEnabled(false);
            colorsChooser.setEnabled(false);
            selectedColors = (String)colorsChooser.getSelectedItem();
            dlg.setVisible(false);
            PreferencesDialog.saveValue("newDeckGeneratorDeckColors", selectedColors);
        });
        btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(e -> {
            dlg.setVisible(false);
            selectedColors = null;
        });
        Object[] options = new JButton[]{btnGenerate, btnCancel};
        JOptionPane optionPane = new JOptionPane(mainPanel, -1, -1, null, options, options[1]);
        dlg = optionPane.createDialog("Generating Deck");
        dlg.setResizable(false);
        dlg.setVisible(true);
        if (dlg.isModal()) {
            dlg.dispose();
        }
    }

    private void enableAdvancedPanel(boolean enable) {
        adjustingSliderPanel.setEnabled(enable);
        btnReset.setEnabled(enable);
        cbCMC.setEnabled(enable);
        averageCMCLabel.setEnabled(enable);
    }

    private JPanel createAdvancedPanel() {
        JPanel advancedPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.1;
        averageCMCLabel = new JLabel("Average CMC:");
        advancedPanel.add((Component)averageCMCLabel, c);
        c.fill = 2;
        c.weightx = 0.9;
        c.gridx = 2;
        c.gridy = 0;
        cbCMC = new JComboBox<DeckGeneratorCMC>(DeckGeneratorCMC.values());
        cbCMC.setSelectedItem((Object)DeckGeneratorCMC.Default);
        String cmcSelected = PreferencesDialog.getCachedValue("newDeckGeneratorAdvancedCMC", DeckGeneratorCMC.Default.name());
        cbCMC.setSelectedItem((Object)DeckGeneratorCMC.valueOf(cmcSelected));
        advancedPanel.add((Component)cbCMC, c);
        c.fill = 2;
        c.ipady = 20;
        c.ipadx = 40;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(10, 0, 0, 0);
        adjustingSliderPanel = new RatioAdjustingSliderPanel();
        String creaturePercentage = PreferencesDialog.getCachedValue("newDeckGeneratorCreaturePercentage", Integer.toString(38));
        adjustingSliderPanel.setCreaturePercentage(Integer.parseInt(creaturePercentage));
        String nonCreaturePercentage = PreferencesDialog.getCachedValue("newDeckGeneratorNonCreaturePercentage", Integer.toString(21));
        adjustingSliderPanel.setNonCreaturePercentage(Integer.parseInt(nonCreaturePercentage));
        String landPercentage = PreferencesDialog.getCachedValue("newDeckGeneratorLandPercentage", Integer.toString(41));
        adjustingSliderPanel.setLandPercentage(Integer.parseInt(landPercentage));
        advancedPanel.add((Component)adjustingSliderPanel, c);
        c.fill = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.weightx = 1.0;
        c.anchor = 26;
        c.insets = new Insets(10, 10, 0, 0);
        c.gridx = 2;
        c.gridwidth = 1;
        c.gridy = 2;
        btnReset = new JButton("Reset");
        btnReset.setToolTipText("Reset custom cards distribution to default values");
        btnReset.addActionListener(actionEvent -> {
            cbCMC.setSelectedItem((Object)DeckGeneratorCMC.Default);
            adjustingSliderPanel.resetValues();
        });
        advancedPanel.add((Component)btnReset, c);
        CompoundBorder border = BorderFactory.createCompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10));
        advancedPanel.setBorder(border);
        return advancedPanel;
    }

    public void cleanUp() {
        for (ActionListener actionListener : btnGenerate.getActionListeners()) {
            btnGenerate.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : btnCancel.getActionListeners()) {
            btnCancel.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : btnReset.getActionListeners()) {
            btnReset.removeActionListener(actionListener);
        }
        for (EventListener eventListener : cAdvanced.getItemListeners()) {
            cAdvanced.removeItemListener((ItemListener)eventListener);
        }
    }

    public String saveDeck(Deck deck) {
        try {
            String tempDir = System.getProperty("java.io.tmpdir");
            String deckName = "Generated-Deck-" + dateFormat.format(new Date());
            File tmp = new File(tempDir + File.separator + deckName + ".dck");
            tmp.getParentFile().mkdirs();
            tmp.createNewFile();
            deck.setName(deckName);
            DeckFormats.XMAGE.getExporter().writeDeck(tmp.getAbsolutePath(), deck.prepareCardsOnlyDeck());
            this.cleanUp();
            return tmp.getAbsolutePath();
        }
        catch (Exception e) {
            logger.error((Object)("Can't generate deck due " + e), (Throwable)e);
            MageFrame.getInstance().showErrorDialog("CLIENT - error on random deck save", e);
            return null;
        }
    }

    public String getSelectedFormat() {
        return (String)cbSets.getSelectedItem();
    }

    public boolean isSingleton() {
        boolean selected = cSingleton.isSelected();
        PreferencesDialog.saveValue("newDeckGeneratorSingleton", Boolean.toString(selected));
        return selected;
    }

    public boolean isColorless() {
        boolean selected = cColorless.isSelected();
        PreferencesDialog.saveValue("newDeckGeneratorColorless", Boolean.toString(selected));
        return selected;
    }

    public boolean useArtifacts() {
        boolean selected = cArtifacts.isSelected();
        PreferencesDialog.saveValue("newDeckGeneratorArtifacts", Boolean.toString(selected));
        return selected;
    }

    public boolean useNonBasicLand() {
        boolean selected = cNonBasicLands.isSelected();
        PreferencesDialog.saveValue("newDeckGeneratorNonBasicLands", Boolean.toString(selected));
        return selected;
    }

    public boolean isCommander() {
        boolean selected = cCommander.isSelected();
        PreferencesDialog.saveValue("newDeckGeneratorCommander", Boolean.toString(selected));
        return selected;
    }

    public boolean isAdvanced() {
        boolean selected = cAdvanced.isSelected();
        PreferencesDialog.saveValue("newDeckGeneratorAdvanced", Boolean.toString(selected));
        return selected;
    }

    public int getCreaturePercentage() {
        int percentage = adjustingSliderPanel.getCreaturePercentage();
        PreferencesDialog.saveValue("newDeckGeneratorCreaturePercentage", Integer.toString(percentage));
        return percentage;
    }

    public int getNonCreaturePercentage() {
        int percentage = adjustingSliderPanel.getNonCreaturePercentage();
        PreferencesDialog.saveValue("newDeckGeneratorNonCreaturePercentage", Integer.toString(percentage));
        return percentage;
    }

    public int getLandPercentage() {
        int percentage = adjustingSliderPanel.getLandPercentage();
        PreferencesDialog.saveValue("newDeckGeneratorLandPercentage", Integer.toString(percentage));
        return percentage;
    }

    public int getDeckSize() {
        return Integer.parseInt(cbDeckSize.getSelectedItem().toString());
    }

    public DeckGeneratorCMC getDeckGeneratorCMC() {
        DeckGeneratorCMC selectedCMC = (DeckGeneratorCMC)((Object)cbCMC.getSelectedItem());
        PreferencesDialog.saveValue("newDeckGeneratorAdvancedCMC", selectedCMC.name());
        return selectedCMC;
    }

    public String getSelectedColors() {
        if (selectedColors != null) {
            PreferencesDialog.saveValue("newDeckGeneratorDeckSize", cbDeckSize.getSelectedItem().toString());
            PreferencesDialog.saveValue("newDeckGeneratorSet", cbSets.getSelectedItem().toString());
        }
        return selectedColors;
    }
}

