/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deckeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckCardLayout;
import mage.client.cards.BigCard;
import mage.client.cards.CardEventSource;
import mage.client.cards.DragCardGrid;
import mage.client.constants.Constants;
import mage.client.util.ClientEventType;
import mage.client.util.Event;
import mage.client.util.GUISizeHelper;
import mage.client.util.Listener;
import mage.view.CardView;
import mage.view.CardsView;
import mage.view.SimpleCardView;

public class DeckArea
extends JPanel {
    private final CardEventSource maindeckVirtualEvent = new CardEventSource();
    private final CardEventSource sideboardVirtualEvent = new CardEventSource();
    private final Set<UUID> hiddenCards = new HashSet<UUID>();
    private Deck lastDeck = new Deck();
    private BigCard lastBigCard = null;
    private int dividerLocationNormal = 0;
    private int dividerLocationLimited = 0;
    private JSplitPane deckAreaSplitPane;
    private DragCardGrid deckList;
    private DragCardGrid sideboardList;

    public DeckCardLayout getCardLayout() {
        return this.deckList.getCardLayout();
    }

    public DeckCardLayout getSideboardLayout() {
        return this.sideboardList.getCardLayout();
    }

    public DeckArea() {
        this.initComponents();
        this.deckList.setRole(DragCardGrid.Role.MAINDECK);
        this.sideboardList.setRole(DragCardGrid.Role.SIDEBOARD);
        this.deckList.addDragCardGridListener(new DragCardGrid.DragCardGridListener(){

            @Override
            public void cardsSelected() {
                DeckArea.this.sideboardList.deselectAll();
            }

            @Override
            public void hideCards(Collection<CardView> cards) {
                for (CardView card : cards) {
                    DeckArea.this.hiddenCards.add(card.getId());
                    DeckArea.this.maindeckVirtualEvent.fireEvent((SimpleCardView)card, ClientEventType.DECK_REMOVE_SPECIFIC_CARD);
                    DeckArea.this.sideboardVirtualEvent.fireEvent((SimpleCardView)card, ClientEventType.DECK_ADD_SPECIFIC_CARD);
                }
                DeckArea.this.loadDeck(DeckArea.this.lastDeck, DeckArea.this.lastBigCard);
            }

            @Override
            public void showAll() {
                DeckArea.this.hiddenCards.clear();
                DeckArea.this.loadDeck(DeckArea.this.lastDeck, DeckArea.this.lastBigCard);
            }

            @Override
            public void duplicateCards(Collection<CardView> cards) {
                DeckArea.this.sideboardList.deselectAll();
                for (CardView card : cards) {
                    CardView newCard = new CardView(card);
                    DeckArea.this.deckList.addCardView(newCard, card);
                }
            }

            @Override
            public void invertCardSelection(Collection<CardView> cards) {
                for (CardView card : cards) {
                    card.setSelected(!card.isSelected());
                }
            }
        });
        this.sideboardList.addDragCardGridListener(new DragCardGrid.DragCardGridListener(){

            @Override
            public void cardsSelected() {
                DeckArea.this.deckList.deselectAll();
            }

            @Override
            public void hideCards(Collection<CardView> cards) {
                for (CardView card : cards) {
                    DeckArea.this.hiddenCards.add(card.getId());
                }
                DeckArea.this.loadDeck(DeckArea.this.lastDeck, DeckArea.this.lastBigCard);
            }

            @Override
            public void showAll() {
                DeckArea.this.hiddenCards.clear();
                DeckArea.this.loadDeck(DeckArea.this.lastDeck, DeckArea.this.lastBigCard);
            }

            @Override
            public void duplicateCards(Collection<CardView> cards) {
                DeckArea.this.deckList.deselectAll();
                for (CardView card : cards) {
                    CardView newCard = new CardView(card);
                    DeckArea.this.sideboardList.addCardView(newCard, card);
                }
            }

            @Override
            public void invertCardSelection(Collection<CardView> cards) {
                for (CardView card : cards) {
                    card.setSelected(!card.isSelected());
                }
            }
        });
    }

    public Settings saveSettings(boolean isLimitedBuildingOrientation) {
        Settings settings = new Settings();
        settings.maindeckSettings = this.deckList.saveSettings();
        settings.sideboardSetings = this.sideboardList.saveSettings();
        if (isLimitedBuildingOrientation) {
            this.dividerLocationLimited = this.deckAreaSplitPane.getDividerLocation();
        } else {
            this.dividerLocationNormal = this.deckAreaSplitPane.getDividerLocation();
        }
        settings.dividerLocationLimited = this.dividerLocationLimited;
        settings.dividerLocationNormal = this.dividerLocationNormal;
        return settings;
    }

    public void loadSettings(Settings s, boolean isLimitedBuildingOrientation) {
        if (s != null) {
            this.deckList.loadSettings(s.maindeckSettings);
            this.sideboardList.loadSettings(s.sideboardSetings);
            this.dividerLocationLimited = s.dividerLocationLimited;
            this.dividerLocationNormal = s.dividerLocationNormal;
            if (isLimitedBuildingOrientation) {
                if (this.dividerLocationLimited != 0) {
                    this.deckAreaSplitPane.setDividerLocation(s.dividerLocationLimited);
                }
            } else if (this.dividerLocationNormal != 0) {
                this.deckAreaSplitPane.setDividerLocation(s.dividerLocationNormal);
            }
        }
    }

    public void cleanUp() {
        this.deckList.cleanUp();
        this.sideboardList.cleanUp();
    }

    public void changeGUISize() {
        this.setGUISize();
        this.deckList.changeGUISize();
        this.sideboardList.changeGUISize();
        this.deckAreaSplitPane.setDividerSize(GUISizeHelper.dividerBarSize);
    }

    private void setGUISize() {
    }

    public void setOrientation(boolean isLimitedBuildingOrientation) {
        if (isLimitedBuildingOrientation) {
            this.deckAreaSplitPane.setOrientation(0);
            if (this.dividerLocationLimited != 0) {
                this.deckAreaSplitPane.setDividerLocation(this.dividerLocationLimited);
            }
        } else {
            this.deckAreaSplitPane.setOrientation(1);
            if (this.dividerLocationNormal != 0) {
                this.deckAreaSplitPane.setDividerLocation(this.dividerLocationNormal);
            }
        }
    }

    public void showSideboard(boolean show) {
        this.sideboardList.setVisible(show);
    }

    public void setDeckEditorMode(Constants.DeckEditorMode mode) {
        this.deckList.setDeckEditorMode(mode);
        this.sideboardList.setDeckEditorMode(mode);
    }

    private Set<Card> filterHidden(Set<Card> cards) {
        LinkedHashSet<Card> newSet = new LinkedHashSet<Card>();
        for (Card card : cards) {
            if (this.hiddenCards.contains(card.getId())) continue;
            newSet.add(card);
        }
        return newSet;
    }

    public void loadDeck(Deck deck, BigCard bigCard) {
        this.loadDeck(deck, false, bigCard);
    }

    public void loadDeck(Deck deck, boolean useLayout, BigCard bigCard) {
        this.lastDeck = deck;
        this.lastBigCard = bigCard;
        this.deckList.setCards(new CardsView(this.filterHidden(this.lastDeck.getCards())), useLayout ? deck.getCardsLayout() : null, this.lastBigCard);
        if (this.sideboardList.isVisible()) {
            this.sideboardList.setCards(new CardsView(this.filterHidden(this.lastDeck.getSideboard())), useLayout ? deck.getSideboardLayout() : null, this.lastBigCard);
        }
    }

    public void addDeckEventListener(Listener<Event> listener) {
        this.deckList.addCardEventListener(listener);
        this.maindeckVirtualEvent.addListener(listener);
    }

    public void clearDeckEventListeners() {
        this.deckList.clearCardEventListeners();
    }

    public void addSideboardEventListener(Listener<Event> listener) {
        this.sideboardList.addCardEventListener(listener);
        this.sideboardVirtualEvent.addListener(listener);
    }

    public void clearSideboardEventListeners() {
        this.sideboardList.clearCardEventListeners();
    }

    private void initComponents() {
        this.deckAreaSplitPane = new JSplitPane();
        this.deckList = new DragCardGrid();
        this.sideboardList = new DragCardGrid();
        this.setLayout(new BorderLayout());
        this.deckAreaSplitPane.setBorder(null);
        this.deckAreaSplitPane.setDividerSize(10);
        this.deckAreaSplitPane.setResizeWeight(0.5);
        this.deckList.setMinimumSize(new Dimension(200, 56));
        this.deckAreaSplitPane.setLeftComponent(this.deckList);
        this.sideboardList.setMinimumSize(new Dimension(200, 56));
        this.deckAreaSplitPane.setRightComponent(this.sideboardList);
        this.add((Component)this.deckAreaSplitPane, "Center");
    }

    public DragCardGrid getDeckList() {
        return this.deckList;
    }

    public DragCardGrid getSideboardList() {
        return this.sideboardList;
    }

    public static class Settings {
        public DragCardGrid.Settings maindeckSettings;
        public DragCardGrid.Settings sideboardSetings;
        public int dividerLocationLimited;
        public int dividerLocationNormal;
        private static final Pattern parser = Pattern.compile("([^|]*)\\|([^|]*)\\|([^|]*)\\|([^|]*)");

        public static Settings parse(String s) {
            Matcher m = parser.matcher(s);
            if (m.find()) {
                Settings settings = new Settings();
                settings.maindeckSettings = DragCardGrid.Settings.parse(m.group(1));
                settings.sideboardSetings = DragCardGrid.Settings.parse(m.group(2));
                settings.dividerLocationNormal = Integer.parseInt(m.group(3));
                settings.dividerLocationLimited = Integer.parseInt(m.group(4));
                return settings;
            }
            return null;
        }

        public String toString() {
            return this.maindeckSettings.toString() + '|' + this.sideboardSetings.toString() + '|' + this.dividerLocationNormal + '|' + this.dividerLocationLimited;
        }
    }
}

