/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deckeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.UUID;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import mage.cards.decks.Deck;
import mage.client.MagePane;
import mage.client.constants.Constants;
import mage.client.deckeditor.DeckEditorPanel;
import mage.client.plugins.impl.Plugins;

public class DeckEditorPane
extends MagePane {
    private UUID currentTableId = null;
    private UUID parentTableId = null;
    private DeckEditorPanel deckEditorPanel1;
    private Box.Filler filler1;

    public DeckEditorPane() {
        HashMap<String, JComponent> uiMap;
        JComponent container;
        boolean initialized = false;
        if (Plugins.instance.isThemePluginLoaded() && (container = Plugins.instance.updateTablePanel(uiMap = new HashMap<String, JComponent>())) != null) {
            this.deckEditorPanel1 = new DeckEditorPanel();
            this.initComponents(container);
            container.add(this.deckEditorPanel1);
            container.setOpaque(false);
            this.deckEditorPanel1.setOpaque(false);
            initialized = true;
        }
        if (!initialized) {
            this.initComponents();
        }
    }

    @Override
    public void changeGUISize() {
        super.changeGUISize();
        this.deckEditorPanel1.changeGUISize();
    }

    public void show(Constants.DeckEditorMode mode, Deck deck, String name, UUID currentTableId, UUID parentTableId, int visibleTimer) {
        this.currentTableId = currentTableId;
        this.parentTableId = parentTableId;
        this.setTitle(name);
        this.deckEditorPanel1.showDeckEditor(mode, deck, currentTableId, parentTableId, visibleTimer);
        this.repaint();
    }

    @Override
    public boolean isActiveTable() {
        return this.currentTableId != null;
    }

    public Constants.DeckEditorMode getDeckEditorMode() {
        return this.deckEditorPanel1.getDeckEditorMode();
    }

    @Override
    public UUID getSortTableId() {
        return this.parentTableId != null ? this.parentTableId : this.currentTableId;
    }

    private void initComponents() {
        this.deckEditorPanel1 = new DeckEditorPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 10), new Dimension(0, Short.MAX_VALUE));
        this.deckEditorPanel1.setMinimumSize(new Dimension(1000, 500));
        this.getContentPane().add((Component)this.deckEditorPanel1, "Center");
        this.getContentPane().add((Component)this.filler1, "North");
    }

    private void initComponents(Component container) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(container, -1, 885, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(container, -1, 626, Short.MAX_VALUE));
    }

    public DeckEditorPanel getPanel() {
        return this.deckEditorPanel1;
    }
}

