/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deckeditor;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.DeckFileFilter;
import mage.cards.decks.DeckFormats;
import mage.cards.decks.DnDDeckTargetListener;
import mage.cards.decks.importer.DeckImporter;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.cards.BigCard;
import mage.client.cards.ICardGrid;
import mage.client.components.LegalityLabel;
import mage.client.constants.Constants;
import mage.client.deck.generator.DeckGenerator;
import mage.client.deckeditor.CardSelector;
import mage.client.deckeditor.DeckArea;
import mage.client.deckeditor.DeckEditorPane;
import mage.client.deckeditor.DeckExportClipboardDialog;
import mage.client.deckeditor.DeckImportClipboardDialog;
import mage.client.deckeditor.DeckLegalityPanel;
import mage.client.deckeditor.ImportFilter;
import mage.client.deckeditor.UpdateDeckTask;
import mage.client.dialog.AddLandDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.plugins.impl.Plugins;
import mage.client.util.Event;
import mage.client.util.audio.AudioManager;
import mage.components.CardInfoPane;
import mage.game.GameException;
import mage.util.DeckUtil;
import mage.util.XmageThreadFactory;
import mage.view.CardView;
import mage.view.SimpleCardView;
import org.apache.log4j.Logger;

public class DeckEditorPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(DeckEditorPanel.class);
    private static final Border LEGALITY_LABEL_BORDER_SELECTED = BorderFactory.createLineBorder(Color.gray, 2);
    private static final Border LEGALITY_LABEL_BORDER_EMPTY = BorderFactory.createEmptyBorder();
    private final JFileChooser fcSelectDeck;
    private final JFileChooser fcImportDeck;
    private final JFileChooser fcExportDeck;
    private final Map<UUID, Card> temporaryCards = new HashMap<UUID, Card>();
    private final String LAST_DECK_FOLDER = "lastDeckFolder";
    private Deck deck = new Deck();
    private UUID currentTableId;
    private UUID parentTableId;
    private Constants.DeckEditorMode mode;
    private int timeout;
    private Timer countdown;
    private UpdateDeckTask updateDeckTask;
    private int timeToSubmit = -1;
    private BigCard bigCard;
    private JButton btnAddLand;
    private JButton btnExit;
    private JButton btnExport;
    private JButton btnGenDeck;
    private JButton btnImport;
    private JButton btnLegality;
    private JButton btnLoad;
    private JButton btnNew;
    private JButton btnSave;
    private JButton btnSubmit;
    private JButton btnSubmitTimer;
    private JComponent cardInfoPane;
    private CardSelector cardSelector;
    private DeckArea deckArea;
    private DeckLegalityPanel deckLegalityDisplay;
    private JLabel lblDeckName;
    private JPanel panelDeck;
    private JPanel panelDeckCreate;
    private JPanel panelDeckDraft;
    private JPanel panelDeckExit;
    private JPanel panelDeckLands;
    private JPanel panelDeckLoad;
    private JPanel panelDeckName;
    private JPanel panelDeckSave;
    private JPanel panelInfo;
    private JPanel panelLeft;
    private JSplitPane panelRight;
    private JScrollPane scrollPaneInfo;
    private JTextField txtDeckName;
    private JTextField txtTimeRemaining;

    public DeckEditorPanel() {
        this.initComponents();
        this.fcSelectDeck = new JFileChooser();
        this.fcSelectDeck.setAcceptAllFileFilterUsed(false);
        this.fcSelectDeck.addChoosableFileFilter(new DeckFileFilter("dck", "XMage's deck files (*.dck)"));
        this.fcSelectDeck.addChoosableFileFilter(new DeckFileFilter("dck_info", "XMage's deck files with info (*.dck_info)"));
        this.fcImportDeck = new JFileChooser();
        this.fcImportDeck.setAcceptAllFileFilterUsed(false);
        this.fcImportDeck.addChoosableFileFilter(new ImportFilter());
        this.fcExportDeck = new JFileChooser();
        this.fcExportDeck.setAcceptAllFileFilterUsed(false);
        this.deckArea.setOpaque(false);
        this.panelLeft.setOpaque(false);
        this.panelRight.setOpaque(false);
        this.countdown = new Timer(1000, e -> {
            if (--this.timeout > 0) {
                this.setTimeout(this.timeout);
            } else {
                if (this.updateDeckTask != null) {
                    this.updateDeckTask.cancel(true);
                }
                this.setTimeout(0);
                this.countdown.stop();
                this.removeDeckEditor();
            }
        });
        this.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) != 0L && !this.isShowing() && this.mode == Constants.DeckEditorMode.FREE_BUILDING) {
                this.saveDividerLocationsAndDeckAreaSettings();
            }
        });
        Arrays.stream(this.deckLegalityDisplay.getComponents()).filter(LegalityLabel.class::isInstance).forEach(c -> c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                LegalityLabel label = (LegalityLabel)e.getComponent();
                ArrayList<String> cardNames = new ArrayList<String>(label.selectCards());
                DeckEditorPanel.this.deckArea.getDeckList().deselectAll();
                DeckEditorPanel.this.deckArea.getDeckList().selectByName(cardNames);
                DeckEditorPanel.this.deckArea.getSideboardList().deselectAll();
                DeckEditorPanel.this.deckArea.getSideboardList().selectByName(cardNames);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LegalityLabel label = (LegalityLabel)e.getComponent();
                label.setBorder(LEGALITY_LABEL_BORDER_SELECTED);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LegalityLabel label = (LegalityLabel)e.getComponent();
                label.setBorder(LEGALITY_LABEL_BORDER_EMPTY);
            }
        }));
    }

    public void cleanUp() {
        this.saveDividerLocationsAndDeckAreaSettings();
        if (this.updateDeckTask != null) {
            this.updateDeckTask.cancel(true);
        }
        if (this.countdown != null) {
            if (this.countdown.isRunning()) {
                this.countdown.stop();
            }
            for (ActionListener al : this.countdown.getActionListeners()) {
                this.countdown.removeActionListener(al);
            }
        }
        this.cardSelector.cleanUp();
        this.deckArea.cleanUp();
        this.remove(this.bigCard);
        this.bigCard = null;
    }

    private void saveDividerLocationsAndDeckAreaSettings() {
        boolean isLimitedBuildingOrientation;
        boolean bl = isLimitedBuildingOrientation = this.mode != Constants.DeckEditorMode.FREE_BUILDING;
        if (isLimitedBuildingOrientation) {
            PreferencesDialog.saveValue("editorHorizontalDividerLocationLimited", Integer.toString(this.panelRight.getDividerLocation()));
        } else {
            PreferencesDialog.saveValue("editorHorizontalDividerLocationNormal", Integer.toString(this.panelRight.getDividerLocation()));
        }
        PreferencesDialog.saveValue("editorDeckAreaSettings", this.deckArea.saveSettings(isLimitedBuildingOrientation).toString());
    }

    private void restoreDividerLocationsAndDeckAreaSettings() {
        String dividerLocation = "";
        boolean isLimitedBuildingOrientation = this.mode != Constants.DeckEditorMode.FREE_BUILDING;
        dividerLocation = isLimitedBuildingOrientation ? PreferencesDialog.getCachedValue("editorHorizontalDividerLocationLimited", "") : PreferencesDialog.getCachedValue("editorHorizontalDividerLocationNormal", "");
        if (!dividerLocation.isEmpty()) {
            this.panelRight.setDividerLocation(Integer.parseInt(dividerLocation));
        }
        this.deckArea.loadSettings(DeckArea.Settings.parse(PreferencesDialog.getCachedValue("editorDeckAreaSettings", "")), isLimitedBuildingOrientation);
    }

    public void changeGUISize() {
        this.cardSelector.changeGUISize();
        this.deckArea.changeGUISize();
    }

    public void showDeckEditor(Constants.DeckEditorMode mode, Deck deck, UUID currentTableId, UUID parentTableId, int visibleTimer) {
        if (deck != null) {
            this.deck = deck;
        }
        this.currentTableId = currentTableId;
        this.parentTableId = parentTableId;
        this.mode = mode;
        this.btnAddLand.setVisible(false);
        this.scrollPaneInfo.getViewport().setOpaque(false);
        this.scrollPaneInfo.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPaneInfo.setViewportBorder(BorderFactory.createEmptyBorder());
        this.restoreDividerLocationsAndDeckAreaSettings();
        switch (mode) {
            case LIMITED_BUILDING: 
            case LIMITED_SIDEBOARD_BUILDING: {
                this.btnAddLand.setVisible(true);
                this.txtTimeRemaining.setVisible(true);
                this.btnLegality.setVisible(false);
            }
            case SIDEBOARDING: {
                this.btnSubmit.setVisible(true);
                this.btnSubmitTimer.setVisible(true);
                this.deckArea.setOrientation(mode != Constants.DeckEditorMode.SIDEBOARDING);
                this.cardSelector.setVisible(false);
                this.btnExit.setVisible(false);
                this.btnImport.setVisible(false);
                this.btnGenDeck.setVisible(false);
                if (!SessionHandler.isTestMode()) {
                    this.btnLoad.setVisible(false);
                }
                this.deckArea.showSideboard(true);
                this.countdown.stop();
                this.timeout = visibleTimer;
                this.setTimeout(this.timeout);
                if (this.timeout == 0) break;
                this.countdown.start();
                if (this.updateDeckTask != null && !this.updateDeckTask.isDone()) break;
                this.updateDeckTask = new UpdateDeckTask(SessionHandler.getSession(), currentTableId, deck);
                this.updateDeckTask.execute();
                break;
            }
            case FREE_BUILDING: {
                this.deckArea.setOrientation(false);
                this.btnSubmit.setVisible(false);
                this.btnSubmitTimer.setVisible(false);
                this.btnAddLand.setVisible(true);
                this.btnLegality.setVisible(true);
                this.cardSelector.setVisible(true);
                this.cardSelector.loadCards(this.bigCard);
                this.btnExit.setVisible(true);
                this.btnImport.setVisible(true);
                this.btnGenDeck.setVisible(true);
                if (!SessionHandler.isTestMode()) {
                    this.btnLoad.setVisible(true);
                }
                this.deckArea.showSideboard(true);
                this.txtTimeRemaining.setVisible(false);
                break;
            }
            case VIEW_LIMITED_DECK: {
                this.btnExit.setVisible(true);
                this.btnSave.setVisible(true);
                this.btnAddLand.setVisible(false);
                this.btnGenDeck.setVisible(false);
                this.btnImport.setVisible(false);
                this.btnLoad.setVisible(false);
                this.btnNew.setVisible(false);
                this.btnSubmit.setVisible(false);
                this.btnSubmitTimer.setVisible(false);
                this.cardSelector.loadCards(this.bigCard);
                this.cardSelector.setVisible(false);
                this.deckArea.setOrientation(true);
                this.deckArea.showSideboard(true);
                this.lblDeckName.setVisible(true);
                this.txtDeckName.setVisible(true);
                this.txtTimeRemaining.setVisible(false);
            }
        }
        this.init();
        this.deckArea.setDeckEditorMode(mode);
    }

    private Card retrieveTemporaryCard(SimpleCardView cardView) {
        Card card = this.temporaryCards.get(cardView.getId());
        if (card == null) {
            card = CardRepository.instance.findCard(cardView.getExpansionSetCode(), cardView.getCardNumber()).createCard();
        } else {
            this.temporaryCards.remove(cardView.getId());
        }
        return card;
    }

    private void storeTemporaryCard(Card card) {
        this.temporaryCards.put(card.getId(), card);
    }

    private void init() {
        this.panelLeft.setVisible(true);
        for (ICardGrid component : this.cardSelector.getCardGridComponents()) {
            component.addCardEventListener(event -> {
                switch (event.getEventType()) {
                    case CARD_DOUBLE_CLICK: {
                        boolean gameMode;
                        boolean bl = gameMode = this.mode != Constants.DeckEditorMode.FREE_BUILDING;
                        if (gameMode) {
                            this.moveSelectorCardToDeck(event);
                            break;
                        }
                        if (event.isMouseAltDown()) {
                            this.moveSelectorCardToSideboard(event);
                            break;
                        }
                        this.moveSelectorCardToDeck(event);
                        break;
                    }
                    case DECK_REMOVE_SELECTION_MAIN: {
                        this.deckArea.getDeckList().removeSelection();
                        break;
                    }
                    case DECK_REMOVE_SELECTION_SIDEBOARD: {
                        this.deckArea.getSideboardList().removeSelection();
                    }
                }
                this.refreshDeck();
            });
        }
        this.deckArea.addDeckEventListener(event -> {
            if (this.mode == Constants.DeckEditorMode.FREE_BUILDING) {
                switch (event.getEventType()) {
                    case CARD_DOUBLE_CLICK: {
                        SimpleCardView cardView = (SimpleCardView)event.getSource();
                        Card card = this.deck.findCard(cardView.getId());
                        if (card == null) {
                            return;
                        }
                        if (event.isMouseAltDown()) {
                            this.deck.getCards().remove(card);
                            this.deck.getSideboard().add(card);
                        } else {
                            this.deck.getCards().remove(card);
                        }
                        this.hidePopup();
                        this.refreshDeck();
                        break;
                    }
                    case SET_NUMBER: {
                        this.setCardNumberToCardsList(event, this.deck.getCards());
                        break;
                    }
                    case DECK_REMOVE_SPECIFIC_CARD: {
                        SimpleCardView cardView = (SimpleCardView)event.getSource();
                        Card card = this.deck.findCard(cardView.getId());
                        if (card == null) {
                            return;
                        }
                        this.deck.getCards().remove(card);
                        this.storeTemporaryCard(card);
                        break;
                    }
                    case DECK_ADD_SPECIFIC_CARD: {
                        CardView cardView = (CardView)event.getSource();
                        this.deck.getCards().add(this.retrieveTemporaryCard((SimpleCardView)cardView));
                        break;
                    }
                }
            } else {
                switch (event.getEventType()) {
                    case CARD_DOUBLE_CLICK: {
                        SimpleCardView cardView = (SimpleCardView)event.getSource();
                        Card card = this.deck.findCard(cardView.getId());
                        if (card == null) {
                            return;
                        }
                        this.deck.getCards().remove(card);
                        this.deck.getSideboard().add(card);
                        this.cardSelector.loadSideboard(new ArrayList<Card>(this.deck.getSideboard()), this.bigCard);
                        this.hidePopup();
                        this.refreshDeck();
                        break;
                    }
                    case DECK_REMOVE_SPECIFIC_CARD: {
                        SimpleCardView cardView = (SimpleCardView)event.getSource();
                        Card card = this.deck.findCard(cardView.getId());
                        if (card == null) {
                            return;
                        }
                        this.deck.getCards().remove(card);
                        this.storeTemporaryCard(card);
                        break;
                    }
                    case DECK_ADD_SPECIFIC_CARD: {
                        CardView cardView = (CardView)event.getSource();
                        this.deck.getCards().add(this.retrieveTemporaryCard((SimpleCardView)cardView));
                        break;
                    }
                }
            }
        });
        this.deckArea.addSideboardEventListener(event -> {
            if (this.mode == Constants.DeckEditorMode.FREE_BUILDING) {
                switch (event.getEventType()) {
                    case CARD_DOUBLE_CLICK: {
                        SimpleCardView cardView = (SimpleCardView)event.getSource();
                        Card card = this.deck.findSideboardCard(cardView.getId());
                        if (card == null) {
                            return;
                        }
                        if (event.isMouseAltDown()) {
                            this.deck.getSideboard().remove(card);
                            this.deck.getCards().add(card);
                        } else {
                            this.deck.getSideboard().remove(card);
                        }
                        this.hidePopup();
                        this.refreshDeck();
                        break;
                    }
                    case SET_NUMBER: {
                        this.setCardNumberToCardsList(event, this.deck.getSideboard());
                        break;
                    }
                    case DECK_REMOVE_SPECIFIC_CARD: {
                        SimpleCardView cardView = (SimpleCardView)event.getSource();
                        Card card = this.deck.findSideboardCard(cardView.getId());
                        if (card == null) {
                            return;
                        }
                        this.deck.getSideboard().remove(card);
                        this.storeTemporaryCard(card);
                        break;
                    }
                    case DECK_ADD_SPECIFIC_CARD: {
                        CardView cardView = (CardView)event.getSource();
                        this.deck.getSideboard().add(this.retrieveTemporaryCard((SimpleCardView)cardView));
                        break;
                    }
                }
            } else {
                switch (event.getEventType()) {
                    case DECK_REMOVE_SPECIFIC_CARD: {
                        SimpleCardView cardView = (SimpleCardView)event.getSource();
                        Card card = this.deck.findSideboardCard(cardView.getId());
                        if (card == null) {
                            return;
                        }
                        this.deck.getSideboard().remove(card);
                        this.storeTemporaryCard(card);
                        break;
                    }
                    case DECK_ADD_SPECIFIC_CARD: {
                        CardView cardView = (CardView)event.getSource();
                        this.deck.getSideboard().add(this.retrieveTemporaryCard((SimpleCardView)cardView));
                        break;
                    }
                    case CARD_DOUBLE_CLICK: {
                        SimpleCardView cardView = (SimpleCardView)event.getSource();
                        Card card = this.deck.findSideboardCard(cardView.getId());
                        if (card == null) {
                            return;
                        }
                        this.deck.getSideboard().remove(card);
                        this.deck.getCards().add(card);
                        this.hidePopup();
                        this.refreshDeck();
                        break;
                    }
                }
            }
        });
        this.refreshDeck(true, false);
        if (this.mode == Constants.DeckEditorMode.FREE_BUILDING) {
            this.setDropTarget(new DropTarget(this, new DnDDeckTargetListener(){

                @Override
                protected boolean handleFilesDrop(boolean move, List<File> files) {
                    DeckEditorPanel.this.loadDeck(files.get(0).getAbsolutePath(), true);
                    return true;
                }

                @Override
                protected boolean handlePlainTextDrop(boolean move, String text) {
                    String tmpFile = DeckUtil.writeTextToTempFile(text);
                    DeckEditorPanel.this.loadDeck(tmpFile, false);
                    return true;
                }
            }));
        }
        this.setVisible(true);
        this.repaint();
    }

    private void setCardNumberToCardsList(Event event, Set<Card> cards) {
        CardView cardView = (CardView)event.getSource();
        int numberToSet = event.getNumber();
        int cardsFound = 0;
        ArrayList<Card> toDelete = new ArrayList<Card>();
        for (Card card : cards) {
            if (!card.getName().equals(cardView.getName()) || !Objects.equals(card.getCardNumber(), cardView.getCardNumber()) || !card.getExpansionSetCode().equals(cardView.getExpansionSetCode()) || ++cardsFound <= numberToSet) continue;
            toDelete.add(card);
        }
        if (toDelete.isEmpty()) {
            CardInfo cardInfo = CardRepository.instance.findCard(cardView.getExpansionSetCode(), cardView.getCardNumber());
            for (int i = cardsFound; i < numberToSet; ++i) {
                cards.add(cardInfo.createMockCard());
            }
        } else {
            for (Card card : toDelete) {
                cards.remove(card);
            }
        }
        this.hidePopup();
        this.refreshDeck();
    }

    private void moveSelectorCardToDeck(Event event) {
        boolean gameMode;
        SimpleCardView cardView = (SimpleCardView)event.getSource();
        Card card = null;
        boolean bl = gameMode = this.mode != Constants.DeckEditorMode.FREE_BUILDING;
        if (gameMode) {
            for (Card sideCard : this.deck.getSideboard()) {
                if (!sideCard.getId().equals(cardView.getId())) continue;
                card = sideCard;
                break;
            }
        } else {
            CardInfo cardInfo = CardRepository.instance.findCard(cardView.getExpansionSetCode(), cardView.getCardNumber());
            Card card2 = card = cardInfo != null ? cardInfo.createMockCard() : null;
        }
        if (card != null) {
            this.deck.getCards().add(card);
            if (gameMode) {
                this.deck.getSideboard().remove(card);
                this.cardSelector.removeCard(card.getId());
                this.cardSelector.setCardCount(this.deck.getSideboard().size());
                this.cardSelector.refresh();
            }
            if (this.cardInfoPane instanceof CardInfoPane) {
                ((CardInfoPane)this.cardInfoPane).setCard(new CardView(card), null);
            }
            this.hidePopup();
        }
    }

    private void moveSelectorCardToSideboard(Event event) {
        Card card;
        boolean gameMode;
        boolean bl = gameMode = this.mode != Constants.DeckEditorMode.FREE_BUILDING;
        if (gameMode) {
            throw new IllegalArgumentException("ERROR, you can move card to sideboard from selector in game mode.");
        }
        SimpleCardView cardView = (SimpleCardView)event.getSource();
        CardInfo cardInfo = CardRepository.instance.findCard(cardView.getExpansionSetCode(), cardView.getCardNumber());
        Card card2 = card = cardInfo != null ? cardInfo.createMockCard() : null;
        if (card != null) {
            this.deck.getSideboard().add(card);
        }
        if (this.cardInfoPane instanceof CardInfoPane) {
            ((CardInfoPane)this.cardInfoPane).setCard(new CardView(card), null);
        }
        this.hidePopup();
    }

    private void hidePopup() {
        Plugins.instance.getActionCallback().mouseExited(null, null);
    }

    public void removeDeckEditor() {
        Container c;
        this.hidePopup();
        this.cleanUp();
        for (c = this.getParent(); c != null && !(c instanceof DeckEditorPane); c = c.getParent()) {
        }
        if (c != null) {
            ((DeckEditorPane)c).removeFrame();
        }
    }

    public Constants.DeckEditorMode getDeckEditorMode() {
        return this.mode;
    }

    private BigCard getBigCard() {
        return this.bigCard;
    }

    private void refreshDeck() {
        if (this.isVisible()) {
            this.refreshDeck(false, false);
        }
    }

    private void refreshDeck(boolean useLayout, boolean useDeckValidation) {
        try {
            MageFrame.getDesktop().setCursor(new Cursor(3));
            this.txtDeckName.setText(this.deck.getName());
            this.deckArea.loadDeck(this.deck, useLayout, this.bigCard);
            if (useDeckValidation) {
                this.validateDeck();
            }
        }
        finally {
            MageFrame.getDesktop().setCursor(new Cursor(0));
        }
    }

    private void validateDeck() {
        this.deckLegalityDisplay.setVisible(true);
        this.deckLegalityDisplay.validateDeck(this.deck);
    }

    private void setTimeout(int s) {
        int minute = s / 60;
        int second = s - minute * 60;
        String text = minute < 10 ? '0' + Integer.toString(minute) + ':' : Integer.toString(minute) + ':';
        text = second < 10 ? text + '0' + second : text + second;
        this.txtTimeRemaining.setText(text);
        if (s == 60) {
            AudioManager.playOnCountdown1();
        }
        if (this.timeToSubmit > 0) {
            --this.timeToSubmit;
            this.btnSubmitTimer.setText("Submit (" + this.timeToSubmit + ')');
            this.btnSubmitTimer.setToolTipText("Submit your deck in " + this.timeToSubmit + " seconds!");
        }
    }

    private void importChoose(ActionEvent evt) {
        Object[] options = new Object[]{"From file", "From clipboard (new deck)", "From clipboard (append cards)"};
        int n = JOptionPane.showOptionDialog(MageFrame.getDesktop(), "Choose import location", "Deck import", 1, 3, null, options, options[0]);
        switch (n) {
            case 0: {
                this.importFromFile(evt);
                break;
            }
            case 1: {
                this.importFromClipboard(evt);
                break;
            }
            case 2: {
                this.importFromClipboardWithAppend(evt);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromFile(ActionEvent evt) {
        int ret;
        String lastFolder = MageFrame.getPreferences().get("lastImportFolder", "");
        if (!lastFolder.isEmpty()) {
            this.fcImportDeck.setCurrentDirectory(new File(lastFolder));
        }
        if ((ret = this.fcImportDeck.showOpenDialog(this)) == 0) {
            File file = this.fcImportDeck.getSelectedFile();
            MageFrame.getDesktop().setCursor(new Cursor(3));
            try {
                DeckImporter importer = DeckImporter.getDeckImporter(file.getPath());
                if (importer != null) {
                    StringBuilder errorMessages = new StringBuilder();
                    Deck newDeck = null;
                    newDeck = Deck.load(importer.importDeck(file.getPath(), errorMessages, true));
                    this.processAndShowImportErrors(errorMessages);
                    if (newDeck != null) {
                        this.deck = newDeck;
                        this.refreshDeck(false, true);
                    }
                    try {
                        MageFrame.getPreferences().put("lastImportFolder", file.getCanonicalPath());
                    }
                    catch (IOException ex) {
                        logger.error((Object)("Error on save last used import folder: " + ex.getMessage()));
                    }
                } else {
                    JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Unknown deck format", "Error importing deck", 0);
                }
            }
            catch (Exception ex) {
                logger.fatal((Object)ex);
            }
            finally {
                MageFrame.getDesktop().setCursor(new Cursor(0));
            }
        }
        this.fcImportDeck.setSelectedFile(null);
    }

    private void importFromClipboard(ActionEvent evt) {
        DeckImportClipboardDialog dialog = new DeckImportClipboardDialog();
        dialog.showDialog(tempDeckPath -> {
            if (!tempDeckPath.isEmpty()) {
                this.loadDeck(tempDeckPath, false);
            }
        });
        if (dialog.isModal()) {
            dialog.dispose();
        }
    }

    private void onImportReady(String deckPath) {
        SwingUtilities.invokeLater(() -> {
            if (deckPath.isEmpty()) {
                this.loadDeck(deckPath, false);
            }
        });
    }

    private void importFromClipboardWithAppend(ActionEvent evt) {
        DeckImportClipboardDialog dialog = new DeckImportClipboardDialog();
        dialog.showDialog(tempDeckPath -> {
            if (!tempDeckPath.isEmpty()) {
                StringBuilder errorMessages = new StringBuilder();
                MageFrame.getDesktop().setCursor(new Cursor(3));
                try {
                    Deck deckToAppend = Deck.load(DeckImporter.importDeckFromFile(tempDeckPath, errorMessages, false), true, true);
                    this.processAndShowImportErrors(errorMessages);
                    this.deck = Deck.append(deckToAppend, this.deck);
                    this.refreshDeck(false, true);
                }
                catch (GameException e1) {
                    JOptionPane.showMessageDialog(MageFrame.getDesktop(), e1.getMessage(), "Error loading deck", 0);
                }
                finally {
                    MageFrame.getDesktop().setCursor(new Cursor(0));
                }
            }
        });
        if (dialog.isModal()) {
            dialog.dispose();
        }
    }

    private void exportChoose(ActionEvent evt) {
        Object[] options = new Object[]{"To file", "To clipboard"};
        int n = JOptionPane.showOptionDialog(MageFrame.getDesktop(), "Choose export location", "Deck export", 0, 3, null, options, options[0]);
        switch (n) {
            case 0: {
                this.exportToFile(evt);
                break;
            }
            case 1: {
                this.exportToClipboard(evt);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToFile(ActionEvent evt) {
        int ret;
        this.fcExportDeck.resetChoosableFileFilters();
        for (FileFilter filter : DeckFormats.getFileFilters()) {
            this.fcExportDeck.addChoosableFileFilter(filter);
        }
        String lastFolder = MageFrame.getPreferences().get("lastExportFolder", "");
        if (!lastFolder.isEmpty()) {
            this.fcExportDeck.setCurrentDirectory(new File(lastFolder));
        }
        if ((ret = this.fcExportDeck.showSaveDialog(this)) == 0) {
            File file = this.fcExportDeck.getSelectedFile();
            String needFileName = file.getAbsolutePath();
            String needFileExt = DeckFormats.getDefaultFileExtForFilter(this.fcExportDeck.getFileFilter());
            if (!needFileExt.isEmpty() && !needFileName.toLowerCase(Locale.ENGLISH).endsWith("." + needFileExt)) {
                needFileName = needFileName + "." + needFileExt;
            }
            MageFrame.getDesktop().setCursor(new Cursor(3));
            try {
                DeckFormats.writeDeck(needFileName, this.deck.prepareCardsOnlyDeck());
                try {
                    MageFrame.getPreferences().put("lastExportFolder", file.getCanonicalPath());
                }
                catch (IOException ex) {
                    logger.error((Object)("Error on save last used export folder: " + ex.getMessage()));
                }
            }
            catch (Exception ex) {
                logger.fatal((Object)ex);
            }
            finally {
                MageFrame.getDesktop().setCursor(new Cursor(0));
            }
        }
        this.fcExportDeck.setSelectedFile(null);
    }

    private void exportToClipboard(ActionEvent evt) {
        DeckExportClipboardDialog dialog = new DeckExportClipboardDialog();
        dialog.showDialog(this.deck);
    }

    private void processAndShowImportErrors(StringBuilder errorMessages) {
        if (errorMessages.length() > 0) {
            String mes = "Found problems with deck: \n\n" + errorMessages.toString();
            JOptionPane.showMessageDialog(MageFrame.getDesktop(), mes.substring(0, Math.min(1000, mes.length())), "Errors while loading deck", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadDeck(String file, boolean saveAutoFixedFile) {
        MageFrame.getDesktop().setCursor(new Cursor(3));
        try {
            StringBuilder errorMessages = new StringBuilder();
            Deck newDeck = Deck.load(DeckImporter.importDeckFromFile(file, errorMessages, saveAutoFixedFile), true, true);
            this.processAndShowImportErrors(errorMessages);
            if (newDeck != null) {
                this.deck = newDeck;
                this.refreshDeck(false, true);
                boolean bl = true;
                return bl;
            }
        }
        catch (GameException e1) {
            JOptionPane.showMessageDialog(MageFrame.getDesktop(), e1.getMessage(), "Error loading deck", 0);
        }
        finally {
            MageFrame.getDesktop().setCursor(new Cursor(0));
        }
        return false;
    }

    private void initComponents() {
        this.panelRight = new JSplitPane();
        this.cardSelector = new CardSelector();
        this.deckArea = new DeckArea();
        this.panelLeft = new JPanel();
        this.cardInfoPane = Plugins.instance.getCardInfoPane();
        if (this.cardInfoPane != null && System.getProperty("testCardInfo") != null) {
            this.cardInfoPane.setPreferredSize(new Dimension(170, 150));
            this.cardInfoPane.setBorder(BorderFactory.createLineBorder(new Color(200, 0, 0)));
        } else {
            this.cardInfoPane = new JLabel();
            this.cardInfoPane.setVisible(false);
        }
        this.panelDeck = new JPanel();
        this.panelDeckName = new JPanel();
        this.lblDeckName = new JLabel();
        this.txtDeckName = new JTextField();
        this.panelDeckCreate = new JPanel();
        this.btnNew = new JButton();
        this.btnGenDeck = new JButton();
        this.panelDeckLoad = new JPanel();
        this.btnLoad = new JButton();
        this.btnImport = new JButton();
        this.panelDeckSave = new JPanel();
        this.btnSave = new JButton();
        this.btnExport = new JButton();
        this.panelDeckDraft = new JPanel();
        this.btnSubmit = new JButton();
        this.btnSubmitTimer = new JButton();
        this.panelDeckLands = new JPanel();
        this.btnAddLand = new JButton();
        this.btnLegality = new JButton();
        this.panelDeckExit = new JPanel();
        this.btnExit = new JButton();
        this.txtTimeRemaining = new JTextField();
        this.scrollPaneInfo = new JScrollPane();
        this.panelInfo = new JPanel();
        this.deckLegalityDisplay = new DeckLegalityPanel();
        this.bigCard = new BigCard();
        this.panelRight.setDividerSize(10);
        this.panelRight.setOrientation(0);
        this.panelRight.setResizeWeight(0.5);
        this.panelRight.setTopComponent(this.cardSelector);
        this.deckArea.setMinimumSize(new Dimension(200, 56));
        this.panelRight.setBottomComponent(this.deckArea);
        this.panelDeck.setOpaque(false);
        this.panelDeck.setLayout(new BoxLayout(this.panelDeck, 1));
        this.panelDeckName.setOpaque(false);
        this.lblDeckName.setForeground(new Color(255, 255, 255));
        this.lblDeckName.setLabelFor(this.txtDeckName);
        this.lblDeckName.setText("Deck Name:");
        GroupLayout panelDeckNameLayout = new GroupLayout(this.panelDeckName);
        this.panelDeckName.setLayout(panelDeckNameLayout);
        panelDeckNameLayout.setHorizontalGroup(panelDeckNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckNameLayout.createSequentialGroup().addContainerGap().addComponent(this.lblDeckName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtDeckName, -1, 205, Short.MAX_VALUE).addContainerGap()));
        panelDeckNameLayout.setVerticalGroup(panelDeckNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckNameLayout.createSequentialGroup().addGroup(panelDeckNameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtDeckName, -2, 30, -2).addComponent(this.lblDeckName)).addGap(0, 0, 0)));
        this.panelDeck.add(this.panelDeckName);
        this.panelDeckCreate.setOpaque(false);
        this.btnNew.setIcon(new ImageIcon(this.getClass().getResource("/buttons/state_active.png")));
        this.btnNew.setText("NEW");
        this.btnNew.setIconTextGap(2);
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckEditorPanel.this.btnNewActionPerformed(evt);
            }
        });
        this.btnGenDeck.setIcon(new ImageIcon(this.getClass().getResource("/buttons/card_panel.png")));
        this.btnGenDeck.setText("Generate");
        this.btnGenDeck.setIconTextGap(1);
        this.btnGenDeck.setName("btnGenDeck");
        this.btnGenDeck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckEditorPanel.this.btnGenDeckActionPerformed(evt);
            }
        });
        GroupLayout panelDeckCreateLayout = new GroupLayout(this.panelDeckCreate);
        this.panelDeckCreate.setLayout(panelDeckCreateLayout);
        panelDeckCreateLayout.setHorizontalGroup(panelDeckCreateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckCreateLayout.createSequentialGroup().addContainerGap().addComponent(this.btnNew, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGenDeck, -2, 100, -2).addContainerGap(70, Short.MAX_VALUE)));
        panelDeckCreateLayout.setVerticalGroup(panelDeckCreateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckCreateLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(panelDeckCreateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnGenDeck, -1, 30, Short.MAX_VALUE).addComponent(this.btnNew, -1, 30, Short.MAX_VALUE))));
        this.panelDeck.add(this.panelDeckCreate);
        this.panelDeckLoad.setOpaque(false);
        this.btnLoad.setIcon(new ImageIcon(this.getClass().getResource("/buttons/search_24.png")));
        this.btnLoad.setText("LOAD");
        this.btnLoad.setIconTextGap(2);
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckEditorPanel.this.btnLoadActionPerformed(evt);
            }
        });
        this.btnImport.setIcon(new ImageIcon(this.getClass().getResource("/buttons/deck_in.png")));
        this.btnImport.setText("Import");
        this.btnImport.setIconTextGap(2);
        this.btnImport.setName("btnImport");
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckEditorPanel.this.btnImportActionPerformed(evt);
            }
        });
        GroupLayout panelDeckLoadLayout = new GroupLayout(this.panelDeckLoad);
        this.panelDeckLoad.setLayout(panelDeckLoadLayout);
        panelDeckLoadLayout.setHorizontalGroup(panelDeckLoadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckLoadLayout.createSequentialGroup().addContainerGap().addComponent(this.btnLoad, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnImport, -2, 100, -2).addContainerGap(70, Short.MAX_VALUE)));
        panelDeckLoadLayout.setVerticalGroup(panelDeckLoadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckLoadLayout.createSequentialGroup().addContainerGap().addGroup(panelDeckLoadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnLoad, -2, 0, Short.MAX_VALUE).addComponent(this.btnImport, -1, 30, Short.MAX_VALUE))));
        this.panelDeck.add(this.panelDeckLoad);
        this.panelDeckSave.setOpaque(false);
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/buttons/sideboard_out.png")));
        this.btnSave.setText("SAVE");
        this.btnSave.setIconTextGap(2);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckEditorPanel.this.btnSaveActionPerformed(evt);
            }
        });
        this.btnExport.setIcon(new ImageIcon(this.getClass().getResource("/buttons/deck_out.png")));
        this.btnExport.setText("Export");
        this.btnExport.setIconTextGap(2);
        this.btnExport.setName("btnImport");
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckEditorPanel.this.btnExportActionPerformed(evt);
            }
        });
        GroupLayout panelDeckSaveLayout = new GroupLayout(this.panelDeckSave);
        this.panelDeckSave.setLayout(panelDeckSaveLayout);
        panelDeckSaveLayout.setHorizontalGroup(panelDeckSaveLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckSaveLayout.createSequentialGroup().addContainerGap().addComponent(this.btnSave, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExport, -2, 100, -2).addContainerGap(70, Short.MAX_VALUE)));
        panelDeckSaveLayout.setVerticalGroup(panelDeckSaveLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckSaveLayout.createSequentialGroup().addContainerGap().addGroup(panelDeckSaveLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnSave, -1, 30, Short.MAX_VALUE).addComponent(this.btnExport, -1, 30, Short.MAX_VALUE))));
        this.panelDeck.add(this.panelDeckSave);
        this.panelDeckDraft.setOpaque(false);
        this.btnSubmit.setIcon(new ImageIcon(this.getClass().getResource("/buttons/state_finished.png")));
        this.btnSubmit.setText("SUBMIT");
        this.btnSubmit.setIconTextGap(2);
        this.btnSubmit.setName("btnSubmit");
        this.btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckEditorPanel.this.btnSubmitActionPerformed(evt);
            }
        });
        this.btnSubmitTimer.setFont(new Font("Tahoma", 0, 9));
        this.btnSubmitTimer.setIcon(new ImageIcon(this.getClass().getResource("/buttons/state_finished.png")));
        this.btnSubmitTimer.setText("<html>Submit<br>in 1 min");
        this.btnSubmitTimer.setIconTextGap(2);
        this.btnSubmitTimer.setName("btnSubmitTimer");
        this.btnSubmitTimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckEditorPanel.this.btnSubmitTimerActionPerformed(evt);
            }
        });
        GroupLayout panelDeckDraftLayout = new GroupLayout(this.panelDeckDraft);
        this.panelDeckDraft.setLayout(panelDeckDraftLayout);
        panelDeckDraftLayout.setHorizontalGroup(panelDeckDraftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckDraftLayout.createSequentialGroup().addContainerGap().addComponent(this.btnSubmit, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSubmitTimer, -2, 100, -2).addContainerGap(70, Short.MAX_VALUE)));
        panelDeckDraftLayout.setVerticalGroup(panelDeckDraftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckDraftLayout.createSequentialGroup().addContainerGap().addGroup(panelDeckDraftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckDraftLayout.createSequentialGroup().addComponent(this.btnSubmit, -2, 30, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.btnSubmitTimer, -2, 0, Short.MAX_VALUE)).addGap(0, 0, 0)));
        this.panelDeck.add(this.panelDeckDraft);
        this.panelDeckLands.setOpaque(false);
        this.btnAddLand.setIcon(new ImageIcon(this.getClass().getResource("/buttons/type_land.png")));
        this.btnAddLand.setText("Lands");
        this.btnAddLand.setIconTextGap(2);
        this.btnAddLand.setName("btnAddLand");
        this.btnAddLand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckEditorPanel.this.btnAddLandActionPerformed(evt);
            }
        });
        this.btnLegality.setText("Validate");
        this.btnLegality.setIconTextGap(2);
        this.btnLegality.setName("btnLegality");
        this.btnLegality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckEditorPanel.this.btnLegalityActionPerformed(evt);
            }
        });
        GroupLayout panelDeckLandsLayout = new GroupLayout(this.panelDeckLands);
        this.panelDeckLands.setLayout(panelDeckLandsLayout);
        panelDeckLandsLayout.setHorizontalGroup(panelDeckLandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckLandsLayout.createSequentialGroup().addContainerGap().addComponent(this.btnAddLand, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLegality, -2, 100, -2).addContainerGap(70, Short.MAX_VALUE)));
        panelDeckLandsLayout.setVerticalGroup(panelDeckLandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelDeckLandsLayout.createSequentialGroup().addContainerGap().addGroup(panelDeckLandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnAddLand, -1, -1, Short.MAX_VALUE).addComponent(this.btnLegality, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
        this.panelDeck.add(this.panelDeckLands);
        this.panelDeckExit.setOpaque(false);
        this.btnExit.setText("Exit");
        this.btnExit.setIconTextGap(2);
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckEditorPanel.this.btnExitActionPerformed(evt);
            }
        });
        this.txtTimeRemaining.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckEditorPanel.this.txtTimeRemainingActionPerformed(evt);
            }
        });
        GroupLayout panelDeckExitLayout = new GroupLayout(this.panelDeckExit);
        this.panelDeckExit.setLayout(panelDeckExitLayout);
        panelDeckExitLayout.setHorizontalGroup(panelDeckExitLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDeckExitLayout.createSequentialGroup().addContainerGap().addComponent(this.btnExit, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtTimeRemaining, -2, 100, -2).addContainerGap(70, Short.MAX_VALUE)));
        panelDeckExitLayout.setVerticalGroup(panelDeckExitLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelDeckExitLayout.createSequentialGroup().addGap(0, 11, Short.MAX_VALUE).addGroup(panelDeckExitLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnExit, -2, 30, -2).addComponent(this.txtTimeRemaining, -2, 30, -2))));
        this.panelDeck.add(this.panelDeckExit);
        this.scrollPaneInfo.setBorder(null);
        this.scrollPaneInfo.setHorizontalScrollBarPolicy(31);
        this.scrollPaneInfo.setOpaque(false);
        this.panelInfo.setOpaque(false);
        this.deckLegalityDisplay.setMaximumSize(new Dimension(245, 255));
        this.deckLegalityDisplay.setMinimumSize(new Dimension(85, 255));
        this.deckLegalityDisplay.setOpaque(false);
        this.deckLegalityDisplay.setVisible(false);
        GroupLayout panelInfoLayout = new GroupLayout(this.panelInfo);
        this.panelInfo.setLayout(panelInfoLayout);
        panelInfoLayout.setHorizontalGroup(panelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelInfoLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(panelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bigCard, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panelInfoLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.deckLegalityDisplay, -2, 245, -2).addGap(0, 0, Short.MAX_VALUE))).addGap(15, 15, 15)));
        panelInfoLayout.setVerticalGroup(panelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelInfoLayout.createSequentialGroup().addContainerGap().addComponent(this.deckLegalityDisplay, -2, 255, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.bigCard, -2, -1, -2).addContainerGap()));
        this.scrollPaneInfo.setViewportView(this.panelInfo);
        GroupLayout panelLeftLayout = new GroupLayout(this.panelLeft);
        this.panelLeft.setLayout(panelLeftLayout);
        panelLeftLayout.setHorizontalGroup(panelLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelDeck, -1, -1, Short.MAX_VALUE).addComponent(this.scrollPaneInfo));
        panelLeftLayout.setVerticalGroup(panelLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLeftLayout.createSequentialGroup().addComponent(this.panelDeck, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scrollPaneInfo).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.panelLeft, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelRight, -1, 883, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelLeft, -1, -1, Short.MAX_VALUE).addComponent(this.panelRight, GroupLayout.Alignment.TRAILING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnSaveActionPerformed(ActionEvent evt) {
        String lastFolder = MageFrame.getPreferences().get("lastDeckFolder", "");
        if (!lastFolder.isEmpty()) {
            this.fcSelectDeck.setCurrentDirectory(new File(lastFolder));
        }
        this.deck.setName(this.txtDeckName.getText());
        int ret = this.fcSelectDeck.showSaveDialog(this);
        if (ret == 0) {
            File file = this.fcSelectDeck.getSelectedFile();
            if (file == null && !lastFolder.isEmpty()) {
                file = new File(lastFolder);
            }
            try {
                String fileName = file.getPath();
                if (!fileName.endsWith(".dck") && !fileName.endsWith(".dck_info")) {
                    fileName = fileName + ".dck";
                }
                boolean useDeckInfo = false;
                if (fileName.endsWith(".dck_info")) {
                    useDeckInfo = true;
                }
                MageFrame.getDesktop().setCursor(new Cursor(3));
                DeckCardLists cardLists = this.deck.prepareCardsOnlyDeck();
                cardLists.setCardLayout(this.deckArea.getCardLayout());
                cardLists.setSideboardLayout(this.deckArea.getSideboardLayout());
                if (!useDeckInfo) {
                    DeckFormats.XMAGE.getExporter().writeDeck(fileName, cardLists);
                } else {
                    DeckFormats.XMAGE_INFO.getExporter().writeDeck(fileName, cardLists);
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), ex.getMessage() + "\nTry ensuring that the selected directory is writable.", "Error saving deck", 0);
            }
            finally {
                MageFrame.getDesktop().setCursor(new Cursor(0));
            }
            try {
                MageFrame.getPreferences().put("lastDeckFolder", file.getCanonicalPath());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnLoadActionPerformed(ActionEvent evt) {
        int ret;
        String lastFolder = MageFrame.getPreferences().get("lastDeckFolder", "");
        if (!lastFolder.isEmpty()) {
            this.fcSelectDeck.setCurrentDirectory(new File(lastFolder));
        }
        if ((ret = this.fcSelectDeck.showOpenDialog(this)) == 0) {
            File file = this.fcSelectDeck.getSelectedFile();
            if (file == null && !lastFolder.isEmpty()) {
                file = new File(lastFolder);
            }
            MageFrame.getDesktop().setCursor(new Cursor(3));
            try {
                Deck newDeck = null;
                StringBuilder errorMessages = new StringBuilder();
                newDeck = Deck.load(DeckImporter.importDeckFromFile(file.getPath(), errorMessages, true), true, true);
                this.processAndShowImportErrors(errorMessages);
                if (newDeck != null) {
                    this.deck = newDeck;
                    this.refreshDeck(true, true);
                }
                try {
                    MageFrame.getPreferences().put("lastDeckFolder", file.getCanonicalPath());
                }
                catch (IOException ex) {
                    logger.error((Object)("Error on save last load deck folder: " + ex.getMessage()));
                }
            }
            catch (GameException ex) {
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), ex.getMessage(), "Error loading deck", 0);
            }
            finally {
                MageFrame.getDesktop().setCursor(new Cursor(0));
            }
        }
        this.fcSelectDeck.setSelectedFile(null);
    }

    private void btnNewActionPerformed(ActionEvent evt) {
        if (this.mode == Constants.DeckEditorMode.SIDEBOARDING || this.mode == Constants.DeckEditorMode.LIMITED_BUILDING || this.mode == Constants.DeckEditorMode.LIMITED_SIDEBOARD_BUILDING) {
            for (Card card : this.deck.getCards()) {
                this.deck.getSideboard().add(card);
            }
            this.deck.getCards().clear();
            this.cardSelector.loadSideboard(new ArrayList<Card>(this.deck.getSideboard()), this.bigCard);
        } else {
            this.deck = new Deck();
        }
        this.refreshDeck(false, true);
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        this.removeDeckEditor();
    }

    private void btnAddLandActionPerformed(ActionEvent evt) {
        AddLandDialog dialog = new AddLandDialog();
        dialog.showDialog(this.deck, this.mode, () -> this.refreshDeck(false, true));
    }

    private void btnGenDeckActionPerformed(ActionEvent evt) {
        try {
            MageFrame.getDesktop().setCursor(new Cursor(3));
            String path = DeckGenerator.generateDeck();
            if (path == null) {
                return;
            }
            this.deck = Deck.load(DeckImporter.importDeckFromFile(path, false), true, true);
        }
        catch (GameException ex) {
            JOptionPane.showMessageDialog(MageFrame.getDesktop(), ex.getMessage(), "Error loading generated deck", 0);
        }
        catch (DeckGenerator.DeckGeneratorException ex) {
            JOptionPane.showMessageDialog(MageFrame.getDesktop(), ex.getMessage(), "Generator error", 0);
        }
        finally {
            MageFrame.getDesktop().setCursor(new Cursor(0));
        }
        this.refreshDeck(false, true);
    }

    private void btnSubmitActionPerformed(ActionEvent evt) {
        if (this.updateDeckTask != null) {
            this.updateDeckTask.cancel(true);
        }
        if (SessionHandler.submitDeck(this.mode, this.currentTableId, this.deck.prepareCardsOnlyDeck())) {
            this.removeDeckEditor();
        }
    }

    private void btnSubmitTimerActionPerformed(ActionEvent evt) {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new XmageThreadFactory("XMAGE submit timer"));
        this.timeToSubmit = 60;
        this.btnSubmitTimer.setEnabled(false);
        executorService.schedule(() -> {
            if (this.updateDeckTask != null) {
                this.updateDeckTask.cancel(true);
            }
            if (SessionHandler.submitDeck(this.mode, this.currentTableId, this.deck.prepareCardsOnlyDeck())) {
                SwingUtilities.invokeLater(this::removeDeckEditor);
            }
            return null;
        }, 60L, TimeUnit.SECONDS);
    }

    private void txtTimeRemainingActionPerformed(ActionEvent evt) {
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        this.importChoose(evt);
    }

    private void btnExportActionPerformed(ActionEvent evt) {
        this.exportChoose(evt);
    }

    private void btnLegalityActionPerformed(ActionEvent evt) {
        this.validateDeck();
    }
}

