/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deckeditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckValidator;
import mage.cards.mock.MockCard;
import mage.cards.mock.MockSplitCard;
import mage.client.components.BracketLegalityLabel;
import mage.client.components.EdhPowerLevelLegalityLabel;
import mage.client.components.LegalityLabel;
import mage.deck.Brawl;
import mage.deck.CanadianHighlander;
import mage.deck.Commander;
import mage.deck.EuropeanHighlander;
import mage.deck.Frontier;
import mage.deck.Historic;
import mage.deck.HistoricalType2;
import mage.deck.Legacy;
import mage.deck.Modern;
import mage.deck.Oathbreaker;
import mage.deck.Pauper;
import mage.deck.PennyDreadfulCommander;
import mage.deck.Pioneer;
import mage.deck.Standard;
import mage.deck.Vintage;
import org.apache.log4j.Logger;

public class DeckLegalityPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(DeckLegalityPanel.class);
    private JLabel previewLegal;
    private JLabel previewNotLegal;
    private JLabel previewUnknown;

    public DeckLegalityPanel() {
        this.initComponents();
        this.initDeckLabels();
    }

    private void initComponents() {
        this.previewUnknown = new JLabel();
        this.previewLegal = new JLabel();
        this.previewNotLegal = new JLabel();
        this.setMinimumSize(new Dimension(85, 35));
        this.setName("DeckLegalityPanel");
        this.setLayout(new FlowLayout(3));
        this.previewUnknown.setBackground(new Color(174, 174, 174));
        this.previewUnknown.setForeground(new Color(255, 255, 255));
        this.previewUnknown.setHorizontalAlignment(0);
        this.previewUnknown.setText("Unknown");
        this.previewUnknown.setMaximumSize(new Dimension(150, 50));
        this.previewUnknown.setMinimumSize(new Dimension(75, 25));
        this.previewUnknown.setName("previewUnknown");
        this.previewUnknown.setOpaque(true);
        this.previewUnknown.setPreferredSize(new Dimension(75, 25));
        this.add(this.previewUnknown);
        this.previewLegal.setBackground(new Color(117, 152, 110));
        this.previewLegal.setForeground(new Color(255, 255, 255));
        this.previewLegal.setHorizontalAlignment(0);
        this.previewLegal.setText("Legal");
        this.previewLegal.setMaximumSize(new Dimension(150, 50));
        this.previewLegal.setMinimumSize(new Dimension(75, 25));
        this.previewLegal.setName("previewLegal");
        this.previewLegal.setOpaque(true);
        this.previewLegal.setPreferredSize(new Dimension(75, 25));
        this.add(this.previewLegal);
        this.previewNotLegal.setBackground(new Color(191, 84, 74));
        this.previewNotLegal.setForeground(new Color(255, 255, 255));
        this.previewNotLegal.setHorizontalAlignment(0);
        this.previewNotLegal.setText("Not Legal");
        this.previewNotLegal.setMaximumSize(new Dimension(150, 50));
        this.previewNotLegal.setMinimumSize(new Dimension(75, 25));
        this.previewNotLegal.setName("previewNotLegal");
        this.previewNotLegal.setOpaque(true);
        this.previewNotLegal.setPreferredSize(new Dimension(75, 25));
        this.add(this.previewNotLegal);
    }

    private void initDeckLabels() {
        this.remove(this.previewUnknown);
        this.remove(this.previewLegal);
        this.remove(this.previewNotLegal);
        Stream.of(new Standard(), new Pioneer(), new Modern(), new Legacy(), new Vintage(), new Pauper(), new Historic(), new Commander(), new Oathbreaker(), new Brawl(), new Frontier(), new HistoricalType2(), new PennyDreadfulCommander(), new EuropeanHighlander(), new CanadianHighlander()).forEach(this::addLegalityLabel);
        this.add(new EdhPowerLevelLegalityLabel());
        this.add(new BracketLegalityLabel("Bracket 1", "B1", 1));
        this.add(new BracketLegalityLabel("Bracket 2", "B2", 2));
        this.add(new BracketLegalityLabel("Bracket 3", "B3", 3));
        this.add(new BracketLegalityLabel("Bracket 4", "B4", 4));
        this.add(new BracketLegalityLabel("Bracket 5", "B5", 5));
        this.addHidePanelButton();
        this.revalidate();
        this.repaint();
    }

    protected LegalityLabel addLegalityLabel(DeckValidator validator) {
        LegalityLabel label = new LegalityLabel(validator);
        this.add(label);
        return label;
    }

    protected void addHidePanelButton() {
        JButton button = LegalityLabel.createHideButton();
        button.addActionListener(e -> this.setVisible(false));
        this.add(button);
    }

    private boolean isMockCard(Card card) {
        return card instanceof MockCard || card instanceof MockSplitCard;
    }

    public void validateDeck(Deck deck) {
        Deck deckToValidate;
        if (deck.getCards().stream().noneMatch(this::isMockCard) && deck.getSideboard().stream().noneMatch(this::isMockCard)) {
            deckToValidate = deck;
        } else {
            try {
                deckToValidate = Deck.load(deck.prepareCardsOnlyDeck(), true, false);
            }
            catch (Exception ex) {
                logger.error((Object)("Can't load real deck cards for validate: " + ex.getMessage()), (Throwable)ex);
                return;
            }
        }
        Arrays.stream(this.getComponents()).filter(LegalityLabel.class::isInstance).map(LegalityLabel.class::cast).forEach(label -> label.validateDeck(deckToValidate));
    }
}

