/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deckeditor;

import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import mage.cards.decks.Deck;
import mage.client.SessionHandler;
import mage.remote.Session;
import org.apache.log4j.Logger;

class UpdateDeckTask
extends SwingWorker<Void, Void> {
    private static final Logger logger = Logger.getLogger(UpdateDeckTask.class);
    private final Session session;
    private final UUID tableId;
    private final Deck deck;

    UpdateDeckTask(Session session, UUID tableId, Deck deck) {
        this.session = session;
        this.tableId = tableId;
        this.deck = deck;
    }

    @Override
    protected Void doInBackground() throws Exception {
        while (!this.isCancelled()) {
            SessionHandler.updateDeck(this.tableId, this.deck.prepareCardsOnlyDeck());
            TimeUnit.SECONDS.sleep(5L);
        }
        return null;
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.fatal((Object)"Update Matches Task error", (Throwable)ex);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }
}

