/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deckeditor.table;

import java.util.Collections;
import mage.cards.RateCard;
import mage.client.util.comparators.CardViewComparator;
import mage.view.CardView;
import org.apache.log4j.Logger;

public class MageCardComparator
implements CardViewComparator {
    private static final Logger logger = Logger.getLogger(MageCardComparator.class);
    private final int column;
    private final boolean ascending;

    public MageCardComparator(int column, boolean ascending) {
        this.column = column;
        this.ascending = ascending;
    }

    @Override
    public int compare(CardView a, CardView b) {
        Object aCom = 1;
        Object bCom = 1;
        switch (this.column) {
            case 0: {
                break;
            }
            case 1: {
                aCom = a.getName();
                bCom = b.getName();
                if (!aCom.equals(bCom) || !a.getExpansionSetCode().equals(b.getExpansionSetCode())) break;
                aCom = a.getCardNumber();
                bCom = b.getCardNumber();
                break;
            }
            case 2: {
                aCom = a.getManaValue();
                bCom = b.getManaValue();
                break;
            }
            case 3: {
                aCom = a.getColorText();
                bCom = b.getColorText();
                break;
            }
            case 4: {
                aCom = a.getTypeText();
                bCom = b.getTypeText();
                break;
            }
            case 5: {
                aCom = Float.valueOf(-1.0f);
                bCom = Float.valueOf(-1.0f);
                if (a.isCreature()) {
                    aCom = new Float(a.getPower() + '.' + (a.getToughness().startsWith("-") ? "0" : a.getToughness()));
                }
                if (!b.isCreature()) break;
                bCom = new Float(b.getPower() + '.' + (b.getToughness().startsWith("-") ? "0" : b.getToughness()));
                break;
            }
            case 6: {
                aCom = a.getRarity() == null ? 0 : a.getRarity().getSorting();
                bCom = b.getRarity() == null ? 0 : b.getRarity().getSorting();
                break;
            }
            case 7: {
                aCom = a.getExpansionSetCode();
                bCom = b.getExpansionSetCode();
                break;
            }
            case 8: {
                aCom = Integer.parseInt(a.getCardNumber().replaceAll("[\\D]", ""));
                bCom = Integer.parseInt(b.getCardNumber().replaceAll("[\\D]", ""));
                break;
            }
            case 9: {
                aCom = RateCard.rateCard((CardView)a, Collections.emptyList());
                bCom = RateCard.rateCard((CardView)b, Collections.emptyList());
                break;
            }
            case 10: {
                aCom = a.getOriginalColorIdentity();
                bCom = b.getOriginalColorIdentity();
                break;
            }
        }
        if (this.ascending) {
            return aCom.compareTo(bCom);
        }
        return bCom.compareTo(aCom);
    }

    @Override
    public String getCategoryName(CardView sample) {
        return "";
    }
}

