/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import mage.cards.MageCard;
import mage.client.cards.BigCard;
import mage.client.cards.Cards;
import mage.client.components.MageDesktopIconifySupport;
import mage.client.dialog.MageDialog;
import mage.client.util.GUISizeHelper;
import mage.client.util.ImageHelper;
import mage.client.util.SettingsManager;
import mage.client.util.gui.GuiDisplayUtil;
import mage.constants.CardType;
import mage.util.RandomUtil;
import mage.view.CardView;
import mage.view.CardsView;
import mage.view.ExileView;
import org.apache.log4j.Logger;
import org.mage.plugins.card.utils.impl.ImageManagerImpl;

public class CardInfoWindowDialog
extends MageDialog
implements MageDesktopIconifySupport {
    private static final Logger LOGGER = Logger.getLogger(CardInfoWindowDialog.class);
    private final ShowType showType;
    private boolean positioned;
    private final String name;
    private Cards cards;

    public CardInfoWindowDialog(ShowType showType, String name) {
        this.name = name;
        this.title = name;
        this.showType = showType;
        this.positioned = false;
        this.initComponents();
        this.setModal(false);
        switch (this.showType) {
            case LOOKED_AT: {
                this.setFrameIcon(new ImageIcon(ImageManagerImpl.instance.getLookedAtImage()));
                this.setClosable(true);
                break;
            }
            case REVEAL: {
                this.setFrameIcon(new ImageIcon(ImageManagerImpl.instance.getRevealedImage()));
                this.setClosable(true);
                break;
            }
            case REVEAL_TOP_LIBRARY: {
                this.setFrameIcon(new ImageIcon(ImageHelper.getImageFromResources("/info/library.png")));
                this.setClosable(true);
                break;
            }
            case GRAVEYARD: {
                this.setFrameIcon(new ImageIcon(ImageHelper.getImageFromResources("/info/grave.png")));
                this.setClosable(true);
                this.setDefaultCloseOperation(1);
                this.addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosing(InternalFrameEvent e) {
                        CardInfoWindowDialog.this.hideDialog();
                    }
                });
                break;
            }
            case SIDEBOARD: {
                this.setFrameIcon(new ImageIcon(ImageHelper.getImageFromResources("/info/library.png")));
                this.setClosable(true);
                this.setDefaultCloseOperation(1);
                this.addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosing(InternalFrameEvent e) {
                        CardInfoWindowDialog.this.hideDialog();
                    }
                });
                break;
            }
            case EXILE: {
                this.setFrameIcon(new ImageIcon(ImageManagerImpl.instance.getExileImage()));
                break;
            }
            case COMPANION: {
                this.setFrameIcon(new ImageIcon(ImageManagerImpl.instance.getTokenIconImage()));
                this.setClosable(false);
                break;
            }
        }
        this.setTitelBarToolTip(name);
        this.setGUISize();
    }

    public void cleanUp() {
        this.cards.cleanUp();
    }

    @Override
    public void changeGUISize() {
        this.setGUISize();
        this.validate();
        this.repaint();
    }

    private void setGUISize() {
        this.cards.setCardDimension(GUISizeHelper.otherZonesCardDimension);
        this.cards.changeGUISize();
    }

    public void loadCardsAndShow(ExileView exile, BigCard bigCard, UUID gameId) {
        boolean changed = this.cards.loadCards((CardsView)exile, bigCard, gameId, true);
        String titel = this.name + " (" + exile.size() + ')';
        this.setTitle(titel);
        this.setTitelBarToolTip(titel);
        if (!exile.isEmpty()) {
            this.show();
            if (changed) {
                try {
                    this.setIcon(false);
                }
                catch (PropertyVetoException ex) {
                    LOGGER.error(null, (Throwable)ex);
                }
            }
        } else {
            this.hideDialog();
        }
    }

    public void loadCardsAndShow(CardsView showCards, BigCard bigCard, UUID gameId, boolean revertOrder) {
        this.cards.loadCards(showCards, bigCard, gameId, revertOrder);
        if (this.showType == ShowType.GRAVEYARD) {
            int qty = this.qtyCardTypes(showCards);
            String newTitle = this.name + "'s graveyard (" + showCards.size() + ")  -  " + qty + (qty == 1 ? " card type" : " card types");
            this.setTitle(newTitle);
            this.setTitelBarToolTip(newTitle);
        }
        if (this.showType == ShowType.SIDEBOARD) {
            String newTitle = this.name + "'s sideboard";
            this.setTitle(newTitle);
            this.setTitelBarToolTip(newTitle);
        }
        this.showAndPositionWindow();
    }

    public Map<UUID, MageCard> getMageCardsForUpdate() {
        return this.cards.getMageCardsForUpdate();
    }

    @Override
    public void show() {
        if (this.showType == ShowType.EXILE && (this.cards == null || this.cards.getNumberOfCards() == 0)) {
            return;
        }
        super.show();
        if (!this.positioned) {
            this.showAndPositionWindow();
        }
    }

    private void showAndPositionWindow() {
        SwingUtilities.invokeLater(() -> {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width > 0 && height > 0) {
                Point centered = SettingsManager.instance.getComponentPosition(width, height);
                if (!this.positioned) {
                    int minWidth = this.getWidth();
                    int maxWidth = SettingsManager.instance.getScreenWidth() / 2;
                    int needWidth = this.cards.getPreferredSize().width;
                    needWidth = Math.max(needWidth, minWidth);
                    needWidth = Math.min(needWidth, maxWidth);
                    int needHeight = this.getHeight();
                    this.setPreferredSize(new Dimension(needWidth += GUISizeHelper.scrollBarSize, needHeight));
                    this.pack();
                    centered = SettingsManager.instance.getComponentPosition(needWidth, needHeight);
                    int xPos = centered.x / 2 + RandomUtil.nextInt(50);
                    int yPos = centered.y / 2 + RandomUtil.nextInt(50);
                    this.setLocation(xPos, yPos);
                    this.show();
                    this.positioned = true;
                }
                GuiDisplayUtil.keepComponentInsideFrame(centered.x, centered.y, this);
            }
        });
    }

    private int qtyCardTypes(CardsView cardsView) {
        LinkedHashSet<String> cardTypesPresent = new LinkedHashSet<String>(){};
        for (CardView card : cardsView.values()) {
            EnumSet<CardType> cardTypes = EnumSet.noneOf(CardType.class);
            cardTypes.addAll(card.getCardTypes());
            for (CardType cardType : cardTypes) {
                cardTypesPresent.add(cardType.toString());
            }
        }
        if (cardTypesPresent.isEmpty()) {
            return 0;
        }
        return cardTypesPresent.size();
    }

    private void initComponents() {
        this.cards = new Cards();
        this.setIconifiable(true);
        this.setResizable(true);
        this.setPreferredSize(new Dimension((int)Math.round((double)GUISizeHelper.otherZonesCardDimension.width * 1.4), (int)Math.round((double)GUISizeHelper.otherZonesCardDimension.height * 1.4)));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.cards, "Center");
        this.pack();
    }

    public static enum ShowType {
        REVEAL,
        REVEAL_TOP_LIBRARY,
        LOOKED_AT,
        EXILE,
        GRAVEYARD,
        COMPANION,
        SIDEBOARD,
        OTHER;

    }
}

