/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckFileFilter;
import mage.cards.decks.importer.DeckImporter;
import mage.client.MageFrame;
import mage.client.dialog.MageDialog;
import mage.client.dialog.PreferencesDialog;
import mage.game.GameException;
import mage.game.match.MatchOptions;
import mage.game.mulligan.MulliganType;
import org.apache.log4j.Logger;

public class CustomOptionsDialog
extends MageDialog {
    private static final Logger logger = Logger.getLogger(CustomOptionsDialog.class);
    private final SaveLoadKeys saveLoadKeys;
    private final JButton openButton;
    private final JFileChooser fcSelectEmblemCardsPerPlayer;
    private final JFileChooser fcSelectEmblemCardsStartingPlayer;
    private JButton btnEmblemCardsPerPlayer;
    private JButton btnEmblemCardsStartingPlayer;
    private JButton btnOK;
    private JComboBox<String> cbMulliganType;
    private JCheckBox checkStartingHandSize;
    private JCheckBox checkStartingLife;
    private JCheckBox chkEmblemCards;
    private JCheckBox chkPlaneChase;
    private JLabel emblemCardsDescriptionLabel;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JLabel lblEmblemCardsPerPlayer;
    private JLabel lblEmblemCardsStartingPlayer;
    private JLabel lblFreeMulligans;
    private JLabel lblGeneralOptions;
    private JLabel lblMulliganType;
    private JLabel lblVariantOptions;
    private JLabel planechaseDescriptionLabel;
    private JSpinner spnCustomLifeTotal;
    private JSpinner spnCustomStartingHand;
    private JSpinner spnFreeMulligans;
    private JTextField txtEmblemCardsPerPlayer;
    private JTextField txtEmblemCardsStartingPlayer;

    public CustomOptionsDialog(SaveLoadKeys saveLoadKeys, JButton openButton) {
        this.saveLoadKeys = saveLoadKeys;
        this.openButton = openButton;
        this.initComponents();
        this.spnFreeMulligans.setModel(new SpinnerNumberModel(0, 0, 5, 1));
        this.cbMulliganType.setModel(new DefaultComboBoxModel<MulliganType>(MulliganType.values()));
        this.spnCustomLifeTotal.setModel(new SpinnerNumberModel(20, 1, 100, 1));
        this.spnCustomLifeTotal.setEnabled(false);
        this.spnCustomStartingHand.setModel(new SpinnerNumberModel(7, 0, 20, 1));
        this.spnCustomStartingHand.setEnabled(false);
        this.setModal(true);
        this.fcSelectEmblemCardsPerPlayer = new JFileChooser();
        this.fcSelectEmblemCardsPerPlayer.setAcceptAllFileFilterUsed(false);
        this.fcSelectEmblemCardsPerPlayer.addChoosableFileFilter(new DeckFileFilter("dck", "XMage's deck files (*.dck)"));
        this.fcSelectEmblemCardsStartingPlayer = new JFileChooser();
        this.fcSelectEmblemCardsStartingPlayer.setAcceptAllFileFilterUsed(false);
        this.fcSelectEmblemCardsStartingPlayer.addChoosableFileFilter(new DeckFileFilter("dck", "XMage's deck files (*.dck)"));
    }

    private void initComponents() {
        this.lblGeneralOptions = new JLabel();
        this.lblMulliganType = new JLabel();
        this.cbMulliganType = new JComboBox();
        this.lblFreeMulligans = new JLabel();
        this.spnFreeMulligans = new JSpinner();
        this.jSeparator2 = new JSeparator();
        this.lblVariantOptions = new JLabel();
        this.chkPlaneChase = new JCheckBox();
        this.planechaseDescriptionLabel = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.btnOK = new JButton();
        this.jSeparator3 = new JSeparator();
        this.chkEmblemCards = new JCheckBox();
        this.btnEmblemCardsPerPlayer = new JButton();
        this.txtEmblemCardsPerPlayer = new JTextField();
        this.lblEmblemCardsPerPlayer = new JLabel();
        this.btnEmblemCardsStartingPlayer = new JButton();
        this.txtEmblemCardsStartingPlayer = new JTextField();
        this.lblEmblemCardsStartingPlayer = new JLabel();
        this.emblemCardsDescriptionLabel = new JLabel();
        this.spnCustomLifeTotal = new JSpinner();
        this.checkStartingLife = new JCheckBox();
        this.checkStartingHandSize = new JCheckBox();
        this.spnCustomStartingHand = new JSpinner();
        this.setTitle("Custom Options");
        this.lblGeneralOptions.setFont(new Font("Tahoma", 1, 11));
        this.lblGeneralOptions.setText("General Options");
        this.lblMulliganType.setLabelFor(this.cbMulliganType);
        this.lblMulliganType.setText("Mulligan type:");
        this.lblMulliganType.setToolTipText("What style of mulligan?");
        this.cbMulliganType.setToolTipText("Selections the type of mulligan for games.");
        this.cbMulliganType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomOptionsDialog.this.cbMulliganTypeActionPerformed(evt);
            }
        });
        this.lblFreeMulligans.setLabelFor(this.cbMulliganType);
        this.lblFreeMulligans.setText("Free mulligans:");
        this.lblFreeMulligans.setToolTipText("What style of mulligan?");
        this.spnFreeMulligans.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CustomOptionsDialog.this.spnFreeMulligansStateChanged(evt);
            }
        });
        this.lblVariantOptions.setFont(new Font("Tahoma", 1, 11));
        this.lblVariantOptions.setText("Variant Options");
        this.chkPlaneChase.setText("Planechase");
        this.chkPlaneChase.setToolTipText("Use the PlaneChase variant for your game.");
        this.chkPlaneChase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomOptionsDialog.this.chkPlaneChaseActionPerformed(evt);
            }
        });
        this.planechaseDescriptionLabel.setText("<html>Shared planar deck of all implemented planes.<br>Uses a 9-sided planar die with 2 planeswalk sides and 2 chaos sides.<br>Some ability text may be incorrect.<br>Some rules details (such as who controls plane abilities) may be incorrect.");
        this.planechaseDescriptionLabel.setVerticalAlignment(1);
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomOptionsDialog.this.btnOKActionPerformed(evt);
            }
        });
        this.chkEmblemCards.setFont(new Font("Tahoma", 1, 11));
        this.chkEmblemCards.setText("Emblem Cards (Experimental)");
        this.chkEmblemCards.setToolTipText("If enabled, select cards to give players emblem copies of");
        this.chkEmblemCards.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomOptionsDialog.this.chkEmblemCardsActionPerformed(evt);
            }
        });
        this.btnEmblemCardsPerPlayer.setText("...");
        this.btnEmblemCardsPerPlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomOptionsDialog.this.btnEmblemCardsPerPlayerActionPerformed(evt);
            }
        });
        this.txtEmblemCardsPerPlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomOptionsDialog.this.txtEmblemCardsPerPlayerActionPerformed(evt);
            }
        });
        this.lblEmblemCardsPerPlayer.setText("Per-Player File");
        this.lblEmblemCardsPerPlayer.setToolTipText("An emblem of each card in this file is given to each player");
        this.btnEmblemCardsStartingPlayer.setText("...");
        this.btnEmblemCardsStartingPlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomOptionsDialog.this.btnEmblemCardsStartingPlayerActionPerformed(evt);
            }
        });
        this.txtEmblemCardsStartingPlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomOptionsDialog.this.txtEmblemCardsStartingPlayerActionPerformed(evt);
            }
        });
        this.lblEmblemCardsStartingPlayer.setText("Starting Player File");
        this.lblEmblemCardsStartingPlayer.setToolTipText("An emblem of every card in this file is given to the starting player (useful for symmetric effects)");
        this.emblemCardsDescriptionLabel.setText("<html>Give players emblems with the abilities of cards.<br>Note that some abilities may not function correctly from the command zone.<br>If anything breaks, please report it on GitHub.");
        this.emblemCardsDescriptionLabel.setVerticalAlignment(1);
        this.spnCustomLifeTotal.setToolTipText("Custom starting life total");
        this.spnCustomLifeTotal.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CustomOptionsDialog.this.spnCustomLifeTotalStateChanged(evt);
            }
        });
        this.checkStartingLife.setToolTipText("Check to use a specific starting life total");
        this.checkStartingLife.setActionCommand("checkCustomLife");
        this.checkStartingLife.setHorizontalTextPosition(10);
        this.checkStartingLife.setLabel("Custom Starting Life");
        this.checkStartingLife.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomOptionsDialog.this.checkStartingLifeActionPerformed(evt);
            }
        });
        this.checkStartingHandSize.setText("Custom Starting Hand");
        this.checkStartingHandSize.setToolTipText("Check to use a specific starting hand size");
        this.checkStartingHandSize.setActionCommand("checkCustomHandSize");
        this.checkStartingHandSize.setHorizontalTextPosition(10);
        this.checkStartingHandSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomOptionsDialog.this.checkStartingHandSizeActionPerformed(evt);
            }
        });
        this.spnCustomStartingHand.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CustomOptionsDialog.this.spnCustomStartingHandStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator4, GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator2, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnOK)).addComponent(this.jSeparator3).addGroup(layout.createSequentialGroup().addComponent(this.txtEmblemCardsPerPlayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnEmblemCardsPerPlayer, -2, 24, -2)).addGroup(layout.createSequentialGroup().addComponent(this.txtEmblemCardsStartingPlayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnEmblemCardsStartingPlayer, -2, 24, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lblMulliganType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbMulliganType, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.lblFreeMulligans).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnFreeMulligans)).addComponent(this.planechaseDescriptionLabel).addComponent(this.emblemCardsDescriptionLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblVariantOptions).addComponent(this.chkPlaneChase).addComponent(this.chkEmblemCards).addComponent(this.lblEmblemCardsPerPlayer).addComponent(this.lblEmblemCardsStartingPlayer).addComponent(this.lblGeneralOptions)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.checkStartingLife).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnCustomLifeTotal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkStartingHandSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnCustomStartingHand, -2, 46, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblGeneralOptions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMulliganType).addComponent(this.cbMulliganType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spnFreeMulligans, -2, -1, -2).addComponent(this.lblFreeMulligans)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spnCustomStartingHand, -2, -1, -2).addComponent(this.checkStartingHandSize)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spnCustomLifeTotal, -2, -1, -2).addComponent(this.checkStartingLife))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblVariantOptions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkPlaneChase).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.planechaseDescriptionLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkEmblemCards).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.emblemCardsDescriptionLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEmblemCardsPerPlayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtEmblemCardsPerPlayer, -2, -1, -2).addComponent(this.btnEmblemCardsPerPlayer, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEmblemCardsStartingPlayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtEmblemCardsStartingPlayer, -2, -1, -2).addComponent(this.btnEmblemCardsStartingPlayer, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator4, -2, -1, -2).addGap(0, 0, 0).addComponent(this.btnOK, -2, 30, -2).addContainerGap()));
        this.lblMulliganType.getAccessibleContext().setAccessibleName("Mulligan Type:");
        this.lblMulliganType.getAccessibleContext().setAccessibleParent(this.lblGeneralOptions);
        this.cbMulliganType.getAccessibleContext().setAccessibleName("");
        this.cbMulliganType.getAccessibleContext().setAccessibleDescription("Select the type of mulligan for games.");
        this.cbMulliganType.getAccessibleContext().setAccessibleParent(this.lblMulliganType);
        this.lblFreeMulligans.getAccessibleContext().setAccessibleDescription("");
        this.lblFreeMulligans.getAccessibleContext().setAccessibleParent(this.lblGeneralOptions);
        this.spnFreeMulligans.getAccessibleContext().setAccessibleDescription("Select the number of free mulligans");
        this.spnFreeMulligans.getAccessibleContext().setAccessibleParent(this.lblFreeMulligans);
        this.chkPlaneChase.getAccessibleContext().setAccessibleParent(this.lblVariantOptions);
        this.planechaseDescriptionLabel.getAccessibleContext().setAccessibleName("Planechase Description");
        this.planechaseDescriptionLabel.getAccessibleContext().setAccessibleDescription("Shared planar deck of all implemented planes.\nUses a 9-sided planar die with 2 planeswalk sides and 2 chaos sides.\nSome ability text may be incorrect.\nSome rules details (such as who controls plane abilities) may be incorrect.");
        this.planechaseDescriptionLabel.getAccessibleContext().setAccessibleParent(this.chkPlaneChase);
        this.lblEmblemCardsPerPlayer.getAccessibleContext().setAccessibleParent(this.chkEmblemCards);
        this.txtEmblemCardsStartingPlayer.getAccessibleContext().setAccessibleDescription("");
        this.lblEmblemCardsStartingPlayer.getAccessibleContext().setAccessibleParent(this.chkEmblemCards);
        this.emblemCardsDescriptionLabel.getAccessibleContext().setAccessibleName("Emblem Cards description");
        this.emblemCardsDescriptionLabel.getAccessibleContext().setAccessibleDescription("Give players emblems with the abilities of cards.\nNote that some abilities may not function correctly from the command zone.\nIf anything breaks, please report it on GitHub.");
        this.spnCustomLifeTotal.getAccessibleContext().setAccessibleName("Custom starting life total");
        this.spnCustomLifeTotal.getAccessibleContext().setAccessibleDescription("Set a custom starting life total");
        this.checkStartingLife.getAccessibleContext().setAccessibleName("Custom starting life");
        this.pack();
    }

    private void btnPreviousConfigurationActionPerformed(ActionEvent evt, int i) {
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.hideDialog();
    }

    private void cbMulliganTypeActionPerformed(ActionEvent evt) {
        this.updateActiveCount();
    }

    private void spnFreeMulligansStateChanged(ChangeEvent evt) {
        this.updateActiveCount();
    }

    private void chkPlaneChaseActionPerformed(ActionEvent evt) {
        this.updateActiveCount();
    }

    private void chkEmblemCardsActionPerformed(ActionEvent evt) {
        this.updateActiveCount();
    }

    private void btnEmblemCardsPerPlayerActionPerformed(ActionEvent evt) {
        this.loadEmblemCardFile(false);
    }

    private void txtEmblemCardsPerPlayerActionPerformed(ActionEvent evt) {
    }

    private void btnEmblemCardsStartingPlayerActionPerformed(ActionEvent evt) {
        this.loadEmblemCardFile(true);
    }

    private void txtEmblemCardsStartingPlayerActionPerformed(ActionEvent evt) {
    }

    private void spnCustomLifeTotalStateChanged(ChangeEvent evt) {
        this.updateActiveCount();
    }

    private void spnCustomStartingHandStateChanged(ChangeEvent evt) {
        this.updateActiveCount();
    }

    private void checkStartingLifeActionPerformed(ActionEvent evt) {
        this.updateActiveCount();
    }

    private void checkStartingHandSizeActionPerformed(ActionEvent evt) {
        this.updateActiveCount();
    }

    public void showDialog() {
        this.setLocation(150, 100);
        this.setVisible(true);
    }

    private void loadEmblemCardFile(boolean isStartingPlayer) {
        int ret;
        JFileChooser fileChooser = isStartingPlayer ? this.fcSelectEmblemCardsStartingPlayer : this.fcSelectEmblemCardsPerPlayer;
        JTextField textField = isStartingPlayer ? this.txtEmblemCardsStartingPlayer : this.txtEmblemCardsPerPlayer;
        String prefKey = isStartingPlayer ? "lastStartingPlayerEmblemCardsFolder" : "lastPerPlayerEmblemCardsFolder";
        String lastFolder = MageFrame.getPreferences().get(prefKey, "");
        if (!lastFolder.isEmpty()) {
            fileChooser.setCurrentDirectory(new File(lastFolder));
        }
        if ((ret = fileChooser.showDialog(this, "Select Emblem Cards")) == 0) {
            File file = fileChooser.getSelectedFile();
            textField.setText(file.getPath());
            try {
                MageFrame.getPreferences().put(prefKey, file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        fileChooser.setSelectedFile(null);
    }

    public void onLoadSettings(int version) {
        String versionStr = "";
        switch (version) {
            case -1: {
                versionStr = "-1";
                break;
            }
            case 1: {
                versionStr = "1";
                break;
            }
            case 2: {
                versionStr = "2";
                break;
            }
            default: {
                versionStr = "";
            }
        }
        this.chkPlaneChase.setSelected(PreferencesDialog.getCachedValue(this.saveLoadKeys.PLANECHASE + versionStr, "No").equals("Yes"));
        this.spnFreeMulligans.setValue(Integer.parseInt(PreferencesDialog.getCachedValue(this.saveLoadKeys.NUMBER_OF_FREE_MULLIGANS + versionStr, "0")));
        this.cbMulliganType.setSelectedItem((Object)MulliganType.valueByName(PreferencesDialog.getCachedValue(this.saveLoadKeys.MULLIGAN_TYPE + versionStr, MulliganType.GAME_DEFAULT.toString())));
        this.checkStartingLife.setSelected(PreferencesDialog.getCachedValue(this.saveLoadKeys.BOOL_CUSTOM_STARTING_LIFE + versionStr, "No").equals("Yes"));
        this.spnCustomLifeTotal.setValue(Integer.parseInt(PreferencesDialog.getCachedValue(this.saveLoadKeys.NUMBER_OF_LIFE_AT_START + versionStr, "20")));
        this.checkStartingHandSize.setSelected(PreferencesDialog.getCachedValue(this.saveLoadKeys.BOOL_CUSTOM_STARTING_HAND_SIZE + versionStr, "No").equals("Yes"));
        this.spnCustomStartingHand.setValue(Integer.parseInt(PreferencesDialog.getCachedValue(this.saveLoadKeys.NUMBER_OF_HAND_SIZE_AT_START + versionStr, "7")));
        this.chkEmblemCards.setSelected(PreferencesDialog.getCachedValue(this.saveLoadKeys.EMBLEM_CARDS_ENABLED + versionStr, "No").equals("Yes"));
        this.txtEmblemCardsPerPlayer.setText(PreferencesDialog.getCachedValue(this.saveLoadKeys.EMBLEM_CARDS_PER_PLAYER_FILE, ""));
        this.txtEmblemCardsStartingPlayer.setText(PreferencesDialog.getCachedValue(this.saveLoadKeys.EMBLEM_CARDS_STARTING_PLAYER_FILE, ""));
        this.updateActiveCount();
    }

    public void onSaveSettings(int version, MatchOptions options) {
        String versionStr = "";
        switch (version) {
            case 1: {
                versionStr = "1";
                break;
            }
            case 2: {
                versionStr = "2";
                break;
            }
            default: {
                versionStr = "";
            }
        }
        PreferencesDialog.saveValue(this.saveLoadKeys.NUMBER_OF_FREE_MULLIGANS + versionStr, Integer.toString(options.getFreeMulligans()));
        PreferencesDialog.saveValue(this.saveLoadKeys.MULLIGAN_TYPE + versionStr, options.getMulliganType().toString());
        PreferencesDialog.saveValue(this.saveLoadKeys.BOOL_CUSTOM_STARTING_LIFE + versionStr, options.isCustomStartLifeEnabled() ? "Yes" : "No");
        PreferencesDialog.saveValue(this.saveLoadKeys.NUMBER_OF_LIFE_AT_START + versionStr, Integer.toString(options.getCustomStartLife()));
        PreferencesDialog.saveValue(this.saveLoadKeys.BOOL_CUSTOM_STARTING_HAND_SIZE + versionStr, options.isCustomStartHandSizeEnabled() ? "Yes" : "No");
        PreferencesDialog.saveValue(this.saveLoadKeys.NUMBER_OF_HAND_SIZE_AT_START + versionStr, Integer.toString(options.getCustomStartHandSize()));
        PreferencesDialog.saveValue(this.saveLoadKeys.PLANECHASE + versionStr, options.isPlaneChase() ? "Yes" : "No");
        PreferencesDialog.saveValue(this.saveLoadKeys.EMBLEM_CARDS_ENABLED + versionStr, !options.getGlobalEmblemCards().isEmpty() || !options.getPerPlayerEmblemCards().isEmpty() ? "Yes" : "No");
        PreferencesDialog.saveValue(this.saveLoadKeys.EMBLEM_CARDS_PER_PLAYER_FILE + versionStr, this.txtEmblemCardsPerPlayer.getText());
        PreferencesDialog.saveValue(this.saveLoadKeys.EMBLEM_CARDS_STARTING_PLAYER_FILE + versionStr, this.txtEmblemCardsStartingPlayer.getText());
    }

    public void writeMatchOptionsTo(MatchOptions options) {
        options.setFreeMulligans((Integer)this.spnFreeMulligans.getValue());
        options.setMullgianType((MulliganType)((Object)this.cbMulliganType.getSelectedItem()));
        options.setCustomStartLifeEnabled(this.checkStartingLife.isSelected());
        options.setCustomStartLife((Integer)this.spnCustomLifeTotal.getValue());
        options.setCustomStartHandSizeEnabled(this.checkStartingHandSize.isSelected());
        options.setCustomStartHandSize((Integer)this.spnCustomStartingHand.getValue());
        options.setPlaneChase(this.chkPlaneChase.isSelected());
        if (this.chkEmblemCards.isSelected()) {
            if (!this.txtEmblemCardsPerPlayer.getText().isEmpty()) {
                Deck perPlayerEmblemDeck = null;
                try {
                    perPlayerEmblemDeck = Deck.load(DeckImporter.importDeckFromFile(this.txtEmblemCardsPerPlayer.getText(), true), true, true);
                }
                catch (GameException e1) {
                    JOptionPane.showMessageDialog(MageFrame.getDesktop(), e1.getMessage(), "Error loading deck", 0);
                }
                if (perPlayerEmblemDeck != null) {
                    perPlayerEmblemDeck.clearLayouts();
                    options.setPerPlayerEmblemCards(perPlayerEmblemDeck.prepareCardsOnlyDeck().getCards());
                } else {
                    options.setPerPlayerEmblemCards(Collections.emptySet());
                }
            }
            if (!this.txtEmblemCardsStartingPlayer.getText().isEmpty()) {
                Deck startingPlayerEmblemDeck = null;
                try {
                    startingPlayerEmblemDeck = Deck.load(DeckImporter.importDeckFromFile(this.txtEmblemCardsStartingPlayer.getText(), true), true, true);
                }
                catch (GameException e1) {
                    JOptionPane.showMessageDialog(MageFrame.getDesktop(), e1.getMessage(), "Error loading deck", 0);
                }
                if (startingPlayerEmblemDeck != null) {
                    startingPlayerEmblemDeck.clearLayouts();
                    options.setGlobalEmblemCards(startingPlayerEmblemDeck.prepareCardsOnlyDeck().getCards());
                } else {
                    options.setGlobalEmblemCards(Collections.emptySet());
                }
            }
        } else {
            options.setPerPlayerEmblemCards(Collections.emptySet());
            options.setGlobalEmblemCards(Collections.emptySet());
        }
    }

    public void updateActiveCount() {
        int activeCount = 0;
        if ((Integer)this.spnFreeMulligans.getValue() > 0) {
            ++activeCount;
        }
        if (this.checkStartingLife.isSelected()) {
            ++activeCount;
        }
        this.spnCustomLifeTotal.setEnabled(this.checkStartingLife.isSelected());
        if (this.checkStartingHandSize.isSelected()) {
            ++activeCount;
        }
        this.spnCustomStartingHand.setEnabled(this.checkStartingHandSize.isSelected());
        if (!this.cbMulliganType.getSelectedItem().toString().equals(MulliganType.GAME_DEFAULT.toString())) {
            ++activeCount;
        }
        if (this.chkPlaneChase.isSelected()) {
            ++activeCount;
        }
        if (this.chkEmblemCards.isSelected()) {
            ++activeCount;
        }
        if (activeCount == 0) {
            this.openButton.setText("Custom Options...");
        } else {
            this.openButton.setText("Custom Options (" + activeCount + ")");
        }
    }

    public static enum SaveLoadKeys {
        TABLE("newTableNumberOfFreeMulligans", "newTableMulliganType", "newTableUseCustomLife", "newTableNumberOfLifeAtStart", "newTableUseCustomHandSize", "newTableNumberOfHandSizeAtStart", "newTablePlaneChase", "newTableEmblemCardsEnabled", "newTableEmblemCardsPerPlayerFile", "newTableEmblemCardsStartingPlayerFile"),
        TOURNEY("newTournamentNumberOfFreeMulligans", "newTournamentMulliganType", "newTournamentUseCustomLife", "newTournamentNumberOfLifeAtStart", "newTournamentUseCustomHandSize", "newTournamentNumberOfHandSizeAtStart", "newTournamentPlaneChase", "newTournamentEmblemCardsEnabled", "newTournamentEmblemCardsPerPlayerFile", "newTournamentEmblemCardsStartingPlayerFile");

        public final String NUMBER_OF_FREE_MULLIGANS;
        public final String MULLIGAN_TYPE;
        public final String BOOL_CUSTOM_STARTING_LIFE;
        public final String NUMBER_OF_LIFE_AT_START;
        public final String BOOL_CUSTOM_STARTING_HAND_SIZE;
        public final String NUMBER_OF_HAND_SIZE_AT_START;
        public final String PLANECHASE;
        public final String EMBLEM_CARDS_ENABLED;
        public final String EMBLEM_CARDS_PER_PLAYER_FILE;
        public final String EMBLEM_CARDS_STARTING_PLAYER_FILE;

        private SaveLoadKeys(String numberOfFreeMulligans, String mulliganType, String customStartLife, String valueStartLife, String customStartHandSize, String valueStartHandSize, String planechase, String emblemCardsEnabled, String emblemCardsPerPlayerFile, String emblemCardsStartingPlayerFile) {
            this.NUMBER_OF_FREE_MULLIGANS = numberOfFreeMulligans;
            this.MULLIGAN_TYPE = mulliganType;
            this.BOOL_CUSTOM_STARTING_LIFE = customStartLife;
            this.NUMBER_OF_LIFE_AT_START = valueStartLife;
            this.BOOL_CUSTOM_STARTING_HAND_SIZE = customStartHandSize;
            this.NUMBER_OF_HAND_SIZE_AT_START = valueStartHandSize;
            this.PLANECHASE = planechase;
            this.EMBLEM_CARDS_ENABLED = emblemCardsEnabled;
            this.EMBLEM_CARDS_PER_PLAYER_FILE = emblemCardsPerPlayerFile;
            this.EMBLEM_CARDS_STARTING_PLAYER_FILE = emblemCardsStartingPlayerFile;
        }
    }
}

