/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import mage.client.MageFrame;
import mage.client.dialog.MageDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.game.GamePanel;
import mage.client.util.Format;
import mage.client.util.ImageHelper;
import mage.client.util.audio.AudioManager;
import mage.client.util.gui.BufferedImageBuilder;
import mage.view.GameEndView;
import mage.view.PlayerView;

public class GameEndDialog
extends MageDialog {
    private JButton btnOk;
    private JPanel jPanel2;
    private JLabel lblAdditionalInfo;
    private JLabel lblDurationGame;
    private JLabel lblDurationMatch;
    private JLabel lblGameInfo;
    private JLabel lblLife;
    private JLabel lblMatchInfo;
    private JLabel lblMatchScore;
    private JLabel lblPlayerInfo;
    private JLabel lblResultImage;
    private JLayeredPane pnlText;
    private JTabbedPane tabPane;
    private JLayeredPane tabResult;
    private JPanel tabStatistics;
    private JLabel txtDurationGame;
    private JLabel txtDurationMatch;
    private JLabel txtLife;
    private JLabel txtMatchScore;
    private JLabel txtPlayerInfo;

    public GameEndDialog(GameEndView gameEndView) {
        this.initComponents();
        this.setModal(true);
        this.pnlText.setOpaque(true);
        this.pnlText.setBackground(new Color(240, 240, 240, 140));
        Rectangle r = new Rectangle(610, 250);
        Image image = gameEndView.hasWon() ? ImageHelper.getImageFromResources(PreferencesDialog.getCurrentTheme().getWinlossPath("game_won.jpg")) : ImageHelper.getImageFromResources(PreferencesDialog.getCurrentTheme().getWinlossPath("game_lost.jpg"));
        BufferedImage imageResult = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(image, 2), r);
        ImageIcon icon = new ImageIcon(imageResult);
        this.lblResultImage.setIcon(icon);
        this.lblGameInfo.setText(gameEndView.getGameInfo());
        this.lblMatchInfo.setText(gameEndView.getMatchInfo());
        this.lblAdditionalInfo.setText(gameEndView.getAdditionalInfo());
        String autoSave = PreferencesDialog.getCachedValue("gameLogAutoSave", "true");
        if (autoSave.equals("true")) {
            this.saveGameLog(gameEndView);
        }
        DateFormat df = DateFormat.getDateTimeInstance();
        this.txtDurationGame.setText(" " + Format.getDuration(gameEndView.getStartTime(), gameEndView.getEndTime()));
        this.txtDurationGame.setToolTipText(df.format(gameEndView.getStartTime()) + " - " + df.format(gameEndView.getEndTime()));
        Calendar cal = Calendar.getInstance();
        this.txtDurationMatch.setText(" " + Format.getDuration(gameEndView.getMatchView().getStartTime(), cal.getTime()));
        this.txtDurationMatch.setToolTipText(df.format(gameEndView.getMatchView().getStartTime()) + " - " + df.format(cal.getTime()));
        StringBuilder sb = new StringBuilder(" ");
        for (PlayerView player : gameEndView.getPlayers()) {
            sb.append(player.getName()).append(" Life: ").append(player.getLife()).append(' ');
        }
        this.txtLife.setText(sb.toString());
        if (gameEndView.hasWon()) {
            AudioManager.playPlayerWon();
        } else {
            AudioManager.playPlayerLost();
        }
        this.txtMatchScore.setText(gameEndView.getMatchView().getResult());
    }

    private void saveGameLog(GameEndView gameEndView) {
        String dir = "gamelogs";
        File saveDir = new File(dir);
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        try {
            GamePanel gamePanel;
            if (gameEndView.getMatchView().getGames().size() > 0 && (gamePanel = MageFrame.getGame((UUID)gameEndView.getMatchView().getGames().get(gameEndView.getMatchView().getGames().size() - 1))) != null) {
                SimpleDateFormat sdf = new SimpleDateFormat();
                sdf.applyPattern("yyyyMMdd_HHmmss");
                String fileName = dir + File.separator + sdf.format(gameEndView.getStartTime()) + '_' + gameEndView.getMatchView().getGameType() + '_' + gameEndView.getMatchView().getGames().size() + ".html";
                PrintWriter out = new PrintWriter(fileName);
                String log = gamePanel.getGameLog();
                log = log.replace("<body>", "<body style=\"background-color:black\">");
                log = log.replace("<font color=\"#CCCC33\">", "<br><font color=\"#CCCC33\">");
                out.print(log);
                out.close();
            }
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "Error while writing game log to file\n\n" + ex, "Error writing gamelog", 0);
        }
    }

    public void showDialog() {
        this.setLocation(100, 100);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.tabPane = new JTabbedPane();
        this.tabResult = new JLayeredPane();
        this.pnlText = new JLayeredPane();
        this.lblGameInfo = new JLabel();
        this.lblMatchInfo = new JLabel();
        this.lblAdditionalInfo = new JLabel();
        this.lblResultImage = new JLabel();
        this.tabStatistics = new JPanel();
        this.lblDurationGame = new JLabel();
        this.txtDurationGame = new JLabel();
        this.lblLife = new JLabel();
        this.txtLife = new JLabel();
        this.lblDurationMatch = new JLabel();
        this.txtDurationMatch = new JLabel();
        this.lblMatchScore = new JLabel();
        this.txtMatchScore = new JLabel();
        this.lblPlayerInfo = new JLabel();
        this.txtPlayerInfo = new JLabel();
        this.btnOk = new JButton();
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setTitle("Game end information");
        this.pnlText.setBackground(new Color(200, 100, 100));
        this.pnlText.setBorder(BorderFactory.createEtchedBorder());
        this.pnlText.setOpaque(true);
        this.lblGameInfo.setFont(new Font("Tahoma", 3, 18));
        this.lblGameInfo.setHorizontalAlignment(0);
        this.lblGameInfo.setText("gameInfo");
        this.pnlText.add(this.lblGameInfo);
        this.lblGameInfo.setBounds(11, 1, 550, 25);
        this.lblMatchInfo.setFont(new Font("Tahoma", 3, 18));
        this.lblMatchInfo.setHorizontalAlignment(0);
        this.lblMatchInfo.setText("matchInfo");
        this.pnlText.add(this.lblMatchInfo);
        this.lblMatchInfo.setBounds(10, 30, 550, 25);
        this.lblAdditionalInfo.setFont(new Font("Tahoma", 3, 18));
        this.lblAdditionalInfo.setHorizontalAlignment(0);
        this.lblAdditionalInfo.setText("additionalInfo");
        this.pnlText.add(this.lblAdditionalInfo);
        this.lblAdditionalInfo.setBounds(10, 60, 550, 25);
        this.tabResult.add(this.pnlText);
        this.pnlText.setBounds(20, 150, 570, 90);
        this.lblResultImage.setFont(new Font("Tahoma", 1, 24));
        this.lblResultImage.setHorizontalAlignment(0);
        this.tabResult.add(this.lblResultImage);
        this.lblResultImage.setBounds(0, 0, 610, 250);
        this.tabPane.addTab("Result", this.tabResult);
        this.lblDurationGame.setText("Duration game:");
        this.txtDurationGame.setText("Duration Game");
        this.txtDurationGame.setBorder(BorderFactory.createEtchedBorder());
        this.lblLife.setText("Life at end:");
        this.txtLife.setBorder(BorderFactory.createEtchedBorder());
        this.lblDurationMatch.setText("Duration match:");
        this.txtDurationMatch.setBorder(BorderFactory.createEtchedBorder());
        this.lblMatchScore.setText("Match score:");
        this.txtMatchScore.setBorder(BorderFactory.createEtchedBorder());
        this.lblPlayerInfo.setText("Player info:");
        this.txtPlayerInfo.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout tabStatisticsLayout = new GroupLayout(this.tabStatistics);
        this.tabStatistics.setLayout(tabStatisticsLayout);
        tabStatisticsLayout.setHorizontalGroup(tabStatisticsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabStatisticsLayout.createSequentialGroup().addContainerGap().addGroup(tabStatisticsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPlayerInfo, -2, 90, -2).addComponent(this.lblDurationMatch, -2, 101, -2).addComponent(this.lblMatchScore, -2, 86, -2).addComponent(this.lblDurationGame, -2, 101, -2).addComponent(this.lblLife, -2, 71, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabStatisticsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtPlayerInfo, -1, -1, Short.MAX_VALUE).addComponent(this.txtDurationGame, GroupLayout.Alignment.TRAILING, -1, 494, Short.MAX_VALUE).addComponent(this.txtLife, GroupLayout.Alignment.TRAILING, -1, 489, Short.MAX_VALUE).addComponent(this.txtDurationMatch, GroupLayout.Alignment.TRAILING, -1, 489, Short.MAX_VALUE).addComponent(this.txtMatchScore, GroupLayout.Alignment.TRAILING, -1, 489, Short.MAX_VALUE)).addContainerGap()));
        tabStatisticsLayout.setVerticalGroup(tabStatisticsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabStatisticsLayout.createSequentialGroup().addGroup(tabStatisticsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDurationGame, -2, 24, -2).addComponent(this.txtDurationGame, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabStatisticsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblLife, -2, 24, -2).addComponent(this.txtLife, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabStatisticsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblDurationMatch, -2, 24, -2).addComponent(this.txtDurationMatch, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabStatisticsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblMatchScore, -2, 24, -2).addComponent(this.txtMatchScore, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabStatisticsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPlayerInfo, -2, 24, -2).addComponent(this.txtPlayerInfo, -2, 24, -2)).addContainerGap(105, Short.MAX_VALUE)));
        this.tabPane.addTab("Statistics", this.tabStatistics);
        this.btnOk.setText("OK");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameEndDialog.this.btnOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnOk).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.tabPane, -2, 626, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tabPane, -2, 277, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOk).addGap(0, 8, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.removeDialog();
    }
}

