/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mage.cards.decks.importer.DeckImporter;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.components.MageComponents;
import mage.client.dialog.CustomOptionsDialog;
import mage.client.dialog.MageDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.table.NewPlayerPanel;
import mage.client.table.TablePlayerPanel;
import mage.client.util.IgnoreList;
import mage.constants.MatchBufferTime;
import mage.constants.MatchTimeLimit;
import mage.constants.MultiplayerAttackOption;
import mage.constants.RangeOfInfluence;
import mage.constants.SkillLevel;
import mage.game.match.MatchOptions;
import mage.players.PlayerType;
import mage.view.GameTypeView;
import mage.view.TableView;
import org.apache.log4j.Logger;

public class NewTableDialog
extends MageDialog {
    private static final Logger logger = Logger.getLogger(NewTableDialog.class);
    public static final int DEFAULT_COMPUTER_PLAYER_SKILL_LEVEL = 2;
    public static final String PLAYER_DATA_DELIMETER_OLD = ",";
    public static final String PLAYER_DATA_DELIMETER_NEW = "@@@";
    private final CustomOptionsDialog customOptions;
    private TableView table;
    private UUID playerId;
    private UUID roomId;
    private String lastSessionId = "";
    private final List<TablePlayerPanel> players = new ArrayList<TablePlayerPanel>();
    private final List<PlayerType> prefPlayerTypes = new ArrayList<PlayerType>();
    private final List<Integer> prefPlayerSkills = new ArrayList<Integer>();
    private final List<String> prefPlayerDecks = new ArrayList<String>();
    private static final String LIMITED = "Limited";
    private JButton btnCancel;
    private JButton btnCustomOptions;
    private JButton btnOK;
    private JButton btnSettingsLoad;
    private JButton btnSettingsSave;
    private JComboBox cbAttackOption;
    private JComboBox cbBufferTime;
    private JComboBox cbDeckType;
    private JComboBox cbGameType;
    private JComboBox cbRange;
    private JComboBox cbSkillLevel;
    private JComboBox cbTimeLimit;
    private JCheckBox chkRated;
    private JCheckBox chkRollbackTurnsAllowed;
    private JCheckBox chkSpectatorsAllowed;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JLabel lbBufferTime;
    private JLabel lbDeckType;
    private JLabel lbTimeLimit;
    private JLabel lblAttack;
    private JLabel lblEdhPowerLevel;
    private JLabel lblGameType;
    private JLabel lblMinimumRating;
    private JLabel lblName;
    private JLabel lblNumPlayers;
    private JLabel lblNumWins;
    private JLabel lblPassword;
    private JLabel lblQuitRatio;
    private JLabel lblRange;
    private JLabel lblSettings;
    private JLabel lblSkillLevel;
    private JMenuItem menuLoadSettings1;
    private JMenuItem menuLoadSettings2;
    private JMenuItem menuLoadSettingsDefault;
    private JMenuItem menuLoadSettingsLast;
    private JMenuItem menuSaveSettings1;
    private JMenuItem menuSaveSettings2;
    private NewPlayerPanel player1Panel;
    private JPanel pnlOtherPlayers;
    private JPopupMenu popupLoadSettings;
    private JPopupMenu popupSaveSettings;
    private JPopupMenu.Separator separator1;
    private JPopupMenu.Separator separator2;
    private JSpinner spnEdhPowerLevel;
    private JSpinner spnMinimumRating;
    private JSpinner spnNumPlayers;
    private JSpinner spnNumWins;
    private JSpinner spnQuitRatio;
    private JTextField txtName;
    private JTextField txtPassword;

    public NewTableDialog() {
        this.initComponents();
        this.customOptions = new CustomOptionsDialog(CustomOptionsDialog.SaveLoadKeys.TABLE, this.btnCustomOptions);
        MageFrame.getDesktop().add((Component)this.customOptions, this.customOptions.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.player1Panel.showLevel(false);
        this.spnNumWins.setModel(new SpinnerNumberModel(1, 1, 5, 1));
        this.spnQuitRatio.setModel(new SpinnerNumberModel(100, 0, 100, 5));
        this.spnMinimumRating.setModel(new SpinnerNumberModel(0, 0, 3000, 10));
        this.spnEdhPowerLevel.setModel(new SpinnerNumberModel(100, 0, 100, 5));
        MageFrame.getUI().addButton(MageComponents.NEW_TABLE_OK_BUTTON, this.btnOK);
    }

    private void initComponents() {
        this.popupSaveSettings = new JPopupMenu();
        this.menuSaveSettings1 = new JMenuItem();
        this.menuSaveSettings2 = new JMenuItem();
        this.popupLoadSettings = new JPopupMenu();
        this.menuLoadSettingsLast = new JMenuItem();
        this.separator1 = new JPopupMenu.Separator();
        this.menuLoadSettings1 = new JMenuItem();
        this.menuLoadSettings2 = new JMenuItem();
        this.separator2 = new JPopupMenu.Separator();
        this.menuLoadSettingsDefault = new JMenuItem();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblPassword = new JLabel();
        this.txtPassword = new JTextField();
        this.lbDeckType = new JLabel();
        this.cbDeckType = new JComboBox();
        this.lbTimeLimit = new JLabel();
        this.cbTimeLimit = new JComboBox();
        this.lbBufferTime = new JLabel();
        this.cbBufferTime = new JComboBox();
        this.lblGameType = new JLabel();
        this.cbGameType = new JComboBox();
        this.chkRollbackTurnsAllowed = new JCheckBox();
        this.chkSpectatorsAllowed = new JCheckBox();
        this.lblNumPlayers = new JLabel();
        this.spnNumPlayers = new JSpinner();
        this.lblSkillLevel = new JLabel();
        this.cbSkillLevel = new JComboBox();
        this.lblNumWins = new JLabel();
        this.spnNumWins = new JSpinner();
        this.jSeparator2 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.player1Panel = new NewPlayerPanel();
        this.jSeparator3 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.pnlOtherPlayers = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.lblQuitRatio = new JLabel();
        this.spnQuitRatio = new JSpinner();
        this.lblEdhPowerLevel = new JLabel();
        this.spnEdhPowerLevel = new JSpinner();
        this.lblMinimumRating = new JLabel();
        this.spnMinimumRating = new JSpinner();
        this.chkRated = new JCheckBox();
        this.btnSettingsLoad = new JButton();
        this.btnSettingsSave = new JButton();
        this.lblSettings = new JLabel();
        this.btnCustomOptions = new JButton();
        this.lblRange = new JLabel();
        this.cbRange = new JComboBox();
        this.lblAttack = new JLabel();
        this.cbAttackOption = new JComboBox();
        this.menuSaveSettings1.setText("Save to config 1");
        this.menuSaveSettings1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableDialog.this.menuSaveSettings1ActionPerformed(evt);
            }
        });
        this.popupSaveSettings.add(this.menuSaveSettings1);
        this.menuSaveSettings2.setText("Save to config 2");
        this.menuSaveSettings2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableDialog.this.menuSaveSettings2ActionPerformed(evt);
            }
        });
        this.popupSaveSettings.add(this.menuSaveSettings2);
        this.menuLoadSettingsLast.setText("Load from last time");
        this.menuLoadSettingsLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableDialog.this.menuLoadSettingsLastActionPerformed(evt);
            }
        });
        this.popupLoadSettings.add(this.menuLoadSettingsLast);
        this.popupLoadSettings.add(this.separator1);
        this.menuLoadSettings1.setText("Load from config 1");
        this.menuLoadSettings1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableDialog.this.menuLoadSettings1ActionPerformed(evt);
            }
        });
        this.popupLoadSettings.add(this.menuLoadSettings1);
        this.menuLoadSettings2.setText("Load from config 2");
        this.menuLoadSettings2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableDialog.this.menuLoadSettings2ActionPerformed(evt);
            }
        });
        this.popupLoadSettings.add(this.menuLoadSettings2);
        this.popupLoadSettings.add(this.separator2);
        this.menuLoadSettingsDefault.setText("Load default settings");
        this.menuLoadSettingsDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableDialog.this.menuLoadSettingsDefaultActionPerformed(evt);
            }
        });
        this.popupLoadSettings.add(this.menuLoadSettingsDefault);
        this.setTitle("New Table");
        this.lblName.setLabelFor(this.txtName);
        this.lblName.setText("Name:");
        this.lblPassword.setLabelFor(this.txtPassword);
        this.lblPassword.setText("Password:");
        this.lbDeckType.setText("Deck Type:");
        this.lbTimeLimit.setText("Time Limit:");
        this.lbTimeLimit.setToolTipText("The active time a player may use to finish the match. If their time runs out, the player looses the current game.");
        this.lbBufferTime.setText("Buffer Time:");
        this.lbBufferTime.setToolTipText("The extra time a player gets whenever the timer starts before their normal time limit starts going down.");
        this.cbBufferTime.setToolTipText("The extra time a player gets whenever the timer starts before their normal time limit starts going down.");
        this.lblGameType.setText("Game Type:");
        this.cbGameType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableDialog.this.cbGameTypeActionPerformed(evt);
            }
        });
        this.chkRollbackTurnsAllowed.setText("Rollbacks");
        this.chkRollbackTurnsAllowed.setToolTipText("<HTML>Allow to rollback to the start of previous turns<br>\nif all players agree.\n");
        this.chkSpectatorsAllowed.setText("Spectators allowed");
        this.chkSpectatorsAllowed.setToolTipText("Allow spectators to view your game.");
        this.lblNumPlayers.setLabelFor(this.spnNumPlayers);
        this.lblNumPlayers.setText("Players:");
        this.spnNumPlayers.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewTableDialog.this.numPlayersChanged(evt);
            }
        });
        this.lblSkillLevel.setText("Skill Level:");
        this.cbSkillLevel.setToolTipText("<HTML>This option can be used to make it easier to find matches<br>\nwith opponents of the appropriate skill level.");
        this.lblNumWins.setLabelFor(this.spnNumWins);
        this.lblNumWins.setText("Wins:");
        this.lblNumWins.setToolTipText("How many games has a player to win to win the match.");
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Player 1 (You)");
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Other Players");
        this.pnlOtherPlayers.setLayout(new GridLayout(0, 1));
        this.btnOK.setText("Create");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableDialog.this.btnOKActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.lblQuitRatio.setText("Allowed quit %");
        this.lblEdhPowerLevel.setText("EDH power level:");
        this.lblMinimumRating.setLabelFor(this.spnMinimumRating);
        this.lblMinimumRating.setText("Minimum rating:");
        this.lblMinimumRating.setToolTipText("Players with rating less than this value can't join this table");
        this.chkRated.setText("Rated game");
        this.chkRated.setToolTipText("Indicates if match will be rated");
        this.btnSettingsLoad.setText("Load...");
        this.btnSettingsLoad.setToolTipText("Load settings");
        this.btnSettingsLoad.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewTableDialog.this.btnSettingsLoadMouseClicked(evt);
            }
        });
        this.btnSettingsSave.setText("Save...");
        this.btnSettingsSave.setToolTipText("Save settings");
        this.btnSettingsSave.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewTableDialog.this.btnSettingsSaveMouseClicked(evt);
            }
        });
        this.lblSettings.setText("Settings");
        this.btnCustomOptions.setText("Custom Options...");
        this.btnCustomOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableDialog.this.btnCustomOptionsActionPerformed(evt);
            }
        });
        this.lblRange.setText("Range of Influence:");
        this.cbRange.setToolTipText("<HTML>An option for multiplayer games.\nA player's range of influence is the maximum distance from that player, measured in player seats,<br>\nthat the player can affect. Players within that many seats of the player are within that player's range<br>\nof influence. Objects controlled by players within a player's range of influence are also within that<br>\nplayer's range of influence. Range of influence covers spells, abilities, effects, damage dealing, attacking,<nr>\nmaking choices, and winning the game.");
        this.lblAttack.setText("Attack Option:");
        this.cbAttackOption.setToolTipText("<HTML>An option for multiplayer games that defines<br>\nwhich opponents can be attacked from a player.");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.lblSettings).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSettingsLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSettingsSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnOK, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel, -2, 100, -2)).addComponent(this.jSeparator2).addComponent(this.player1Panel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.pnlOtherPlayers, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblName).addComponent(this.lbDeckType).addComponent(this.lblGameType)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.txtName, -2, 178, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbTimeLimit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbTimeLimit, -2, 102, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbBufferTime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbBufferTime, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNumWins).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnNumWins, -2, 50, -2).addGap(8, 8, 8).addComponent(this.chkRollbackTurnsAllowed).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkSpectatorsAllowed)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbDeckType, 0, 255, Short.MAX_VALUE).addComponent(this.cbGameType, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnCustomOptions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSkillLevel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSkillLevel, -2, 102, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPassword).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPassword, -2, 109, -2)).addGroup(layout.createSequentialGroup().addComponent(this.chkRated).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMinimumRating).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnMinimumRating, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblQuitRatio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnQuitRatio, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEdhPowerLevel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnEdhPowerLevel, -2, 60, -2).addGap(0, 0, Short.MAX_VALUE)))))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblNumPlayers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnNumPlayers, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblRange).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbRange, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAttack).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAttackOption, -2, 150, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator3, -1, 933, Short.MAX_VALUE).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtName).addComponent(this.lblName)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbBufferTime).addComponent(this.cbBufferTime, -2, -1, -2).addComponent(this.lblNumWins).addComponent(this.spnNumWins, -2, -1, -2).addComponent(this.chkRollbackTurnsAllowed).addComponent(this.chkSpectatorsAllowed)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbTimeLimit).addComponent(this.lbTimeLimit))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbDeckType, -2, -1, -2).addComponent(this.lbDeckType).addComponent(this.lblQuitRatio).addComponent(this.lblEdhPowerLevel).addComponent(this.spnEdhPowerLevel, -2, -1, -2).addComponent(this.spnQuitRatio, -2, -1, -2).addComponent(this.lblMinimumRating).addComponent(this.spnMinimumRating, -2, -1, -2).addComponent(this.chkRated)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPassword).addComponent(this.txtPassword).addComponent(this.cbSkillLevel, -2, -1, -2).addComponent(this.lblSkillLevel).addComponent(this.btnCustomOptions)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbGameType, -2, -1, -2).addComponent(this.lblGameType))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbAttackOption, -2, -1, -2).addComponent(this.lblAttack)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbRange, -2, -1, -2).addComponent(this.lblRange)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblNumPlayers).addComponent(this.spnNumPlayers, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(0, 0, 0).addComponent(this.player1Panel, -2, -1, -2).addGap(16, 16, 16).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlOtherPlayers, -1, 131, Short.MAX_VALUE).addGap(9, 9, 9).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel, -2, 30, -2).addComponent(this.btnOK, -2, 30, -2).addComponent(this.btnSettingsLoad, -2, 30, -2).addComponent(this.btnSettingsSave, -2, 30, -2).addComponent(this.lblSettings)).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(201, 201, 201).addComponent(this.jSeparator3, -2, -1, -2).addContainerGap(180, Short.MAX_VALUE))));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.table = null;
        this.playerId = null;
        this.doClose();
    }

    private void btnPreviousConfigurationActionPerformed(ActionEvent evt, int i) {
    }

    private void doClose() {
        if (this.customOptions.isVisible()) {
            this.customOptions.hideDialog();
        }
        this.hideDialog();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        MatchOptions options = this.getMatchOptions();
        if (!this.checkMatchOptions(options)) {
            return;
        }
        this.onSaveSettings(0, options, this.player1Panel.getDeckFile());
        this.table = SessionHandler.createTable(this.roomId, options);
        if (this.table == null) {
            JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Error creating table.", "Error", 0);
            return;
        }
        try {
            for (TablePlayerPanel player : this.players) {
                if (player.getPlayerType() == PlayerType.HUMAN || player.joinTable(this.roomId, this.table.getTableId())) continue;
                SessionHandler.removeTable(this.roomId, this.table.getTableId());
                this.table = null;
                return;
            }
            if (SessionHandler.joinTable(this.roomId, this.table.getTableId(), this.player1Panel.getPlayerName(), PlayerType.HUMAN, 1, DeckImporter.importDeckFromFile(this.player1Panel.getDeckFile(), true), this.txtPassword.getText())) {
                this.doClose();
                return;
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            this.handleError(ex);
        }
        SessionHandler.removeTable(this.roomId, this.table.getTableId());
        this.table = null;
    }

    private void cbGameTypeActionPerformed(ActionEvent evt) {
        this.setGameOptions();
    }

    private void numPlayersChanged(ChangeEvent evt) {
        int numPlayers = (Integer)this.spnNumPlayers.getValue() - 1;
        this.createPlayers(numPlayers);
    }

    private void btnSettingsSaveMouseClicked(MouseEvent evt) {
        this.popupSaveSettings.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private void btnSettingsLoadMouseClicked(MouseEvent evt) {
        this.popupLoadSettings.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private void menuSaveSettings2ActionPerformed(ActionEvent evt) {
        this.onSaveSettings(2);
    }

    private void menuSaveSettings1ActionPerformed(ActionEvent evt) {
        this.onSaveSettings(1);
    }

    private void menuLoadSettingsLastActionPerformed(ActionEvent evt) {
        this.onLoadSettings(0);
    }

    private void menuLoadSettings1ActionPerformed(ActionEvent evt) {
        this.onLoadSettings(1);
    }

    private void menuLoadSettings2ActionPerformed(ActionEvent evt) {
        this.onLoadSettings(2);
    }

    private void menuLoadSettingsDefaultActionPerformed(ActionEvent evt) {
        this.onLoadSettings(-1);
    }

    private void btnCustomOptionsActionPerformed(ActionEvent evt) {
        this.customOptions.showDialog();
    }

    private MatchOptions getMatchOptions() {
        GameTypeView gameType = (GameTypeView)this.cbGameType.getSelectedItem();
        MatchOptions options = new MatchOptions(this.txtName.getText(), gameType.getName(), false);
        options.getPlayerTypes().add(PlayerType.HUMAN);
        for (TablePlayerPanel player : this.players) {
            options.getPlayerTypes().add(player.getPlayerType());
        }
        options.setDeckType((String)this.cbDeckType.getSelectedItem());
        options.setMatchTimeLimit((MatchTimeLimit)((Object)this.cbTimeLimit.getSelectedItem()));
        options.setMatchBufferTime((MatchBufferTime)((Object)this.cbBufferTime.getSelectedItem()));
        options.setAttackOption((MultiplayerAttackOption)((Object)this.cbAttackOption.getSelectedItem()));
        options.setSkillLevel((SkillLevel)((Object)this.cbSkillLevel.getSelectedItem()));
        options.setRange((RangeOfInfluence)((Object)this.cbRange.getSelectedItem()));
        options.setWinsNeeded((Integer)this.spnNumWins.getValue());
        options.setRollbackTurnsAllowed(this.chkRollbackTurnsAllowed.isSelected());
        options.setSpectatorsAllowed(this.chkSpectatorsAllowed.isSelected());
        options.setRated(this.chkRated.isSelected());
        options.setPassword(this.txtPassword.getText());
        options.setQuitRatio((Integer)this.spnQuitRatio.getValue());
        options.setMinimumRating((Integer)this.spnMinimumRating.getValue());
        options.setEdhPowerLevel((Integer)this.spnEdhPowerLevel.getValue());
        String serverAddress = SessionHandler.getSession().getServerHost();
        options.setBannedUsers(IgnoreList.getIgnoredUsers(serverAddress));
        options.setLimited(options.getDeckType().startsWith(LIMITED));
        if (options.getDeckType().startsWith("Variant Magic - Freeform Unlimited Commander")) {
            options.setLimited(true);
        }
        this.customOptions.writeMatchOptionsTo(options);
        return options;
    }

    private boolean checkMatchOptions(MatchOptions options) {
        switch (options.getDeckType()) {
            case "Variant Magic - Commander": 
            case "Variant Magic - Duel Commander": 
            case "Variant Magic - MTGO 1v1 Commander": 
            case "Variant Magic - Centurion Commander": 
            case "Variant Magic - Penny Dreadful Commander": {
                if (options.getGameType().startsWith("Commander")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Commander needs also a Commander game type", "Error", 0);
                return false;
            }
            case "Variant Magic - Freeform Commander": {
                if (options.getGameType().startsWith("Freeform Commander")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Freeform Commander needs also a Freeform Commander game type", "Error", 0);
                return false;
            }
            case "Variant Magic - Freeform Unlimited Commander": {
                if (options.getGameType().startsWith("Freeform Unlimited Commander")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Freeform+ Commander needs also a Freeform Unlimited Commander game type", "Error", 0);
                return false;
            }
            case "Variant Magic - Brawl": 
            case "Variant Magic - Duel Brawl": {
                if (options.getGameType().startsWith("Brawl")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Brawl needs also a Brawl game type", "Error", 0);
                return false;
            }
            case "Variant Magic - Tiny Leaders": {
                if (options.getGameType().startsWith("Tiny Leaders")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Tiny Leaders needs also a Tiny Leaders game type", "Error", 0);
                return false;
            }
            case "Variant Magic - Momir Basic": {
                if (options.getGameType().startsWith("Momir Basic")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Momir Basic needs also a Momir Basic game type", "Error", 0);
                return false;
            }
            case "Variant Magic - Oathbreaker": {
                if (options.getGameType().startsWith("Oathbreaker")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Oathbreaker needs also a Oathbreaker game type", "Error", 0);
                return false;
            }
        }
        switch (options.getGameType()) {
            case "Commander Two Player Duel": 
            case "Commander Free For All": {
                if (options.getDeckType().equals("Variant Magic - Commander") || options.getDeckType().equals("Variant Magic - Duel Commander") || options.getDeckType().equals("Variant Magic - MTGO 1v1 Commander") || options.getDeckType().equals("Variant Magic - Centurion Commander") || options.getDeckType().equals("Variant Magic - Freeform Commander") || options.getDeckType().equals("Variant Magic - Penny Dreadful Commander")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Commander needs also a Commander game type", "Error", 0);
                return false;
            }
            case "Freeform Commander Two Player Duel": 
            case "Freeform Commander Free For All": {
                if (options.getDeckType().equals("Variant Magic - Freeform Commander")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Freeform Commander needs also a Freeform Commander game type", "Error", 0);
                return false;
            }
            case "Freeform Unlimited Commander": {
                if (options.getDeckType().equals("Variant Magic - Freeform Unlimited Commander")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Freeform Unlimited Commander needs also a Freeform Unlimited Commander game type", "Error", 0);
                return false;
            }
            case "Brawl Two Player Duel": 
            case "Brawl Free For All": {
                if (options.getDeckType().equals("Variant Magic - Brawl") || options.getDeckType().equals("Variant Magic - Duel Brawl")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Brawl needs also a Brawl game type", "Error", 0);
                return false;
            }
            case "Tiny Leaders Two Player Duel": {
                if (options.getDeckType().equals("Variant Magic - Tiny Leaders")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Tiny Leaders needs also a Tiny Leaders game type", "Error", 0);
                return false;
            }
            case "Oathbreaker Two Player Duel": 
            case "Oathbreaker Free For All": {
                if (options.getDeckType().equals("Variant Magic - Oathbreaker")) break;
                JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Deck type Oathbreaker needs also a Oathbreaker game type", "Error", 0);
                return false;
            }
        }
        return true;
    }

    private void setGameOptions() {
        GameTypeView gameType = (GameTypeView)this.cbGameType.getSelectedItem();
        int oldValue = (Integer)this.spnNumPlayers.getValue();
        this.spnNumPlayers.setModel(new SpinnerNumberModel(gameType.getMinPlayers(), gameType.getMinPlayers(), gameType.getMaxPlayers(), 1));
        this.spnNumPlayers.setEnabled(gameType.getMinPlayers() != gameType.getMaxPlayers());
        if (oldValue >= gameType.getMinPlayers() && oldValue <= gameType.getMaxPlayers()) {
            this.spnNumPlayers.setValue(oldValue);
        }
        this.cbAttackOption.setEnabled(gameType.isUseAttackOption());
        this.cbRange.setEnabled(gameType.isUseRange());
        JComponent[] multiplayerOptions = new JComponent[]{this.lblNumPlayers, this.spnNumPlayers, this.lblRange, this.cbRange, this.lblAttack, this.cbAttackOption};
        boolean showMultiplayerOptions = Arrays.stream(multiplayerOptions).anyMatch(c -> !(c instanceof JLabel) && c.isEnabled());
        for (JComponent component : multiplayerOptions) {
            component.setVisible(showMultiplayerOptions);
        }
        this.createPlayers((Integer)this.spnNumPlayers.getValue() - 1);
    }

    private void createPlayers(int numPlayers) {
        if (numPlayers > this.players.size()) {
            while (this.players.size() != numPlayers) {
                TablePlayerPanel playerPanel = new TablePlayerPanel();
                this.players.add(playerPanel);
                playerPanel.addPlayerTypeEventListener(event -> this.drawPlayers());
            }
        }
        if (numPlayers < this.players.size()) {
            while (this.players.size() != numPlayers) {
                this.players.remove(this.players.size() - 1);
            }
        }
        String prevGoodPlayerDeck = "";
        for (int i = 0; i < this.players.size(); ++i) {
            TablePlayerPanel playerPanel = this.players.get(i);
            PlayerType playerType = PlayerType.HUMAN;
            if (i < this.prefPlayerTypes.size()) {
                playerType = this.prefPlayerTypes.get(i);
            }
            int playerSkill = 2;
            if (i < this.prefPlayerSkills.size()) {
                playerSkill = this.prefPlayerSkills.get(i);
            }
            String playerDeck = "";
            if (i < this.prefPlayerDecks.size()) {
                playerDeck = this.prefPlayerDecks.get(i);
                if (playerDeck.isEmpty() || !new File(playerDeck).exists()) {
                    playerDeck = prevGoodPlayerDeck;
                } else {
                    prevGoodPlayerDeck = playerDeck;
                }
            }
            playerPanel.init(i + 2, playerType, playerSkill, playerDeck);
        }
        this.drawPlayers();
    }

    private void drawPlayers() {
        this.pnlOtherPlayers.removeAll();
        for (TablePlayerPanel panel : this.players) {
            this.pnlOtherPlayers.add(panel);
        }
        this.pack();
        this.revalidate();
        this.repaint();
    }

    private void handleError(Exception e) {
        logger.fatal((Object)("Can't join table due " + e), (Throwable)e);
        MageFrame.getInstance().showErrorDialog("CLIENT - error on join table", e);
    }

    public void showDialog(UUID roomId) {
        this.roomId = roomId;
        if (!this.lastSessionId.equals(SessionHandler.getSessionId())) {
            this.lastSessionId = SessionHandler.getSessionId();
            this.player1Panel.setPlayerName(SessionHandler.getUserName());
            this.cbGameType.setModel(new DefaultComboBoxModel<Object>(SessionHandler.getGameTypes().toArray()));
            this.cbDeckType.setModel(new DefaultComboBoxModel<String>(SessionHandler.getDeckTypes()));
            this.selectLimitedByDefault();
            this.cbTimeLimit.setModel(new DefaultComboBoxModel<MatchTimeLimit>(MatchTimeLimit.values()));
            this.cbBufferTime.setModel(new DefaultComboBoxModel<MatchBufferTime>(MatchBufferTime.values()));
            this.cbRange.setModel(new DefaultComboBoxModel<RangeOfInfluence>(RangeOfInfluence.values()));
            this.cbAttackOption.setModel(new DefaultComboBoxModel<MultiplayerAttackOption>(MultiplayerAttackOption.values()));
            this.cbSkillLevel.setModel(new DefaultComboBoxModel<SkillLevel>(SkillLevel.values()));
            this.setModal(true);
            this.setGameOptions();
            this.setLocation(150, 100);
        }
        this.onLoadSettings(0);
        this.setVisible(true);
    }

    public TableView getTable() {
        return this.table;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    private void selectLimitedByDefault() {
        for (int i = 0; i < this.cbDeckType.getItemCount(); ++i) {
            String name = (String)this.cbDeckType.getItemAt(i);
            if (!name.equals(LIMITED)) continue;
            this.cbDeckType.setSelectedIndex(i);
            break;
        }
    }

    private void onLoadSettings(int version) {
        String versionStr = "";
        switch (version) {
            case -1: {
                versionStr = "-1";
                break;
            }
            case 1: {
                versionStr = "1";
                break;
            }
            case 2: {
                versionStr = "2";
                break;
            }
            default: {
                versionStr = "";
            }
        }
        this.txtName.setText(PreferencesDialog.getCachedValue("newTableName" + versionStr, "Game"));
        this.txtPassword.setText(PreferencesDialog.getCachedValue("newTablePassword" + versionStr, ""));
        String playerData = PreferencesDialog.getCachedValue("newTablePlayerTypes" + versionStr, "Human");
        this.prefPlayerTypes.clear();
        for (String playerTypeStr : playerData.split(PLAYER_DATA_DELIMETER_OLD)) {
            this.prefPlayerTypes.add(PlayerType.getByDescription(playerTypeStr));
        }
        playerData = PreferencesDialog.getCachedValue("newTablePlayerSkills" + versionStr, String.valueOf(2));
        this.prefPlayerSkills.clear();
        for (String playerSkillStr : playerData.split(PLAYER_DATA_DELIMETER_NEW)) {
            this.prefPlayerSkills.add(Integer.parseInt(playerSkillStr));
        }
        playerData = PreferencesDialog.getCachedValue("newTablePlayerDecks" + versionStr, "Human");
        this.prefPlayerDecks.clear();
        this.prefPlayerDecks.addAll(Arrays.asList(playerData.split(PLAYER_DATA_DELIMETER_NEW)));
        this.spnNumPlayers.setValue(Integer.parseInt(PreferencesDialog.getCachedValue("newTableNumberPlayers" + versionStr, "2")));
        String gameTypeName = PreferencesDialog.getCachedValue("newTableGameType" + versionStr, "Two Player Duel");
        for (GameTypeView gtv : SessionHandler.getGameTypes()) {
            if (!gtv.getName().equals(gameTypeName)) continue;
            this.cbGameType.setSelectedItem(gtv);
            break;
        }
        int timeLimit = Integer.parseInt(PreferencesDialog.getCachedValue("newTableTimeLimit" + versionStr, "1500"));
        for (MatchTimeLimit mtl : MatchTimeLimit.values()) {
            if (mtl.getPrioritySecs() != timeLimit) continue;
            this.cbTimeLimit.setSelectedItem((Object)mtl);
            break;
        }
        int bufferTime = Integer.parseInt(PreferencesDialog.getCachedValue("newTableBufferTime" + versionStr, "0"));
        for (MatchBufferTime mtl : MatchBufferTime.values()) {
            if (mtl.getBufferSecs() != bufferTime) continue;
            this.cbBufferTime.setSelectedItem((Object)mtl);
            break;
        }
        this.cbDeckType.setSelectedItem(PreferencesDialog.getCachedValue("newTableDeckType" + versionStr, LIMITED));
        String deckFile = PreferencesDialog.getCachedValue("newTableDeckFile" + versionStr, null);
        if (deckFile != null) {
            this.player1Panel.setDeckFile(deckFile);
        }
        this.spnNumWins.setValue(Integer.parseInt(PreferencesDialog.getCachedValue("newTableNumberOfWins" + versionStr, "2")));
        this.chkRollbackTurnsAllowed.setSelected(PreferencesDialog.getCachedValue("newTableRollbackTurnsAllowed" + versionStr, "Yes").equals("Yes"));
        this.chkSpectatorsAllowed.setSelected(PreferencesDialog.getCachedValue("newTableSpectatorsAllowed" + versionStr, "Yes").equals("Yes"));
        this.chkRated.setSelected(PreferencesDialog.getCachedValue("newTableRated" + versionStr, "No").equals("Yes"));
        int range = Integer.parseInt(PreferencesDialog.getCachedValue("newTableRange" + versionStr, "0"));
        for (RangeOfInfluence roi : RangeOfInfluence.values()) {
            if (roi.getRange() != range) continue;
            this.cbRange.setSelectedItem((Object)roi);
            break;
        }
        String attackOption = PreferencesDialog.getCachedValue("newTableAttackOption" + versionStr, "Attack Multiple Players");
        for (MultiplayerAttackOption mao : MultiplayerAttackOption.values()) {
            if (!mao.toString().equals(attackOption)) continue;
            this.cbAttackOption.setSelectedItem((Object)mao);
            break;
        }
        String skillLevelDefault = PreferencesDialog.getCachedValue("newTableSkillLevel" + versionStr, "Casual");
        for (SkillLevel skillLevel : SkillLevel.values()) {
            if (!skillLevel.toString().equals(skillLevelDefault)) continue;
            this.cbSkillLevel.setSelectedItem((Object)skillLevel);
            break;
        }
        this.spnQuitRatio.setValue(Integer.parseInt(PreferencesDialog.getCachedValue("newTableQuitRatio" + versionStr, "100")));
        this.spnMinimumRating.setValue(Integer.parseInt(PreferencesDialog.getCachedValue("newTableMinimumRating" + versionStr, "0")));
        this.spnEdhPowerLevel.setValue(Integer.parseInt(PreferencesDialog.getCachedValue("newTableEdhPowerLevel" + versionStr, "0")));
        this.customOptions.onLoadSettings(version);
    }

    private void onSaveSettings(int version) {
        MatchOptions options = this.getMatchOptions();
        this.onSaveSettings(version, options, this.player1Panel.getDeckFile());
    }

    private void onSaveSettings(int version, MatchOptions options, String deckFile) {
        String versionStr = "";
        switch (version) {
            case 1: {
                versionStr = "1";
                break;
            }
            case 2: {
                versionStr = "2";
                break;
            }
            default: {
                versionStr = "";
            }
        }
        PreferencesDialog.saveValue("newTableName" + versionStr, options.getName());
        PreferencesDialog.saveValue("newTablePassword" + versionStr, options.getPassword());
        PreferencesDialog.saveValue("newTableDeckType" + versionStr, options.getDeckType());
        PreferencesDialog.saveValue("newTableTimeLimit" + versionStr, Integer.toString(options.getMatchTimeLimit().getPrioritySecs()));
        PreferencesDialog.saveValue("newTableBufferTime" + versionStr, Integer.toString(options.getMatchBufferTime().getBufferSecs()));
        PreferencesDialog.saveValue("newTableGameType" + versionStr, options.getGameType());
        PreferencesDialog.saveValue("newTableNumberOfWins" + versionStr, Integer.toString(options.getWinsNeeded()));
        PreferencesDialog.saveValue("newTableRollbackTurnsAllowed" + versionStr, options.isRollbackTurnsAllowed() ? "Yes" : "No");
        PreferencesDialog.saveValue("newTableRated" + versionStr, options.isRated() ? "Yes" : "No");
        PreferencesDialog.saveValue("newTableDeckFile" + versionStr, deckFile);
        PreferencesDialog.saveValue("newTableNumberPlayers" + versionStr, this.spnNumPlayers.getValue().toString());
        PreferencesDialog.saveValue("newTableSkillLevel" + versionStr, options.getSkillLevel().toString());
        PreferencesDialog.saveValue("newTableSpectatorsAllowed" + versionStr, options.isSpectatorsAllowed() ? "Yes" : "No");
        PreferencesDialog.saveValue("newTableQuitRatio" + versionStr, Integer.toString(options.getQuitRatio()));
        PreferencesDialog.saveValue("newTableMinimumRating" + versionStr, Integer.toString(options.getMinimumRating()));
        PreferencesDialog.saveValue("newTableEdhPowerLevel" + versionStr, Integer.toString(options.getEdhPowerLevel()));
        String playerData = this.players.stream().map(panel -> panel.getPlayerType().toString()).collect(Collectors.joining(PLAYER_DATA_DELIMETER_OLD));
        PreferencesDialog.saveValue("newTablePlayerTypes" + versionStr, playerData);
        playerData = this.players.stream().map(panel -> String.valueOf(panel.getPlayerSkill())).collect(Collectors.joining(PLAYER_DATA_DELIMETER_NEW));
        PreferencesDialog.saveValue("newTablePlayerSkills" + versionStr, playerData);
        playerData = this.players.stream().map(panel -> String.valueOf(panel.getPlayerDeck())).collect(Collectors.joining(PLAYER_DATA_DELIMETER_NEW));
        PreferencesDialog.saveValue("newTablePlayerDecks" + versionStr, playerData);
        this.customOptions.onSaveSettings(version, options);
    }
}

