/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mage.choices.Choice;
import mage.client.MageFrame;
import mage.client.dialog.CheckBoxList;
import mage.client.dialog.MageDialog;
import mage.client.util.gui.MageDialogState;

public class PickCheckBoxDialog
extends MageDialog {
    Choice choice;
    List<KeyValueItem> allItems = new ArrayList<KeyValueItem>();
    DefaultListModel<KeyValueItem> dataModel = new DefaultListModel();
    CheckBoxList.CheckBoxListModel m_dataModel;
    CheckBoxList tList;
    int[] startingCheckboxes;
    PickCheckBoxCallback callback = null;
    private static final String HTML_TEMPLATE = "<html><div style='text-align: center;'>%s</div></html>";
    private JButton btCancel;
    private JButton btClear;
    private JButton btOK;
    private JTextField editSearch;
    private JLabel labelMessage;
    private JLabel labelSearch;
    private JLabel labelSubMessage;
    private JList listChoices;
    private JPanel panelCommands;
    private JPanel panelHeader;
    private JPanel panelSearch;
    private JScrollPane scrollList;

    public void showDialog(Choice choice, PickCheckBoxCallback callback) {
        this.showDialog(choice, null, null, null, callback);
    }

    public void showDialog(Choice choice, String startSelectionValue, PickCheckBoxCallback callback) {
        this.showDialog(choice, null, null, startSelectionValue, callback);
    }

    public void showDialog(Choice choice, UUID objectId, MageDialogState mageDialogState, PickCheckBoxCallback callback) {
        this.showDialog(choice, objectId, mageDialogState, null, callback);
    }

    public void showDialog(final Choice choice, UUID objectId, MageDialogState mageDialogState, String startSelectionValue, PickCheckBoxCallback callback) {
        KeyValueItem tempKeyValue;
        int indexInTList;
        this.choice = choice;
        this.callback = callback;
        this.setLabelText(this.labelMessage, choice.getMessage());
        this.setLabelText(this.labelSubMessage, choice.getSubMessage());
        this.btCancel.setEnabled(!choice.isRequired());
        this.allItems.clear();
        if (choice.isKeyChoice()) {
            for (Map.Entry entry : choice.getKeyChoices().entrySet()) {
                if (this.tList != null) {
                    indexInTList = this.m_dataModel.indexOf(entry.getKey());
                    tempKeyValue = new KeyValueItem((String)entry.getKey(), (String)entry.getValue(), (CheckBoxList.CheckBoxListItem)this.tList.getModel().getElementAt(indexInTList));
                } else {
                    tempKeyValue = new KeyValueItem((String)entry.getKey(), (String)entry.getValue());
                }
                this.allItems.add(tempKeyValue);
            }
        } else {
            for (String string : choice.getChoices()) {
                if (this.tList != null) {
                    indexInTList = this.m_dataModel.indexOf(string);
                    tempKeyValue = new KeyValueItem(string, string, (CheckBoxList.CheckBoxListItem)this.tList.getModel().getElementAt(indexInTList));
                } else {
                    tempKeyValue = new KeyValueItem(string, string);
                }
                this.allItems.add(tempKeyValue);
            }
        }
        if (choice.isSortEnabled()) {
            this.allItems.sort((o1, o2) -> {
                Integer n1 = choice.getSortData().get(o1.getKey());
                Integer n2 = choice.getSortData().get(o2.getKey());
                return n1.compareTo(n2);
            });
        }
        if (choice.isSearchEnabled()) {
            this.panelSearch.setVisible(true);
            this.editSearch.setText(choice.getSearchText());
        } else {
            this.panelSearch.setVisible(false);
            this.editSearch.setText("");
        }
        this.editSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                choice.setSearchText(PickCheckBoxDialog.this.editSearch.getText());
                PickCheckBoxDialog.this.loadData();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                choice.setSearchText(PickCheckBoxDialog.this.editSearch.getText());
                PickCheckBoxDialog.this.loadData();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                choice.setSearchText(PickCheckBoxDialog.this.editSearch.getText());
                PickCheckBoxDialog.this.loadData();
            }
        });
        this.editSearch.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    PickCheckBoxDialog.this.doPrevSelect();
                } else if (e.getKeyCode() == 40) {
                    PickCheckBoxDialog.this.doNextSelect();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.listChoices.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    PickCheckBoxDialog.this.doChoose();
                }
            }
        });
        if (!choice.isRequired()) {
            String cancelName = "cancel";
            InputMap inputMap = this.getRootPane().getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
            ActionMap actionMap = this.getRootPane().getActionMap();
            actionMap.put(cancelName, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PickCheckBoxDialog.this.doCancel();
                }
            });
        }
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add((Component)this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        if (mageDialogState != null) {
            mageDialogState.setStateToDialog(this);
        } else {
            this.makeWindowCentered();
        }
        this.loadData();
        if (startSelectionValue != null) {
            int n;
            JList currentlistChoices = this.get_a_Jlist_from_ScrollListView();
            int n2 = -1;
            for (int i = 0; i < this.listChoices.getModel().getSize(); ++i) {
                String elementOfList = currentlistChoices.getModel().getElementAt(i).toString();
                if (!elementOfList.equals(startSelectionValue)) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                currentlistChoices.setSelectedIndex(n);
                currentlistChoices.ensureIndexIsVisible(n);
            }
        }
        this.setVisible(true);
    }

    private void setFocus(CheckBoxList obj) {
        if (!(obj instanceof Component)) {
            throw new IllegalArgumentException("Must be a java.awt.Component!");
        }
        this.scrollList.setViewportView(obj);
    }

    private JList get_a_Jlist_from_ScrollListView() {
        return (JList)this.scrollList.getViewport().getView();
    }

    private void restoreData(Object dataFrom) {
        this.allItems.forEach(item -> ((CheckBoxList.CheckBoxListModel)dataFrom).addElement(item.getObjectValue()));
    }

    public void setWindowSize(int width, int heigth) {
        this.setSize(new Dimension(width, heigth));
    }

    private void loadData() {
        String filter = this.choice.getSearchText();
        if (filter == null) {
            filter = "";
        }
        filter = filter.toLowerCase(Locale.ENGLISH);
        this.dataModel.clear();
        this.m_dataModel.clear();
        for (KeyValueItem item : this.allItems) {
            if (this.choice.isSearchEnabled() && !item.Value.toLowerCase(Locale.ENGLISH).contains(filter)) continue;
            this.dataModel.addElement(item);
            this.m_dataModel.addElement(item.getObjectValue());
        }
    }

    private void setLabelText(JLabel label, String text) {
        if (text != null && !text.equals("")) {
            label.setText(String.format(HTML_TEMPLATE, text));
            label.setVisible(true);
        } else {
            label.setText("");
            label.setVisible(false);
        }
    }

    private void doNextSelect() {
        int maxSel;
        int newSel = this.listChoices.getSelectedIndex() + 1;
        if (newSel <= (maxSel = this.listChoices.getModel().getSize() - 1)) {
            this.listChoices.setSelectedIndex(newSel);
            this.listChoices.ensureIndexIsVisible(newSel);
        }
    }

    private void doPrevSelect() {
        int newSel = this.listChoices.getSelectedIndex() - 1;
        if (newSel >= 0) {
            this.listChoices.setSelectedIndex(newSel);
            this.listChoices.ensureIndexIsVisible(newSel);
        }
    }

    private void doChoose() {
        if (this.tList != null || this.setChoice()) {
            this.m_dataModel.clear();
            this.restoreData(this.m_dataModel);
            this.doClose();
        }
    }

    private void doCancel() {
        Set checks = Arrays.stream(this.startingCheckboxes).boxed().collect(Collectors.toSet());
        for (int i = 0; i < this.tList.getModel().getSize(); ++i) {
            this.tList.setChecked(i, checks.contains(i));
        }
        this.listChoices.clearSelection();
        this.choice.clearChoice();
        this.doClose();
    }

    private void doClose() {
        this.hideDialog();
        if (this.callback != null) {
            this.callback.onChoiceDone();
        }
    }

    public PickCheckBoxDialog(CheckBoxList list) {
        this.initComponents();
        this.tList = list;
        this.startingCheckboxes = list.getCheckedIndices();
        this.listChoices.setModel(this.dataModel);
        this.setModal(true);
        if (this.tList != null) {
            this.listChoices.setVisible(false);
            this.m_dataModel = (CheckBoxList.CheckBoxListModel)this.tList.getModel();
            this.tList.setSelectionForeground(Color.BLUE);
            if (this.tList instanceof JList) {
                this.setFocus(this.tList);
            }
        }
    }

    public PickCheckBoxDialog() {
        this((CheckBoxList)null);
    }

    public boolean setChoice() {
        KeyValueItem item = (KeyValueItem)this.listChoices.getSelectedValue();
        if (item == null && this.listChoices.getModel().getSize() == 1) {
            this.listChoices.setSelectedIndex(0);
            item = (KeyValueItem)this.listChoices.getSelectedValue();
        }
        if (item != null) {
            if (this.choice.isKeyChoice()) {
                this.choice.setChoiceByKey(item.getKey(), false);
            } else {
                this.choice.setChoice(item.getKey(), false);
            }
            return true;
        }
        this.choice.clearChoice();
        return false;
    }

    private void initComponents() {
        this.panelHeader = new JPanel();
        this.labelMessage = new JLabel();
        this.labelSubMessage = new JLabel();
        this.panelSearch = new JPanel();
        this.labelSearch = new JLabel();
        this.editSearch = new JTextField();
        this.scrollList = new JScrollPane();
        this.listChoices = new JList();
        this.panelCommands = new JPanel();
        this.btOK = new JButton();
        this.btCancel = new JButton();
        this.btClear = new JButton();
        this.labelMessage.setHorizontalAlignment(0);
        this.labelMessage.setText("<html><div style='text-align: center;'>example long message example long message example long message example long message example long message</div></html>");
        this.labelSubMessage.setFont(this.labelSubMessage.getFont().deriveFont(this.labelSubMessage.getFont().getStyle() | 2 | 1));
        this.labelSubMessage.setHorizontalAlignment(0);
        this.labelSubMessage.setText("<html><div style='text-align: center;'>example long message example long</div></html>");
        GroupLayout panelHeaderLayout = new GroupLayout(this.panelHeader);
        this.panelHeader.setLayout(panelHeaderLayout);
        panelHeaderLayout.setHorizontalGroup(panelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelHeaderLayout.createSequentialGroup().addGroup(panelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelMessage, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.labelSubMessage, GroupLayout.Alignment.TRAILING)).addGap(0, 0, 0)));
        panelHeaderLayout.setVerticalGroup(panelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelHeaderLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.labelMessage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelSubMessage, -1, 30, Short.MAX_VALUE)));
        this.labelSearch.setText("Search:");
        this.editSearch.setText("sample search text");
        GroupLayout panelSearchLayout = new GroupLayout(this.panelSearch);
        this.panelSearch.setLayout(panelSearchLayout);
        panelSearchLayout.setHorizontalGroup(panelSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSearchLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.labelSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editSearch).addGap(0, 0, 0)));
        panelSearchLayout.setVerticalGroup(panelSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSearchLayout.createSequentialGroup().addGap(3, 3, 3).addGroup(panelSearchLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSearch).addComponent(this.editSearch, -2, -1, -2)).addGap(3, 3, 3)));
        this.listChoices.setModel(new AbstractListModel(){
            String[] strings = new String[]{"item1", "item2", "item3"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.scrollList.setViewportView(this.listChoices);
        this.btOK.setText("Choose");
        this.btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickCheckBoxDialog.this.btOKActionPerformed(evt);
            }
        });
        this.btCancel.setText("Cancel");
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickCheckBoxDialog.this.btCancelActionPerformed(evt);
            }
        });
        this.btClear.setText("Clear");
        this.btClear.setMinimumSize(new Dimension(30, 25));
        this.btClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickCheckBoxDialog.this.btClearActionPerformed(evt);
            }
        });
        GroupLayout panelCommandsLayout = new GroupLayout(this.panelCommands);
        this.panelCommands.setLayout(panelCommandsLayout);
        panelCommandsLayout.setHorizontalGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCommandsLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btClear, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btCancel, -2, 83, -2).addContainerGap(-1, Short.MAX_VALUE)));
        panelCommandsLayout.setVerticalGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCommandsLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btCancel).addComponent(this.btOK).addComponent(this.btClear, -2, -1, -2)).addContainerGap()));
        this.getRootPane().setDefaultButton(this.btOK);
        this.getRootPane().setDefaultButton(this.btOK);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollList, GroupLayout.Alignment.TRAILING).addComponent(this.panelCommands, -1, -1, Short.MAX_VALUE).addComponent(this.panelHeader, -1, -1, Short.MAX_VALUE).addComponent(this.panelSearch, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.panelHeader, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelSearch, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollList, -1, 240, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelCommands, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void btOKActionPerformed(ActionEvent evt) {
        this.doChoose();
    }

    private void btCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void closeDialog(WindowEvent evt) {
        this.doCancel();
    }

    private void btClearActionPerformed(ActionEvent evt) {
        this.tList.uncheckAll();
        this.scrollList.repaint();
    }

    class KeyValueItem {
        private final String Key;
        private final String Value;
        private final CheckBoxList.CheckBoxListItem objectValue;

        public KeyValueItem(String value) {
            this(value, null, null);
        }

        public KeyValueItem(String value, String label) {
            this(value, label, null);
        }

        public KeyValueItem(String value, String label, CheckBoxList.CheckBoxListItem object) {
            this.Key = value;
            this.Value = label;
            this.objectValue = object;
        }

        public String getKey() {
            return this.Key;
        }

        public String getValue() {
            return this.Value;
        }

        public Object getObjectValue() {
            return this.objectValue;
        }

        public String toString() {
            return this.Value;
        }
    }

    public static interface PickCheckBoxCallback {
        public void onChoiceDone();
    }
}

