/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.dialog.MageDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.preference.MagePreferences;
import mage.remote.Connection;
import org.apache.log4j.Logger;

public class ResetPasswordDialog
extends MageDialog {
    private static final Logger logger = Logger.getLogger(ResetPasswordDialog.class);
    private Connection connection;
    private GetAuthTokenTask getAuthTokenTask;
    private ResetPasswordTask resetPasswordTask;
    private JButton btnCancel;
    private JButton btnGetAuthToken;
    private JButton btnSubmitNewPassword;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblAuthToken;
    private JLabel lblEmail;
    private JLabel lblPassword;
    private JLabel lblPasswordConfirmation;
    private JLabel lblPasswordConfirmationReasoning;
    private JLabel lblPort;
    private JLabel lblServer;
    private JLabel lblStatus;
    private JTextField txtAuthToken;
    private JTextField txtEmail;
    private JPasswordField txtPassword;
    private JPasswordField txtPasswordConfirmation;
    private JTextField txtPort;
    private JTextField txtServer;

    public ResetPasswordDialog() {
        this.initComponents();
    }

    public void showDialog(String server, String port) {
        this.txtServer.setText(server);
        this.txtPort.setText(port);
        this.txtEmail.setText(MagePreferences.getEmail(server));
        this.lblStatus.setText("");
        this.setModal(true);
        this.setLocation(50, 50);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.lblAuthToken = new JLabel();
        this.lblPassword = new JLabel();
        this.lblPasswordConfirmation = new JLabel();
        this.txtAuthToken = new JTextField();
        this.btnSubmitNewPassword = new JButton();
        this.lblPasswordConfirmationReasoning = new JLabel();
        this.txtPassword = new JPasswordField();
        this.txtPasswordConfirmation = new JPasswordField();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.lblEmail = new JLabel();
        this.txtEmail = new JTextField();
        this.btnGetAuthToken = new JButton();
        this.lblStatus = new JLabel();
        this.btnCancel = new JButton();
        this.lblServer = new JLabel();
        this.txtServer = new JTextField();
        this.txtPort = new JTextField();
        this.lblPort = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Reset password");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel6.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel6.setText("Step 2:");
        this.lblAuthToken.setLabelFor(this.txtAuthToken);
        this.lblAuthToken.setText("Auth token:");
        this.lblPassword.setLabelFor(this.txtPassword);
        this.lblPassword.setText("New password:");
        this.lblPasswordConfirmation.setLabelFor(this.txtPasswordConfirmation);
        this.lblPasswordConfirmation.setText("New password:");
        this.btnSubmitNewPassword.setText("Submit a new password");
        this.btnSubmitNewPassword.addActionListener(evt -> this.btnSubmitNewPasswordActionPerformed(evt));
        this.lblPasswordConfirmationReasoning.setFont(new Font("Lucida Grande", 0, 10));
        this.lblPasswordConfirmationReasoning.setLabelFor(this.txtPasswordConfirmation);
        this.lblPasswordConfirmationReasoning.setText("(confirmation)");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel6).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lblAuthToken, -2, 74, -2).addComponent(this.lblPassword, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblPasswordConfirmation, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtAuthToken).addComponent(this.txtPassword).addComponent(this.txtPasswordConfirmation))).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 204, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPasswordConfirmationReasoning, GroupLayout.Alignment.TRAILING).addComponent(this.btnSubmitNewPassword, GroupLayout.Alignment.TRAILING)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel6).addGap(24, 24, 24).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAuthToken).addComponent(this.txtAuthToken, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPassword).addComponent(this.txtPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPasswordConfirmation).addComponent(this.txtPasswordConfirmation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPasswordConfirmationReasoning).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSubmitNewPassword).addContainerGap(9, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel5.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel5.setText("Step 1:");
        this.lblEmail.setLabelFor(this.txtEmail);
        this.lblEmail.setText("Email:");
        this.btnGetAuthToken.setText("Email an auth token");
        this.btnGetAuthToken.addActionListener(evt -> this.btnGetAuthTokenActionPerformed(evt));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblEmail).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtEmail)).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnGetAuthToken))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addGap(24, 24, 24).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblEmail).addComponent(this.txtEmail, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnGetAuthToken).addContainerGap()));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(evt -> this.btnCancelActionPerformed(evt));
        this.lblServer.setLabelFor(this.txtServer);
        this.lblServer.setText("Server:");
        this.lblPort.setLabelFor(this.txtPort);
        this.lblPort.setText("Port:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnCancel)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.lblStatus, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblServer).addComponent(this.lblPort)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtServer).addComponent(this.txtPort)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblServer).addComponent(this.txtServer, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPort, -2, -1, -2).addComponent(this.lblPort)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblStatus, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnGetAuthTokenActionPerformed(ActionEvent evt) {
        if (this.txtEmail.getText().isEmpty()) {
            MageFrame.getInstance().showError("Please enter an email address.");
            return;
        }
        this.connection = new Connection();
        this.connection.setHost(this.txtServer.getText().trim());
        this.connection.setPort(Integer.parseInt(this.txtPort.getText().trim()));
        PreferencesDialog.setProxyInformation(this.connection);
        this.connection.setEmail(this.txtEmail.getText().trim());
        this.getAuthTokenTask = new GetAuthTokenTask();
        this.getAuthTokenTask.execute();
    }

    private void btnSubmitNewPasswordActionPerformed(ActionEvent evt) {
        if (this.txtEmail.getText().isEmpty()) {
            MageFrame.getInstance().showError("Please enter an email address.");
            return;
        }
        if (this.txtAuthToken.getText().isEmpty()) {
            MageFrame.getInstance().showError("Please enter an auth token.");
            return;
        }
        if (String.valueOf(this.txtPassword.getPassword()).trim().isEmpty()) {
            MageFrame.getInstance().showError("Please enter a new password.");
            return;
        }
        if (!Arrays.equals(this.txtPassword.getPassword(), this.txtPasswordConfirmation.getPassword())) {
            MageFrame.getInstance().showError("Passwords don't match.");
            return;
        }
        this.connection = new Connection();
        this.connection.setHost(this.txtServer.getText().trim());
        this.connection.setPort(Integer.parseInt(this.txtPort.getText().trim()));
        PreferencesDialog.setProxyInformation(this.connection);
        this.connection.setEmail(this.txtEmail.getText().trim());
        this.connection.setAuthToken(this.txtAuthToken.getText().trim());
        this.connection.setPassword(String.valueOf(this.txtPassword.getPassword()).trim());
        this.resetPasswordTask = new ResetPasswordTask();
        this.resetPasswordTask.execute();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.hideDialog();
    }

    void disableButtons() {
        this.btnGetAuthToken.setEnabled(false);
        this.btnSubmitNewPassword.setEnabled(false);
    }

    void enableButtons() {
        this.btnGetAuthToken.setEnabled(true);
        this.btnSubmitNewPassword.setEnabled(true);
    }

    private class ResetPasswordTask
    extends SwingWorker<Boolean, Void> {
        private boolean result = false;
        private static final int CONNECTION_TIMEOUT_MS = 2100;

        private ResetPasswordTask() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            ResetPasswordDialog.this.lblStatus.setText("Connecting...");
            ResetPasswordDialog.this.disableButtons();
            this.result = SessionHandler.resetPassword(ResetPasswordDialog.this.connection);
            return this.result;
        }

        @Override
        protected void done() {
            try {
                this.get(2100L, TimeUnit.MILLISECONDS);
                if (this.result) {
                    MagePreferences.setPassword(ResetPasswordDialog.this.connection.getHost(), ResetPasswordDialog.this.connection.getPassword());
                    String message = "Password is reset successfully.";
                    ResetPasswordDialog.this.lblStatus.setText(message);
                    MageFrame.getInstance().showMessage(message);
                    ResetPasswordDialog.this.hideDialog();
                } else {
                    ResetPasswordDialog.this.lblStatus.setText("There was an issue while resetting password.");
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                logger.fatal((Object)"Reset Password Task error", (Throwable)ex);
            }
            catch (CancellationException ex) {
                logger.info((Object)"Canceled");
                ResetPasswordDialog.this.lblStatus.setText("Canceled");
            }
            catch (TimeoutException ex) {
                logger.fatal((Object)"Timeout: ", (Throwable)ex);
            }
            finally {
                MageFrame.stopConnecting();
                ResetPasswordDialog.this.enableButtons();
            }
        }
    }

    private class GetAuthTokenTask
    extends SwingWorker<Boolean, Void> {
        private boolean result = false;
        private static final int CONNECTION_TIMEOUT_MS = 2100;

        private GetAuthTokenTask() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            ResetPasswordDialog.this.lblStatus.setText("Connecting...");
            ResetPasswordDialog.this.disableButtons();
            this.result = SessionHandler.emailAuthToken(ResetPasswordDialog.this.connection);
            return this.result;
        }

        @Override
        protected void done() {
            try {
                this.get(2100L, TimeUnit.MILLISECONDS);
                if (this.result) {
                    MagePreferences.setEmail(ResetPasswordDialog.this.connection.getHost(), ResetPasswordDialog.this.connection.getEmail());
                    String message = "Auth token is emailed. Please check your inbox.";
                    ResetPasswordDialog.this.lblStatus.setText(message);
                    MageFrame.getInstance().showMessage(message);
                } else {
                    ResetPasswordDialog.this.lblStatus.setText("There was an issue while requesting an auth token.");
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                logger.fatal((Object)"Get Auth Token Task error", (Throwable)ex);
            }
            catch (CancellationException ex) {
                logger.info((Object)"Canceled");
                ResetPasswordDialog.this.lblStatus.setText("Canceled");
            }
            catch (TimeoutException ex) {
                logger.fatal((Object)"Timeout: ", (Throwable)ex);
            }
            finally {
                MageFrame.stopConnecting();
                ResetPasswordDialog.this.enableButtons();
            }
        }
    }
}

