/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mage.cards.MageCard;
import mage.client.MageFrame;
import mage.client.cards.BigCard;
import mage.client.cards.CardArea;
import mage.client.dialog.MageDialog;
import mage.client.util.Event;
import mage.client.util.Listener;
import mage.client.util.SettingsManager;
import mage.client.util.gui.GuiDisplayUtil;
import mage.game.events.PlayerQueryEvent;
import mage.util.RandomUtil;
import mage.view.CardsView;

public class ShowCardsDialog
extends MageDialog {
    private boolean positioned = false;
    private CardArea cardArea;

    public ShowCardsDialog() {
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.setModal(false);
    }

    public void cleanUp() {
        this.cardArea.cleanUp();
        for (Component comp : this.cardArea.getComponents()) {
            if (!(comp instanceof MageCard)) continue;
            ((MageCard)comp).cleanUp();
            this.cardArea.remove(comp);
        }
    }

    @Override
    public void changeGUISize() {
        this.setGUISize();
        this.cardArea.changeGUISize();
    }

    private void setGUISize() {
    }

    @Override
    public void show() {
        super.show();
        if (this.positioned) {
            this.showAndPositionWindow();
        }
    }

    private void showAndPositionWindow() {
        SwingUtilities.invokeLater(() -> {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width > 0 && height > 0) {
                Point centered = SettingsManager.instance.getComponentPosition(width, height);
                if (!this.positioned) {
                    int xPos = centered.x / 2 + RandomUtil.nextInt(50);
                    int yPos = centered.y / 2 + RandomUtil.nextInt(50);
                    this.setLocation(xPos, yPos);
                    this.show();
                    this.positioned = true;
                }
                GuiDisplayUtil.keepComponentInsideFrame(centered.x, centered.y, this);
            }
        });
    }

    public void loadCards(String name, CardsView showCards, BigCard bigCard, UUID gameId, boolean modal, Map<String, Serializable> options, JPopupMenu popupMenu, Listener<Event> eventListener) {
        this.title = name;
        this.setTitelBarToolTip(name);
        this.cardArea.clearCardEventListeners();
        this.cardArea.loadCards(showCards, bigCard, gameId);
        if (options != null) {
            if (options.containsKey("chosenTargets")) {
                Set chosenCards = (Set)((Object)options.get("chosenTargets"));
                this.cardArea.selectCards(chosenCards);
            }
            if (options.containsKey("possibleTargets")) {
                Set choosableCards = (Set)((Object)options.get("possibleTargets"));
                this.cardArea.markCards(choosableCards);
            }
            if (options.containsKey("queryType") && options.get("queryType") == PlayerQueryEvent.QueryType.PICK_ABILITY) {
                this.cardArea.setPopupMenu(popupMenu);
            }
        }
        if (popupMenu != null) {
            this.cardArea.setPopupMenu(popupMenu);
        }
        if (eventListener != null) {
            this.cardArea.addCardEventListener(eventListener);
        }
        this.pack();
        this.revalidate();
        this.repaint();
        this.setModal(modal);
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add((Component)this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
    }

    private void initComponents() {
        this.cardArea = new CardArea();
        this.setClosable(true);
        this.setResizable(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.cardArea, "Center");
        this.setGUISize();
        this.pack();
    }
}

