/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import mage.view.SeatView;
import mage.view.TableView;

class TableWaitModel
extends AbstractTableModel {
    private final String[] columnNames = new String[]{"Seat", "Loc", "Player Name", "Rating", "Player Type", "History"};
    private SeatView[] seats = new SeatView[0];
    private boolean limited;

    TableWaitModel() {
    }

    public void loadData(TableView table) {
        this.seats = table.getSeats().toArray(new SeatView[0]);
        if (this.limited != table.isLimited()) {
            this.limited = table.isLimited();
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.seats.length;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        if (this.seats[arg0].getPlayerId() == null) {
            if (arg1 == 0) {
                return Integer.toString(arg0 + 1);
            }
        } else {
            switch (arg1) {
                case 0: {
                    return Integer.toString(arg0 + 1);
                }
                case 1: {
                    return this.seats[arg0].getFlagName();
                }
                case 2: {
                    return this.seats[arg0].getPlayerName();
                }
                case 3: {
                    return this.limited ? this.seats[arg0].getLimitedRating() : this.seats[arg0].getConstructedRating();
                }
                case 4: {
                    return this.seats[arg0].getPlayerType();
                }
                case 5: {
                    return this.seats[arg0].getHistory();
                }
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int columnIndex) {
        String colName = "";
        if (columnIndex <= this.getColumnCount()) {
            colName = this.columnNames[columnIndex];
        }
        return colName;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return Icon.class;
            }
            case 3: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

