/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Type;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import mage.client.MageFrame;
import mage.client.dialog.MageDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.remote.XmageURLConnection;
import mage.client.util.AppUtil;
import mage.client.util.GUISizeHelper;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class WhatsNewDialog
extends MageDialog {
    private static final Logger LOGGER = Logger.getLogger(WhatsNewDialog.class);
    public static final String WHATS_NEW_PAGE = "https://jaydi85.github.io/xmage-web-news/news.html";
    private static final String WHATS_NEW_VERSION_PAGE = "https://jaydi85.github.io/xmage-web-news/news_version.html";
    private static final int WHATS_NEW_MAX_LOAD_TIMEOUT_SECS = 20;
    private static final boolean WHATS_NEW_DEBUG_ENABLE_CONTROLS = false;
    private final JFXPanel fxPanel;
    private WebView webView;
    private WebEngine engine;
    private boolean isPageReady = false;
    private SwingWorker<Void, Void> lastWaitingWorker = null;
    private final SwingWorker<Void, Void> checkUpdatesWorker = new SwingWorker<Void, Void>(){
        private String newVersion = "";

        @Override
        public Void doInBackground() {
            String newsVersion = XmageURLConnection.downloadText(WhatsNewDialog.WHATS_NEW_VERSION_PAGE);
            if (newsVersion.startsWith("version=")) {
                this.newVersion = newsVersion.substring("version=".length());
            }
            return null;
        }

        @Override
        public void done() {
            SwingUtilities.invokeLater(() -> {
                boolean isHaveUpdates;
                String oldVersion = PreferencesDialog.getCachedValue("newsPageLastVersion", "1");
                boolean bl = isHaveUpdates = this.newVersion.isEmpty() || !this.newVersion.equals(oldVersion);
                if (isHaveUpdates) {
                    PreferencesDialog.saveValue("newsPageLastVersion", this.newVersion);
                    WhatsNewDialog.this.startBrowser(WhatsNewDialog.WHATS_NEW_PAGE);
                    WhatsNewDialog.this.startWaitingWorker();
                }
            });
        }
    };
    private JButton buttonCancel;
    private JButton buttonRefresh;
    private JPanel panelData;

    public WhatsNewDialog() {
        this.initComponents();
        this.setDefaultCloseOperation(1);
        this.fxPanel = new JFXPanel();
        this.panelData.add((Component)this.fxPanel);
        this.webView = null;
        this.engine = null;
        this.createWebView();
    }

    private void showDialog() {
        this.setModal(true);
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.buttonCancel);
        this.setSize(GUISizeHelper.dialogGuiScaleSize(new Dimension(800, 600)));
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add((Component)this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.makeWindowCentered();
        this.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.setVisible(true);
    }

    private void startWaitingWorker() {
        if (this.lastWaitingWorker != null) {
            this.lastWaitingWorker.cancel(true);
        }
        this.lastWaitingWorker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                for (int waitedSecs = 0; !WhatsNewDialog.this.isPageReady && waitedSecs <= 20; ++waitedSecs) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                return null;
            }

            @Override
            public void done() {
                if (WhatsNewDialog.this.isPageReady) {
                    SwingUtilities.invokeLater(() -> WhatsNewDialog.this.showDialog());
                }
            }
        };
        this.lastWaitingWorker.execute();
    }

    public void checkUpdatesAndShow(boolean forceToShowPage) {
        if (!forceToShowPage) {
            this.checkUpdatesWorker.execute();
            return;
        }
        if (this.isPageReady) {
            SwingUtilities.invokeLater(() -> this.showDialog());
        } else {
            this.checkUpdatesWorker.cancel(true);
            this.startBrowser(WHATS_NEW_PAGE);
            this.startWaitingWorker();
        }
    }

    private void createWebView() {
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> {
            this.webView = new WebView();
            this.engine = this.webView.getEngine();
            this.engine.setJavaScriptEnabled(true);
            this.engine.setUserAgent(this.engine.getUserAgent() + " " + XmageURLConnection.getDefaultUserAgent());
            this.webView.contextMenuEnabledProperty().setValue(Boolean.valueOf(false));
            CookieManager cookieManager = new CookieManager(new PersistentCookieStore(), CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(cookieManager);
            this.engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                public void changed(ObservableValue<? extends Throwable> o, Throwable old, Throwable value) {
                    if (WhatsNewDialog.this.engine.getLoadWorker().getState() == Worker.State.FAILED || WhatsNewDialog.this.engine.getLoadWorker().getState() == Worker.State.CANCELLED) {
                        LOGGER.error((Object)"News page: can't load page", value);
                    }
                }
            });
            this.engine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                    if (newState != Worker.State.SUCCEEDED) {
                        return;
                    }
                    EventListener listener = new EventListener(){

                        @Override
                        public void handleEvent(Event ev) {
                            String href = ((Element)((Object)ev.getTarget())).getAttribute("href");
                            ev.preventDefault();
                            if (href != null && href.startsWith("http")) {
                                SwingUtilities.invokeLater(() -> AppUtil.openUrlInSystemBrowser(href));
                            }
                        }
                    };
                    Document doc = WhatsNewDialog.this.engine.getDocument();
                    NodeList listA = doc.getElementsByTagName("a");
                    for (int i = 0; i < listA.getLength(); ++i) {
                        ((EventTarget)((Object)listA.item(i))).addEventListener("click", listener, false);
                    }
                    WhatsNewDialog.this.isPageReady = true;
                }
            });
            this.fxPanel.setScene(new Scene((Parent)this.webView));
        });
    }

    public void startBrowser(String startingUrl) {
        Platform.runLater(() -> {
            String link = startingUrl;
            if (!link.startsWith("http")) {
                link = "http://" + link;
            }
            this.engine.load(link);
        });
    }

    private void onCancel() {
        this.hideDialog();
    }

    private void initComponents() {
        this.buttonCancel = new JButton();
        this.buttonRefresh = new JButton();
        this.panelData = new JPanel();
        this.buttonCancel.setText("Close");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhatsNewDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonRefresh.setText("Refresh");
        this.buttonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhatsNewDialog.this.buttonRefreshActionPerformed(evt);
            }
        });
        this.panelData.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelData, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonRefresh, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonCancel, -2, 100, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelData, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, 30, -2).addComponent(this.buttonRefresh, -2, 30, -2)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.onCancel();
    }

    private void buttonRefreshActionPerformed(ActionEvent evt) {
        this.startBrowser(WHATS_NEW_PAGE);
    }

    private static class PersistentCookieStore
    implements CookieStore,
    Runnable {
        private final CookieStore store = new CookieManager().getCookieStore();

        public PersistentCookieStore() {
            this.loadFromPrefs();
            Runtime.getRuntime().addShutdownHook(new Thread(this));
        }

        private void saveToPrefs() {
            List v1Cookies = this.store.getCookies().stream().peek(c -> c.setVersion(1)).map(HttpCookie::toString).collect(Collectors.toList());
            PreferencesDialog.saveValue("newsPageCookiesV2", new Gson().toJson(v1Cookies));
        }

        private void loadFromPrefs() {
            Type type = new TypeToken<List<String>>(){}.getType();
            try {
                String savedData = PreferencesDialog.getCachedValue("newsPageCookiesV2", "");
                List savedCookies = (List)new Gson().fromJson(savedData, type);
                if (savedCookies != null) {
                    savedCookies.forEach(savedCookie -> {
                        List<HttpCookie> v1Cookies = HttpCookie.parse("set-cookie2:" + savedCookie.replace("$", ""));
                        v1Cookies.forEach(realCookie -> {
                            realCookie.setVersion(0);
                            this.store.add(URI.create(realCookie.getDomain()), (HttpCookie)realCookie);
                        });
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"News page: catch broken cookies", (Throwable)e);
            }
        }

        @Override
        public void run() {
            this.saveToPrefs();
        }

        @Override
        public void add(URI uri, HttpCookie cookie) {
            this.store.add(uri, cookie);
        }

        @Override
        public List<HttpCookie> get(URI uri) {
            return this.store.get(uri);
        }

        @Override
        public List<HttpCookie> getCookies() {
            return this.store.getCookies();
        }

        @Override
        public List<URI> getURIs() {
            return this.store.getURIs();
        }

        @Override
        public boolean remove(URI uri, HttpCookie cookie) {
            return this.store.remove(uri, cookie);
        }

        @Override
        public boolean removeAll() {
            return this.store.removeAll();
        }
    }
}

