/*
 * Decompiled with CFR 0.152.
 */
package mage.client.draft;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import mage.abilities.icon.CardIconRenderSettings;
import mage.cards.CardDimensions;
import mage.cards.MageCard;
import mage.client.cards.BigCard;
import mage.client.cards.CardEventProducer;
import mage.client.cards.CardEventSource;
import mage.client.dialog.PreferencesDialog;
import mage.client.draft.DraftPanel;
import mage.client.plugins.impl.Plugins;
import mage.client.util.ClientEventType;
import mage.client.util.Event;
import mage.client.util.Listener;
import mage.client.util.audio.AudioManager;
import mage.client.util.comparators.CardViewRarityComparator;
import mage.view.CardView;
import mage.view.CardsView;
import mage.view.SimpleCardView;
import org.apache.log4j.Logger;

public class DraftGrid
extends JPanel
implements CardEventProducer {
    private static final Logger logger = Logger.getLogger(DraftGrid.class);
    private DraftPanel parentPanel;
    protected final CardEventSource cardEventSource = new CardEventSource();
    protected BigCard bigCard;
    protected MageCard markedCard;
    protected boolean emptyGrid;

    public DraftGrid() {
        this.initComponents();
        this.markedCard = null;
        this.emptyGrid = true;
        this.cardEventSource.addListener(event -> {
            if (this.parentPanel == null) {
                DraftPanel found = null;
                for (Container p = this; p != null; p = p.getParent()) {
                    if (!(p instanceof DraftPanel)) continue;
                    found = (DraftPanel)p;
                }
                if (found != null) {
                    this.parentPanel = found;
                } else {
                    throw new IllegalArgumentException("Wrong code usage: can't find DraftPanel from a DraftGrid - check form structure.");
                }
            }
            if (event.getEventType() == ClientEventType.CARD_DOUBLE_CLICK || event.getEventType() == ClientEventType.CARD_CLICK) {
                CardView card = (CardView)event.getSource();
                if (event.getEventType() == ClientEventType.CARD_DOUBLE_CLICK && this.parentPanel.isAllowedToPick()) {
                    this.cardEventSource.fireEvent((SimpleCardView)card, ClientEventType.DRAFT_PICK_CARD);
                    this.hidePopup();
                    AudioManager.playOnDraftSelect();
                } else {
                    MageCard cardPanel = (MageCard)event.getComponent();
                    if (this.markedCard != null) {
                        this.markedCard.setSelected(false);
                    }
                    this.cardEventSource.fireEvent((SimpleCardView)card, ClientEventType.DRAFT_MARK_CARD);
                    this.markedCard = cardPanel;
                    this.markedCard.setSelected(true);
                    this.repaint();
                }
            }
        });
    }

    public void clear() {
        this.markedCard = null;
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof MageCard)) continue;
            this.remove(comp);
        }
    }

    public void loadBooster(CardsView booster, BigCard bigCard) {
        if (booster != null && booster.isEmpty()) {
            this.emptyGrid = true;
        } else {
            if (!this.emptyGrid) {
                AudioManager.playOnDraftSelect();
            }
            this.emptyGrid = false;
        }
        this.bigCard = bigCard;
        this.removeAll();
        if (booster == null) {
            return;
        }
        int maxRows = 4;
        int numColumns = 5;
        int curColumn = 0;
        int curRow = 0;
        int offsetX = 5;
        int offsetY = 3;
        CardDimensions cardDimension = null;
        for (int i = 1; i < maxRows; ++i) {
            double scale = (double)(this.getHeight() / i) / 367.0;
            cardDimension = new CardDimensions(scale);
            int maxCards = this.getWidth() / (cardDimension.getFrameWidth() + offsetX);
            if (maxCards * i < booster.size()) continue;
            numColumns = booster.size() / i;
            if (booster.size() % i <= 0) break;
            ++numColumns;
            break;
        }
        if (cardDimension != null) {
            Rectangle rectangle = new Rectangle(cardDimension.getFrameWidth(), cardDimension.getFrameHeight());
            Dimension dimension = new Dimension(cardDimension.getFrameWidth(), cardDimension.getFrameHeight());
            ArrayList<CardView> sortedCards = new ArrayList<CardView>(booster.values());
            sortedCards.sort(new CardViewRarityComparator());
            for (CardView card : sortedCards) {
                MageCard cardImg = Plugins.instance.getMageCard(card, bigCard, new CardIconRenderSettings(), dimension, null, true, true, PreferencesDialog.getRenderMode(), true);
                cardImg.setCardContainerRef((Container)this);
                cardImg.update(card);
                this.add((Component)cardImg);
                rectangle.setLocation(curColumn * (cardDimension.getFrameWidth() + offsetX) + offsetX, curRow * (rectangle.height + offsetY) + offsetY);
                cardImg.setCardBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (++curColumn != numColumns) continue;
                curColumn = 0;
                ++curRow;
            }
            this.repaint();
        } else {
            logger.warn((Object)"Draft Grid - no possible fit of cards");
        }
    }

    public void addCardEventListener(Listener<Event> listener) {
        this.cardEventSource.addListener(listener);
    }

    private void hidePopup() {
        Plugins.instance.getActionCallback().mouseExited(null, null);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public CardEventSource getCardEventSource() {
        return this.cardEventSource;
    }

    public boolean isEmptyGrid() {
        return this.emptyGrid;
    }
}

