/*
 * Decompiled with CFR 0.152.
 */
package mage.client.game;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.util.gui.GuiDisplayUtil;
import mage.view.AbilityPickerView;

public class AbilityPicker
extends JPopupMenu
implements PopupMenuListener {
    private UUID gameId;

    public AbilityPicker(String ThisIsnotUsedAnymore) {
        this.addPopupMenuListener(this);
    }

    public void init(UUID gameId) {
        this.gameId = gameId;
    }

    public void cleanUp() {
        this.removePopupMenuListener(this);
    }

    public void show(AbilityPickerView choices, Point p) {
        if (p == null) {
            return;
        }
        this.removeAll();
        for (Map.Entry choice : choices.getChoices().entrySet()) {
            this.add(new AbilityPickerAction((UUID)choice.getKey(), (String)choice.getValue()));
        }
        this.show(MageFrame.getDesktop(), p.x, p.y);
        GuiDisplayUtil.keepComponentInsideScreen(p.x, p.y, this);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        SessionHandler.sendPlayerBoolean(this.gameId, false);
    }

    private class AbilityPickerAction
    extends AbstractAction {
        private final UUID id;

        public AbilityPickerAction(UUID id, String choice) {
            this.id = id;
            this.putValue("Name", choice);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SessionHandler.sendPlayerUUID(AbilityPicker.this.gameId, this.id);
            AbilityPicker.this.setVisible(false);
        }
    }
}

