/*
 * Decompiled with CFR 0.152.
 */
package mage.client.game;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Field;
import java.util.EventListener;
import java.util.Set;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeListener;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.cards.BigCard;
import mage.client.dialog.PreferencesDialog;
import mage.client.game.BattlefieldPanel;
import mage.client.game.GamePanel;
import mage.client.game.PlayAreaPanelOptions;
import mage.client.game.PlayerPanelExt;
import mage.client.util.GUISizeHelper;
import mage.constants.PlayerAction;
import mage.view.GameView;
import mage.view.PlayerView;
import mage.view.UserRequestMessage;

public class PlayAreaPanel
extends JPanel {
    private final JPopupMenu popupMenu;
    private UUID playerId;
    private String playerName;
    private UUID gameId;
    private boolean isMe = false;
    private boolean smallMode = false;
    private boolean playingMode = true;
    private final GamePanel gamePanel;
    private final PlayAreaPanelOptions options;
    private JCheckBoxMenuItem manaPoolMenuItem1;
    private JCheckBoxMenuItem manaPoolMenuItem2;
    private JCheckBoxMenuItem useFirstManaAbilityItem;
    private JCheckBoxMenuItem allowViewHandCardsMenuItem;
    private JCheckBoxMenuItem holdPriorityMenuItem;
    public static final int PANEL_HEIGHT = 273;
    public static final int PANEL_HEIGHT_SMALL = 220;
    private static final int PANEL_HEIGHT_EXTRA_FOR_ME = 25;
    private BattlefieldPanel battlefieldPanel;
    private PlayerPanelExt playerPanel;

    public PlayAreaPanel(PlayerView player, BigCard bigCard, UUID gameId, int priorityTime, GamePanel gamePanel, PlayAreaPanelOptions options) {
        this.gamePanel = gamePanel;
        this.options = options;
        this.initComponents();
        this.setOpaque(false);
        this.battlefieldPanel.setOpaque(false);
        this.init(player, bigCard, gameId, priorityTime);
        this.update(null, player, null, null);
        this.playerPanel.sizePlayerPanel(this.isSmallMode());
        this.popupMenu = new JPopupMenu();
        if (options.isPlayer) {
            this.addPopupMenuPlayer(player.getUserData().isAllowRequestHandToAll());
        } else {
            this.addPopupMenuWatcher();
        }
        this.setGUISize();
    }

    public void CleanUp() {
        this.battlefieldPanel.cleanUp();
        this.playerPanel.cleanUp();
        for (ChangeListener changeListener : MenuSelectionManager.defaultManager().getChangeListeners()) {
            if (!changeListener.getClass().getName().contains("MenuKeyboardHelper")) continue;
            try {
                Field field = changeListener.getClass().getDeclaredField("menuInputMap");
                field.setAccessible(true);
                field.set(changeListener, null);
            }
            catch (Exception exception) {}
            break;
        }
        for (EventListener eventListener : this.battlefieldPanel.getMainPanel().getMouseListeners()) {
            this.battlefieldPanel.getMainPanel().removeMouseListener((MouseListener)eventListener);
        }
        this.popupMenu.getUI().uninstallUI(this);
    }

    public void changeGUISize() {
        this.setGUISize();
        this.battlefieldPanel.changeGUISize();
        this.playerPanel.changeGUISize();
    }

    private void setGUISize() {
        GUISizeHelper.changePopupMenuFont(this.popupMenu);
    }

    private void addPopupMenuPlayer(boolean allowRequestToShowHandCards) {
        ActionListener skipListener = e -> {
            switch (e.getActionCommand()) {
                case "F2": {
                    if (this.gamePanel.getFeedbackPanel() == null) break;
                    this.gamePanel.getFeedbackPanel().pressOKYesOrDone();
                    break;
                }
                case "F3": {
                    SessionHandler.sendPlayerAction(PlayerAction.PASS_PRIORITY_CANCEL_ALL_ACTIONS, this.gameId, null);
                    break;
                }
                case "F4": {
                    SessionHandler.sendPlayerAction(PlayerAction.PASS_PRIORITY_UNTIL_NEXT_TURN, this.gameId, null);
                    break;
                }
                case "F5": {
                    SessionHandler.sendPlayerAction(PlayerAction.PASS_PRIORITY_UNTIL_TURN_END_STEP, this.gameId, null);
                    break;
                }
                case "F6": {
                    SessionHandler.sendPlayerAction(PlayerAction.PASS_PRIORITY_UNTIL_NEXT_TURN_SKIP_STACK, this.gameId, null);
                    break;
                }
                case "F7": {
                    SessionHandler.sendPlayerAction(PlayerAction.PASS_PRIORITY_UNTIL_NEXT_MAIN_PHASE, this.gameId, null);
                    break;
                }
                case "F9": {
                    SessionHandler.sendPlayerAction(PlayerAction.PASS_PRIORITY_UNTIL_MY_NEXT_TURN, this.gameId, null);
                    break;
                }
                case "F11": {
                    SessionHandler.sendPlayerAction(PlayerAction.PASS_PRIORITY_UNTIL_END_STEP_BEFORE_MY_NEXT_TURN, this.gameId, null);
                    break;
                }
            }
        };
        JMenuItem menuItem = new JMenuItem("<html><b>F2</b> - Confirm current request");
        menuItem.setActionCommand("F2");
        menuItem.setMnemonic(79);
        this.popupMenu.add(menuItem);
        menuItem.addActionListener(skipListener);
        menuItem = new JMenuItem("<html><b>F3</b> - Cancel active skip action");
        menuItem.setActionCommand("F3");
        menuItem.setMnemonic(78);
        this.popupMenu.add(menuItem);
        menuItem.addActionListener(skipListener);
        this.holdPriorityMenuItem = new JCheckBoxMenuItem("<html><b>" + (System.getProperty("os.name").contains("Mac OS X") ? "Cmd" : "Ctrl") + "+click</b> - Hold Priority");
        this.holdPriorityMenuItem.setMnemonic(80);
        this.holdPriorityMenuItem.setToolTipText("<html>Hold priority after casting a spell or activating an ability, instead of automatically passing priority.");
        this.popupMenu.add(this.holdPriorityMenuItem);
        this.holdPriorityMenuItem.addActionListener(e -> {
            boolean holdPriority = ((JCheckBoxMenuItem)e.getSource()).getState();
            this.gamePanel.setMenuStates(this.manaPoolMenuItem1.getState(), this.manaPoolMenuItem2.getState(), this.useFirstManaAbilityItem.getState(), holdPriority);
            this.gamePanel.holdPriority(holdPriority);
        });
        JMenu skipMenu = new JMenu("Skip");
        skipMenu.setMnemonic(83);
        this.popupMenu.add(skipMenu);
        String tooltipText = "<html>This skip actions stops if something goes to <br><b>stack</b> and if <b>attackers</b> or <b>blocker</b> have to be <b>declared</b>.";
        String everythingTooltipText = "<html>This skip actions stops if <b>attackers</b> or <b>blocker</b> have to be <b>declared</b>, but not if something goes to the <b>stack</b>.";
        menuItem = new JMenuItem("<html><b>F4</b> - Phases until next turn");
        menuItem.setActionCommand("F4");
        menuItem.setToolTipText(tooltipText);
        menuItem.setMnemonic(84);
        skipMenu.add(menuItem);
        menuItem.addActionListener(skipListener);
        menuItem = new JMenuItem("<html><b>F5</b> - Phases until next end step");
        menuItem.setActionCommand("F5");
        menuItem.setToolTipText(tooltipText);
        menuItem.setMnemonic(69);
        skipMenu.add(menuItem);
        menuItem.addActionListener(skipListener);
        menuItem = new JMenuItem("<html><b>F6</b> - Everything until the next turn");
        menuItem.setActionCommand("F6");
        menuItem.setToolTipText(everythingTooltipText);
        menuItem.setMnemonic(85);
        skipMenu.add(menuItem);
        menuItem.addActionListener(skipListener);
        menuItem = new JMenuItem("<html><b>F7</b> - Phases until begin of next main phase");
        menuItem.setToolTipText(tooltipText);
        menuItem.setActionCommand("F7");
        menuItem.setMnemonic(77);
        skipMenu.add(menuItem);
        menuItem.addActionListener(skipListener);
        menuItem = new JMenuItem("<html><b>F9</b> - Everything until your own next turn");
        menuItem.setActionCommand("F9");
        menuItem.setToolTipText(everythingTooltipText);
        menuItem.setMnemonic(86);
        skipMenu.add(menuItem);
        menuItem.addActionListener(skipListener);
        menuItem = new JMenuItem("<html><b>F11</b> - Everything until end step prior to your own next turn");
        menuItem.setActionCommand("F11");
        menuItem.setToolTipText(everythingTooltipText);
        menuItem.setMnemonic(80);
        skipMenu.add(menuItem);
        menuItem.addActionListener(skipListener);
        this.popupMenu.addSeparator();
        JMenu manaPoolMenu = new JMenu("Mana payment");
        manaPoolMenu.setMnemonic(77);
        this.popupMenu.add(manaPoolMenu);
        this.manaPoolMenuItem1 = new JCheckBoxMenuItem("Automatically", true);
        this.manaPoolMenuItem1.setMnemonic(65);
        this.manaPoolMenuItem1.setToolTipText("<html>If not active, produced mana goes only to the mana pool<br>and you have to click the type of mana you want to use <br>in the player mana pool panel for payment.");
        manaPoolMenu.add(this.manaPoolMenuItem1);
        this.manaPoolMenuItem1.addActionListener(e -> {
            boolean manaPoolAutomatic = ((JCheckBoxMenuItem)e.getSource()).getState();
            PreferencesDialog.saveValue("gameManaAutopayment", manaPoolAutomatic ? "true" : "false");
            this.gamePanel.setMenuStates(manaPoolAutomatic, this.manaPoolMenuItem2.getState(), this.useFirstManaAbilityItem.getState(), this.holdPriorityMenuItem.getState());
            SessionHandler.sendPlayerAction(manaPoolAutomatic ? PlayerAction.MANA_AUTO_PAYMENT_ON : PlayerAction.MANA_AUTO_PAYMENT_OFF, this.gameId, null);
        });
        this.manaPoolMenuItem2 = new JCheckBoxMenuItem("No automatic usage for mana already in the pool", true);
        this.manaPoolMenuItem2.setMnemonic(78);
        this.manaPoolMenuItem2.setToolTipText("<html>Mana that is already in the mana pool as you start casting a spell or activating an ability<br> needs to be payed manually. So you use the mana in the pool only by clicking on the related<br> mana symbols of mana pool area.");
        manaPoolMenu.add(this.manaPoolMenuItem2);
        this.manaPoolMenuItem2.addActionListener(e -> {
            boolean manaPoolAutomaticRestricted = ((JCheckBoxMenuItem)e.getSource()).getState();
            PreferencesDialog.saveValue("gameManaAutopaymentOnlyOne", manaPoolAutomaticRestricted ? "true" : "false");
            this.gamePanel.setMenuStates(this.manaPoolMenuItem1.getState(), manaPoolAutomaticRestricted, this.useFirstManaAbilityItem.getState(), this.holdPriorityMenuItem.getState());
            SessionHandler.sendPlayerAction(manaPoolAutomaticRestricted ? PlayerAction.MANA_AUTO_PAYMENT_RESTRICTED_ON : PlayerAction.MANA_AUTO_PAYMENT_RESTRICTED_OFF, this.gameId, null);
        });
        this.useFirstManaAbilityItem = new JCheckBoxMenuItem("Use first mana ability when tapping lands", false);
        this.useFirstManaAbilityItem.setMnemonic(70);
        this.useFirstManaAbilityItem.setToolTipText("<html>Use the first mana ability when<br> tapping lands for mana<br>You can hold Alt+1 whilst tapping lands to use this feature");
        manaPoolMenu.add(this.useFirstManaAbilityItem);
        this.useFirstManaAbilityItem.addActionListener(e -> {
            boolean useFirstManaAbility = ((JCheckBoxMenuItem)e.getSource()).getState();
            PreferencesDialog.saveValue("useFirstManaAbility", useFirstManaAbility ? "true" : "false");
            this.gamePanel.setMenuStates(this.manaPoolMenuItem1.getState(), this.manaPoolMenuItem2.getState(), useFirstManaAbility, this.holdPriorityMenuItem.getState());
            SessionHandler.sendPlayerAction(useFirstManaAbility ? PlayerAction.USE_FIRST_MANA_ABILITY_ON : PlayerAction.USE_FIRST_MANA_ABILITY_OFF, this.gameId, null);
        });
        JMenu automaticConfirmsMenu = new JMenu("Auto-answers");
        automaticConfirmsMenu.setMnemonic(85);
        this.popupMenu.add(automaticConfirmsMenu);
        menuItem = new JMenuItem("Replacement effects - reset all auto-answers");
        menuItem.setMnemonic(82);
        menuItem.setToolTipText("Reset all effects that were added to the list of auto select replacement effects this game.");
        automaticConfirmsMenu.add(menuItem);
        menuItem.addActionListener(e -> SessionHandler.sendPlayerAction(PlayerAction.RESET_AUTO_SELECT_REPLACEMENT_EFFECTS, this.gameId, null));
        menuItem = new JMenuItem("Triggered abilities - reset all auto-answers for stack order");
        menuItem.setMnemonic(84);
        menuItem.setToolTipText("Reset all triggered ability order settings you added during the game.");
        automaticConfirmsMenu.add(menuItem);
        menuItem.addActionListener(e -> SessionHandler.sendPlayerAction(PlayerAction.TRIGGER_AUTO_ORDER_RESET_ALL, this.gameId, null));
        menuItem = new JMenuItem("Yes/no requests - reset all auto-answers");
        menuItem.setMnemonic(84);
        menuItem.setToolTipText("Reset all defined automatic answers for Yes/No usage requests (with two buttons).");
        automaticConfirmsMenu.add(menuItem);
        menuItem.addActionListener(e -> SessionHandler.sendPlayerAction(PlayerAction.REQUEST_AUTO_ANSWER_RESET_ALL, this.gameId, null));
        JMenu rollbackMainItem = new JMenu("Rollback");
        rollbackMainItem.setToolTipText("The game will be rolled back to the start of the requested turn if all players agree");
        this.popupMenu.add(rollbackMainItem);
        if (this.options.rollbackTurnsAllowed) {
            ActionListener rollBackActionListener = e -> {
                int turnsToRollBack = Integer.parseInt(e.getActionCommand());
                SessionHandler.sendPlayerAction(PlayerAction.ROLLBACK_TURNS, this.gameId, turnsToRollBack);
            };
            rollbackMainItem.setMnemonic(82);
            menuItem = new JMenuItem("To the start of the current turn");
            menuItem.setMnemonic(67);
            menuItem.setActionCommand("0");
            menuItem.addActionListener(rollBackActionListener);
            rollbackMainItem.add(menuItem);
            menuItem = new JMenuItem("To the start of the previous turn");
            menuItem.setMnemonic(80);
            menuItem.setActionCommand("1");
            menuItem.addActionListener(rollBackActionListener);
            rollbackMainItem.add(menuItem);
            menuItem = new JMenuItem("The current turn and the 2 turns before");
            menuItem.setMnemonic(50);
            menuItem.setActionCommand("2");
            menuItem.addActionListener(rollBackActionListener);
            rollbackMainItem.add(menuItem);
            menuItem = new JMenuItem("The current turn and the 3 turns before");
            menuItem.setMnemonic(51);
            menuItem.setActionCommand("3");
            menuItem.addActionListener(rollBackActionListener);
            rollbackMainItem.add(menuItem);
        } else {
            rollbackMainItem.setText(rollbackMainItem.getText() + ", restricted");
        }
        JMenu concedeMenu = new JMenu("Concede");
        concedeMenu.setMnemonic(67);
        this.popupMenu.add(concedeMenu);
        ActionListener concedeListener = e -> {
            switch (e.getActionCommand()) {
                case "Game": {
                    UserRequestMessage message = new UserRequestMessage("Confirm concede game", "Are you sure you want to concede the game?");
                    message.setButton1("No", null);
                    message.setButton2("Yes", PlayerAction.CLIENT_CONCEDE_GAME);
                    message.setGameId(this.gameId);
                    MageFrame.getInstance().showUserRequestDialog(message);
                    break;
                }
                case "Match": {
                    UserRequestMessage message = new UserRequestMessage("Confirm concede match", "Are you sure you want to concede the complete match?");
                    message.setButton1("No", null);
                    message.setButton2("Yes", PlayerAction.CLIENT_CONCEDE_MATCH);
                    message.setGameId(this.gameId);
                    MageFrame.getInstance().showUserRequestDialog(message);
                    break;
                }
            }
        };
        menuItem = new JMenuItem("Game");
        menuItem.setMnemonic(71);
        menuItem.setActionCommand("Game");
        menuItem.setToolTipText("Concedes only the current game and after that the next game of the match is started if there is another game needed.");
        concedeMenu.add(menuItem);
        menuItem.addActionListener(concedeListener);
        menuItem = new JMenuItem("Match");
        menuItem.setMnemonic(77);
        menuItem.setActionCommand("Match");
        menuItem.setToolTipText("Concedes the complete match. So if you're in a tournament you finish the current tournament round.");
        concedeMenu.add(menuItem);
        menuItem.addActionListener(concedeListener);
        this.battlefieldPanel.getMainPanel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkMenu(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkMenu(e);
            }

            private void checkMenu(MouseEvent e) {
                if (e.isPopupTrigger() && PlayAreaPanel.this.playingMode) {
                    PlayAreaPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.popupMenu.addSeparator();
        JMenu handCardsMenu = new JMenu(String.format("Cards on hand (%s)", this.options.playerItself ? "me" : this.playerName));
        handCardsMenu.setMnemonic(72);
        this.popupMenu.add(handCardsMenu);
        if (!this.options.playerItself) {
            menuItem = new JMenuItem("Request permission to see the hand cards");
            menuItem.setMnemonic(80);
            handCardsMenu.add(menuItem);
            menuItem.addActionListener(e -> SessionHandler.sendPlayerAction(PlayerAction.REQUEST_PERMISSION_TO_SEE_HAND_CARDS, this.gameId, this.playerId));
        } else {
            this.allowViewHandCardsMenuItem = new JCheckBoxMenuItem("Allow hand requests from other users", allowRequestToShowHandCards);
            this.allowViewHandCardsMenuItem.setMnemonic(65);
            this.allowViewHandCardsMenuItem.setToolTipText("Watchers or other players can request your hand cards once per game. Re-activate it to allow new requests.");
            handCardsMenu.add(this.allowViewHandCardsMenuItem);
            this.allowViewHandCardsMenuItem.addActionListener(e -> {
                boolean requestsAllowed = ((JCheckBoxMenuItem)e.getSource()).getState();
                PreferencesDialog.setPrefValue("gameAllowRequestShowHandCards", requestsAllowed);
                SessionHandler.sendPlayerAction(requestsAllowed ? PlayerAction.PERMISSION_REQUESTS_ALLOWED_ON : PlayerAction.PERMISSION_REQUESTS_ALLOWED_OFF, this.gameId, null);
            });
            menuItem = new JMenuItem("Revoke all permission(s) to see your hand cards");
            menuItem.setMnemonic(82);
            menuItem.setToolTipText("Revoke already granted permission for all spectators to see your hand cards.");
            handCardsMenu.add(menuItem);
            menuItem.addActionListener(e -> SessionHandler.sendPlayerAction(PlayerAction.REVOKE_PERMISSIONS_TO_SEE_HAND_CARDS, this.gameId, null));
        }
        menuItem = new JMenuItem(String.format("<html>View deck (%s)", this.options.playerItself ? "me" : this.playerName));
        this.popupMenu.add(menuItem);
        if (this.options.playerItself || !this.options.isHuman) {
            menuItem.setMnemonic(68);
            menuItem.addActionListener(e -> SessionHandler.sendPlayerAction(PlayerAction.VIEW_LIMITED_DECK, this.gameId, this.playerId));
        } else {
            menuItem.setText(menuItem.getText() + ", restricted");
        }
        menuItem = new JMenuItem(String.format("<html>View sideboard (%s)", this.options.playerItself ? "me" : this.playerName));
        this.popupMenu.add(menuItem);
        if (this.options.playerItself || !this.options.isHuman) {
            menuItem.setMnemonic(83);
            menuItem.addActionListener(e -> SessionHandler.sendPlayerAction(PlayerAction.VIEW_SIDEBOARD, this.gameId, this.playerId));
        } else {
            menuItem.setText(menuItem.getText() + ", restricted");
        }
    }

    private void addPopupMenuWatcher() {
        JMenuItem menuItem = new JMenuItem("Stop watching");
        this.popupMenu.add(menuItem);
        menuItem.addActionListener(e -> {
            UserRequestMessage message = new UserRequestMessage("Confirm stop watching game", "Are you sure you want to stop watching the game?");
            message.setButton1("No", null);
            message.setButton2("Yes", PlayerAction.CLIENT_STOP_WATCHING);
            message.setGameId(this.gameId);
            MageFrame.getInstance().showUserRequestDialog(message);
        });
        menuItem = new JMenuItem(String.format("Request permission to see hand cards (%s)", this.playerName));
        this.popupMenu.add(menuItem);
        menuItem.addActionListener(e -> SessionHandler.sendPlayerAction(PlayerAction.REQUEST_PERMISSION_TO_SEE_HAND_CARDS, this.gameId, this.playerId));
        this.battlefieldPanel.getMainPanel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkMenu(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkMenu(e);
            }

            private void checkMenu(MouseEvent e) {
                if (e.isPopupTrigger() && PlayAreaPanel.this.playingMode) {
                    PlayAreaPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public final void init(PlayerView player, BigCard bigCard, UUID gameId, int priorityTime) {
        this.playerPanel.init(gameId, player.getPlayerId(), player.getControlled(), bigCard, priorityTime);
        this.battlefieldPanel.init(gameId, bigCard);
        this.gameId = gameId;
        this.playerId = player.getPlayerId();
        this.playerName = player.getName();
        this.isMe = player.getControlled();
    }

    public final void update(GameView game, PlayerView player, Set<UUID> possibleTargets, Set<UUID> chosenTargets) {
        this.playerPanel.update(game, player, possibleTargets, chosenTargets);
        this.battlefieldPanel.update(player.getBattlefield());
        if (this.allowViewHandCardsMenuItem != null) {
            this.allowViewHandCardsMenuItem.setSelected(player.getUserData().isAllowRequestHandToAll());
        }
    }

    public BattlefieldPanel getBattlefieldPanel() {
        return this.battlefieldPanel;
    }

    public PlayerPanelExt getPlayerPanel() {
        return this.playerPanel;
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0, 0)));
        this.playerPanel = new PlayerPanelExt(GUISizeHelper.playerPanelGuiScale);
        this.battlefieldPanel = new BattlefieldPanel();
        this.battlefieldPanel.setTopPanelBattlefield(this.options.topRow);
        this.battlefieldPanel.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setLayout(new BorderLayout());
        this.add((Component)this.playerPanel, "West");
        this.add((Component)this.battlefieldPanel, "Center");
        this.add(Box.createRigidArea(new Dimension(0, 10)), "South");
    }

    private void btnCheatActionPerformed(ActionEvent evt) {
        SessionHandler.cheatShow(this.gameId, this.playerId);
    }

    public boolean isSmallMode() {
        return this.smallMode;
    }

    public void setPlayingMode(boolean playingMode) {
        this.playingMode = playingMode;
    }

    public void setMenuStates(boolean manaPoolAutomatic, boolean manaPoolAutomaticRestricted, boolean useFirstManaAbility, boolean holdPriority) {
        if (this.manaPoolMenuItem1 != null) {
            this.manaPoolMenuItem1.setSelected(manaPoolAutomatic);
        }
        if (this.manaPoolMenuItem2 != null) {
            this.manaPoolMenuItem2.setSelected(manaPoolAutomaticRestricted);
        }
        if (this.useFirstManaAbilityItem != null) {
            this.useFirstManaAbilityItem.setSelected(useFirstManaAbility);
        }
        if (this.holdPriorityMenuItem != null) {
            this.holdPriorityMenuItem.setSelected(holdPriority);
        }
    }
}

