/*
 * Decompiled with CFR 0.152.
 */
package mage.client.plugins.impl;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.JComponent;
import mage.abilities.icon.CardIconRenderSettings;
import mage.cards.MageCard;
import mage.cards.action.ActionCallback;
import mage.client.MageFrame;
import mage.client.cards.BigCard;
import mage.client.dialog.PreferencesDialog;
import mage.client.plugins.MagePlugins;
import mage.client.plugins.adapters.MageActionCallback;
import mage.interfaces.PluginException;
import mage.interfaces.plugin.CardPlugin;
import mage.interfaces.plugin.CounterPlugin;
import mage.interfaces.plugin.ThemePlugin;
import mage.view.CardView;
import mage.view.PermanentView;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.impl.PluginManagerFactory;
import net.xeoh.plugins.base.options.AddPluginsFromOption;
import net.xeoh.plugins.base.options.GetPluginOption;
import net.xeoh.plugins.base.util.uri.ClassURI;
import org.apache.log4j.Logger;
import org.mage.card.arcane.MageLayer;
import org.mage.plugins.card.CardPluginImpl;
import org.mage.plugins.card.utils.CardImageUtils;
import org.mage.plugins.theme.ThemePluginImpl;

public enum Plugins implements MagePlugins
{
    instance;

    public static final String PLUGINS_DIRECTORY = "plugins";
    private static final Logger LOGGER;
    private static PluginManager pm;
    private ThemePlugin themePlugin = null;
    private CardPlugin cardPlugin = null;
    private CounterPlugin counterPlugin = null;
    private static final MageActionCallback mageActionCallback;
    private final Map<String, String> sortingOptions = new HashMap<String, String>();

    @Override
    public void loadPlugins() {
        LOGGER.info((Object)"Loading plugins...");
        pm = PluginManagerFactory.createPluginManager();
        pm.addPluginsFrom(new File(PLUGINS_DIRECTORY + File.separator).toURI(), new AddPluginsFromOption[0]);
        pm.addPluginsFrom(new ClassURI(CardPluginImpl.class).toURI(), new AddPluginsFromOption[0]);
        pm.addPluginsFrom(new ClassURI(ThemePluginImpl.class).toURI(), new AddPluginsFromOption[0]);
        this.cardPlugin = (CardPlugin)pm.getPlugin(CardPlugin.class, new GetPluginOption[0]);
        this.counterPlugin = (CounterPlugin)pm.getPlugin(CounterPlugin.class, new GetPluginOption[0]);
        this.themePlugin = (ThemePlugin)pm.getPlugin(ThemePlugin.class, new GetPluginOption[0]);
        LOGGER.info((Object)"Done.");
    }

    @Override
    public void shutdown() {
        if (pm != null) {
            pm.shutdown();
        }
    }

    @Override
    public void changeGUISize() {
        if (this.cardPlugin != null) {
            this.cardPlugin.changeGUISize();
        }
    }

    @Override
    public void updateGamePanel(Map<String, JComponent> ui) {
        if (MageFrame.isLite() || MageFrame.isGray() || this.themePlugin == null) {
            return;
        }
        this.themePlugin.applyInGame(ui);
    }

    @Override
    public JComponent updateTablePanel(Map<String, JComponent> ui) {
        if (MageFrame.isLite() || MageFrame.isGray() || this.themePlugin == null) {
            return null;
        }
        return this.themePlugin.updateTable(ui);
    }

    @Override
    public MageCard getMagePermanent(PermanentView card, BigCard bigCard, CardIconRenderSettings cardIconRenderSettings, Dimension dimension, UUID gameId, boolean loadImage, int renderMode, boolean needFullPermanentRender) {
        if (this.cardPlugin == null) {
            throw new IllegalArgumentException("Card's plugin must be loaded");
        }
        mageActionCallback.refreshSession();
        mageActionCallback.setCardPreviewComponent(bigCard);
        MageCard mageCard = this.cardPlugin.getMagePermanent(card, dimension, gameId, (ActionCallback)mageActionCallback, false, !MageFrame.isLite() && loadImage, renderMode, needFullPermanentRender);
        return this.createLayeredCard(mageCard, dimension, cardIconRenderSettings);
    }

    @Override
    public MageCard getMageCard(CardView card, BigCard bigCard, CardIconRenderSettings cardIconRenderSettings, Dimension dimension, UUID gameId, boolean loadImage, boolean previewable, int renderMode, boolean needFullPermanentRender) {
        if (this.cardPlugin == null) {
            throw new IllegalArgumentException("Card's plugin must be loaded");
        }
        if (previewable) {
            mageActionCallback.refreshSession();
            mageActionCallback.setCardPreviewComponent(bigCard);
        }
        MageCard mageCard = this.cardPlugin.getMageCard(card, dimension, gameId, (ActionCallback)mageActionCallback, false, !MageFrame.isLite() && loadImage, renderMode, needFullPermanentRender);
        return this.createLayeredCard(mageCard, dimension, cardIconRenderSettings);
    }

    private MageCard createLayeredCard(MageCard mageCard, Dimension dimension, CardIconRenderSettings cardIconRenderSettings) {
        MageLayer mageLayer = new MageLayer(mageCard, cardIconRenderSettings);
        mageLayer.setCardBounds(0, 0, dimension.width, dimension.height);
        return mageLayer;
    }

    @Override
    public boolean isCardPluginLoaded() {
        return this.cardPlugin != null;
    }

    @Override
    public int sortPermanents(Map<String, JComponent> ui, Map<UUID, MageCard> cards, boolean topRow) {
        if (this.cardPlugin != null) {
            return this.cardPlugin.sortPermanents(ui, cards, PreferencesDialog.getCachedValue("nonLandPermanentsInOnePile", "false").equals("true"), topRow);
        }
        return -1;
    }

    @Override
    public void downloadSymbols() {
        if (this.cardPlugin != null) {
            this.cardPlugin.downloadSymbols(CardImageUtils.getImagesDir());
        }
    }

    @Override
    public int getGamesPlayed() {
        if (this.counterPlugin != null) {
            Class<Plugins> clazz = Plugins.class;
            synchronized (Plugins.class) {
                try {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return this.counterPlugin.getGamePlayed();
                }
                catch (PluginException e) {
                    LOGGER.fatal((Object)e.getMessage());
                    throw new RuntimeException(e);
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addGamesPlayed() {
        if (this.counterPlugin == null) return;
        Class<Plugins> clazz = Plugins.class;
        synchronized (Plugins.class) {
            try {
                this.counterPlugin.addGamePlayed();
            }
            catch (PluginException e) {
                LOGGER.fatal((Object)e.getMessage());
                throw new RuntimeException(e);
            }
            return;
        }
    }

    @Override
    public boolean isCounterPluginLoaded() {
        return this.counterPlugin != null;
    }

    @Override
    public boolean isThemePluginLoaded() {
        return this.themePlugin != null;
    }

    @Override
    public void onAddCard(MageCard card, int count) {
        if (this.cardPlugin != null) {
            this.cardPlugin.onAddCard(card, count);
        }
    }

    @Override
    public void onRemoveCard(MageCard card, int count) {
        if (this.cardPlugin != null) {
            this.cardPlugin.onRemoveCard(card, count);
        }
    }

    @Override
    public JComponent getCardInfoPane() {
        if (this.cardPlugin != null) {
            return this.cardPlugin.getCardInfoPane();
        }
        return null;
    }

    @Override
    public BufferedImage getOriginalImage(CardView card) {
        if (this.cardPlugin != null) {
            return this.cardPlugin.getOriginalImage(card);
        }
        return null;
    }

    @Override
    public ActionCallback getActionCallback() {
        return mageActionCallback;
    }

    static {
        LOGGER = Logger.getLogger(Plugins.class);
        mageActionCallback = new MageActionCallback();
    }
}

