/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.swing.table.AbstractTableModel;
import mage.remote.MageRemoteException;
import mage.view.MatchView;

public class MatchesTableModel
extends AbstractTableModel {
    private final String[] columnNames = new String[]{"Deck Type", "Players", "Game Type", "Rating", "Result", "Duration", "Start Time", "End Time", "Action"};
    public static final int COLUMN_DURATION = 5;
    public static final int COLUMN_START = 6;
    public static final int COLUMN_END = 7;
    public static final int COLUMN_ACTION = 8;
    private MatchView[] matches = new MatchView[0];

    public void loadData(Collection<MatchView> matches) throws MageRemoteException {
        this.matches = matches.toArray(new MatchView[0]);
        this.fireTableDataChanged();
    }

    MatchesTableModel() {
    }

    public String getTableAndGameInfo(int row) {
        return this.matches[row].getTableId().toString() + ";" + (!this.matches[row].getGames().isEmpty() ? ((UUID)this.matches[row].getGames().get(0)).toString() : "null");
    }

    public String findTableAndGameInfoByRow(int row) {
        if (row >= 0 && row < this.matches.length) {
            return this.getTableAndGameInfo(row);
        }
        return null;
    }

    public int findRowByTableAndGameInfo(String tableAndGame) {
        for (int i = 0; i < this.matches.length; ++i) {
            String rowID = this.matches[i].getTableId().toString() + ";" + (!this.matches[i].getGames().isEmpty() ? ((UUID)this.matches[i].getGames().get(0)).toString() : "null");
            if (!tableAndGame.equals(rowID)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        return this.matches.length;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        switch (arg1) {
            case 0: {
                return this.matches[arg0].getDeckType();
            }
            case 1: {
                return this.matches[arg0].getPlayers();
            }
            case 2: {
                return this.matches[arg0].getGameType();
            }
            case 3: {
                return this.matches[arg0].isRated() ? "YES" : "";
            }
            case 4: {
                return this.matches[arg0].getResult();
            }
            case 5: {
                if (this.matches[arg0].getEndTime() != null) {
                    return this.matches[arg0].getEndTime().getTime() - this.matches[arg0].getStartTime().getTime() + new Date().getTime();
                }
                return 0L;
            }
            case 6: {
                return this.matches[arg0].getStartTime();
            }
            case 7: {
                return this.matches[arg0].getEndTime();
            }
            case 8: {
                if (this.matches[arg0].isTournament()) {
                    return "Show";
                }
                if (this.matches[arg0].isReplayAvailable()) {
                    return "Replay";
                }
                return "None";
            }
            case 9: {
                return this.matches[arg0].getGames();
            }
        }
        return "";
    }

    public List<UUID> getListofGames(int row) {
        return this.matches[row].getGames();
    }

    public boolean isTournament(int row) {
        return this.matches[row].isTournament();
    }

    public UUID getMatchId(int row) {
        return this.matches[row].getMatchId();
    }

    public UUID getTableId(int row) {
        return this.matches[row].getTableId();
    }

    @Override
    public String getColumnName(int columnIndex) {
        String colName = "";
        if (columnIndex <= this.getColumnCount()) {
            colName = this.columnNames[columnIndex];
        }
        return colName;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 5: {
                return Long.class;
            }
            case 6: {
                return Date.class;
            }
            case 7: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 8;
    }
}

