/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import mage.cards.decks.DeckFileFilter;
import mage.client.MageFrame;
import mage.client.deck.generator.DeckGenerator;
import mage.client.util.ClientDefaultSettings;

public class NewPlayerPanel
extends JPanel {
    private final JFileChooser fcSelectDeck;
    private JButton btnGenerate;
    private JButton btnPlayerDeck;
    private JLabel lblLevel;
    private JLabel lblPlayerDeck;
    private JLabel lblPlayerName;
    private JSpinner spnLevel;
    private JTextField txtPlayerDeck;
    private JTextField txtPlayerName;

    public NewPlayerPanel() {
        this.initComponents();
        this.fcSelectDeck = new JFileChooser();
        this.fcSelectDeck.setAcceptAllFileFilterUsed(false);
        this.fcSelectDeck.addChoosableFileFilter(new DeckFileFilter("dck", "XMage's deck files (*.dck)"));
        this.txtPlayerDeck.setText("");
        this.txtPlayerName.setText(ClientDefaultSettings.computerName);
    }

    public void setPlayerName(String playerName) {
        this.txtPlayerName.setText(playerName);
        this.txtPlayerName.setEditable(false);
        this.txtPlayerName.setEnabled(false);
    }

    protected void playerLoadDeck() {
        int ret;
        String lastFolder = MageFrame.getPreferences().get("lastDeckFolder", "");
        if (!lastFolder.isEmpty()) {
            this.fcSelectDeck.setCurrentDirectory(new File(lastFolder));
        }
        if ((ret = this.fcSelectDeck.showDialog(this, "Select Deck")) == 0) {
            File file = this.fcSelectDeck.getSelectedFile();
            this.txtPlayerDeck.setText(file.getPath());
            try {
                MageFrame.getPreferences().put("lastDeckFolder", file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fcSelectDeck.setSelectedFile(null);
    }

    protected void generateDeck() {
        String path = DeckGenerator.generateDeck();
        if (path == null) {
            return;
        }
        this.txtPlayerDeck.setText(path);
    }

    public String getPlayerName() {
        return this.txtPlayerName.getText();
    }

    public String getDeckFile() {
        return this.txtPlayerDeck.getText();
    }

    public void setDeckFile(String deckFile) {
        this.txtPlayerDeck.setText(deckFile);
    }

    public void setSkillLevel(int level) {
        this.spnLevel.setValue(level);
    }

    public int getSkillLevel() {
        return (Integer)this.spnLevel.getValue();
    }

    public void showLevel(boolean show) {
        this.spnLevel.setVisible(show);
        this.lblLevel.setVisible(show);
    }

    public void showDeckElements(boolean show) {
        this.lblPlayerDeck.setVisible(show);
        this.txtPlayerDeck.setVisible(show);
        this.btnGenerate.setVisible(show);
        this.btnPlayerDeck.setVisible(show);
    }

    private void initComponents() {
        this.lblPlayerName = new JLabel();
        this.txtPlayerName = new JTextField();
        this.lblPlayerDeck = new JLabel();
        this.txtPlayerDeck = new JTextField();
        this.btnPlayerDeck = new JButton();
        this.btnGenerate = new JButton();
        this.lblLevel = new JLabel();
        this.spnLevel = new JSpinner();
        this.lblPlayerName.setText("Name:");
        this.lblPlayerDeck.setText("Deck:");
        this.btnPlayerDeck.setText("...");
        this.btnPlayerDeck.addActionListener(evt -> this.btnPlayerDeckActionPerformed(evt));
        this.btnGenerate.setText("Generate");
        this.btnGenerate.addActionListener(evt -> this.btnGenerateActionPerformed(evt));
        this.lblLevel.setText("Skill:");
        this.spnLevel.setModel(new SpinnerNumberModel(2, 1, 10, 1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.lblPlayerDeck)).addComponent(this.lblPlayerName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtPlayerName, -1, 310, Short.MAX_VALUE).addComponent(this.txtPlayerDeck, -1, 310, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.btnPlayerDeck, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGenerate, -2, 87, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lblLevel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.spnLevel, -2, -1, -2).addGap(64, 64, 64)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPlayerName, -2, -1, -2).addComponent(this.lblPlayerName).addComponent(this.lblLevel).addComponent(this.spnLevel, -2, -1, -2)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPlayerDeck).addComponent(this.txtPlayerDeck, -2, -1, -2).addComponent(this.btnPlayerDeck, -2, 21, -2).addComponent(this.btnGenerate, -2, 21, -2))));
    }

    private void btnPlayerDeckActionPerformed(ActionEvent evt) {
        this.playerLoadDeck();
    }

    private void btnGenerateActionPerformed(ActionEvent evt) {
        this.generateDeck();
    }
}

