/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.UUID;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import mage.cards.decks.importer.DeckImporter;
import mage.client.SessionHandler;
import mage.client.table.NewPlayerPanel;
import mage.client.table.PlayerTypeEventSource;
import mage.client.util.ClientDefaultSettings;
import mage.client.util.Event;
import mage.client.util.Listener;
import mage.players.PlayerType;

public class TablePlayerPanel
extends JPanel {
    protected final PlayerTypeEventSource playerTypeEventSource = new PlayerTypeEventSource();
    private JComboBox cbPlayerType;
    private JLabel lbPlayerType;
    private JLabel lblPlayerNum;
    private NewPlayerPanel newPlayerPanel;

    public TablePlayerPanel() {
        this.initComponents();
        this.newPlayerPanel.setVisible(false);
    }

    public void init(int playerNum, PlayerType playerType, int playerSkill, String playerDeck) {
        this.cbPlayerType.setModel(new DefaultComboBoxModel<PlayerType>(SessionHandler.getPlayerTypes()));
        this.lblPlayerNum.setText("Player " + playerNum);
        if (ClientDefaultSettings.otherPlayerIndex != null) {
            Integer index = Integer.parseInt(ClientDefaultSettings.otherPlayerIndex);
            if (index >= this.cbPlayerType.getItemCount()) {
                this.cbPlayerType.setSelectedIndex(this.cbPlayerType.getItemCount() - 1);
            } else {
                this.cbPlayerType.setSelectedIndex(index);
            }
        }
        if (playerType != null) {
            this.cbPlayerType.setSelectedItem((Object)playerType);
        }
        this.newPlayerPanel.setDeckFile(playerDeck);
        this.newPlayerPanel.setSkillLevel(playerSkill);
    }

    public static String extractAiPlayerNumberFromLabel(String label) {
        return ClientDefaultSettings.computerName + " " + label.substring(Math.max(0, label.length() - 2)).trim();
    }

    public boolean joinTable(UUID roomId, UUID tableId) throws IOException, ClassNotFoundException {
        if (this.cbPlayerType.getSelectedItem() != PlayerType.HUMAN) {
            return SessionHandler.joinTable(roomId, tableId, this.newPlayerPanel.getPlayerName(), (PlayerType)((Object)this.cbPlayerType.getSelectedItem()), this.newPlayerPanel.getSkillLevel(), DeckImporter.importDeckFromFile(this.newPlayerPanel.getDeckFile(), true), "");
        }
        return true;
    }

    public PlayerType getPlayerType() {
        return PlayerType.getByDescription(this.cbPlayerType.getSelectedItem().toString());
    }

    public int getPlayerSkill() {
        return this.newPlayerPanel.getSkillLevel();
    }

    public String getPlayerDeck() {
        return this.newPlayerPanel.getDeckFile();
    }

    public void addPlayerTypeEventListener(Listener<Event> listener) {
        this.playerTypeEventSource.addListener(listener);
    }

    public void clearPlayerTypeEventListeners() {
        this.playerTypeEventSource.clearListeners();
    }

    private void initComponents() {
        this.lbPlayerType = new JLabel();
        this.cbPlayerType = new JComboBox();
        this.newPlayerPanel = new NewPlayerPanel();
        this.lblPlayerNum = new JLabel();
        this.lbPlayerType.setText("Type:");
        this.cbPlayerType.addActionListener(evt -> this.cbPlayerTypeActionPerformed(evt));
        this.lblPlayerNum.setFont(new Font("Tahoma", 1, 11));
        this.lblPlayerNum.setText("Player #");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPlayerNum).addGroup(layout.createSequentialGroup().addComponent(this.lbPlayerType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPlayerType, -2, 166, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newPlayerPanel, -1, 318, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblPlayerNum).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbPlayerType, -2, -1, -2).addComponent(this.lbPlayerType))).addComponent(this.newPlayerPanel, -1, 43, Short.MAX_VALUE)).addContainerGap()));
    }

    private void cbPlayerTypeActionPerformed(ActionEvent evt) {
        if (this.getPlayerType() != PlayerType.HUMAN) {
            this.newPlayerPanel.setVisible(true);
            this.newPlayerPanel.setPlayerName(TablePlayerPanel.extractAiPlayerNumberFromLabel(this.lblPlayerNum.getText()));
        } else {
            this.newPlayerPanel.setVisible(false);
        }
        this.revalidate();
        this.repaint();
        this.playerTypeEventSource.playerTypeChanged();
    }
}

