/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.util.UUID;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import mage.client.MagePane;
import mage.client.SessionHandler;
import mage.client.plugins.impl.Plugins;
import mage.client.table.TablesPanel;

public class TablesPane
extends MagePane {
    UUID roomId = null;
    private TablesPanel tablesPanel;

    public TablesPane() {
        boolean initialized = false;
        if (Plugins.instance.isThemePluginLoaded()) {
            this.tablesPanel = new TablesPanel();
            JComponent container = Plugins.instance.updateTablePanel(this.tablesPanel.getUIComponents());
            if (container != null) {
                this.initComponents(container);
                container.add(this.tablesPanel);
                container.setOpaque(false);
                initialized = true;
            }
        }
        if (!initialized) {
            this.initComponents();
        }
    }

    public void cleanUp() {
        this.tablesPanel.cleanUp();
    }

    @Override
    public void changeGUISize() {
        super.changeGUISize();
        this.tablesPanel.changeGUISize();
    }

    public void showTables() {
        UUID roomId = SessionHandler.getSession().getMainRoomId();
        if (roomId != null) {
            this.roomId = roomId;
            this.setTitle("Server's lobby");
            this.tablesPanel.showTables(roomId);
            this.repaint();
        }
    }

    @Override
    public boolean isActiveTable() {
        return false;
    }

    public void hideTables() {
        this.tablesPanel.hideTables();
    }

    public void clearChat() {
        this.tablesPanel.getChatPanel().clear();
    }

    private void initComponents() {
        this.tablesPanel = new TablesPanel();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablesPanel, -1, 541, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablesPanel, -1, 471, Short.MAX_VALUE));
    }

    private void initComponents(JComponent container) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(container, -1, 541, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(container, -1, 471, Short.MAX_VALUE));
    }

    @Override
    public void activated() {
        this.tablesPanel.startUpdateTasks(false);
    }

    @Override
    public void deactivated() {
        super.deactivated();
        this.tablesPanel.stopTasks();
    }

    public void setTableFilter() {
        if (this.tablesPanel != null) {
            this.tablesPanel.setTableFilter();
        }
    }

    @Override
    public UUID getSortTableId() {
        return null;
    }

    @Override
    public int getSortOrder() {
        return 0;
    }
}

