/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import javax.swing.JTable;
import mage.client.table.MatchesTableModel;
import mage.client.table.TablesTableModel;
import mage.client.table.TournamentMatchesTableModel;
import org.apache.log4j.Logger;

public class TablesUtil {
    private static final Logger logger = Logger.getLogger(TablesUtil.class);

    public static String getSearchIdFromTable(JTable table, int row) {
        String searchId = null;
        if (table.getModel() instanceof TablesTableModel) {
            searchId = ((TablesTableModel)table.getModel()).findTableAndGameInfoByRow(row);
        } else if (table.getModel() instanceof MatchesTableModel) {
            searchId = ((MatchesTableModel)table.getModel()).findTableAndGameInfoByRow(row);
        } else if (table.getModel() instanceof TournamentMatchesTableModel) {
            searchId = ((TournamentMatchesTableModel)table.getModel()).findTableAndGameInfoByRow(row);
        } else {
            logger.error((Object)("Not supported tables model " + table.getModel().getClass().toString()));
        }
        return searchId;
    }

    public static int findTableRowFromSearchId(Object tableModel, String searchId) {
        int row = -1;
        if (searchId != null) {
            if (tableModel instanceof TablesTableModel) {
                row = ((TablesTableModel)tableModel).findRowByTableAndGameInfo(searchId);
            } else if (tableModel instanceof MatchesTableModel) {
                row = ((MatchesTableModel)tableModel).findRowByTableAndGameInfo(searchId);
            } else if (tableModel instanceof TournamentMatchesTableModel) {
                row = ((TournamentMatchesTableModel)tableModel).findRowByTableAndGameInfo(searchId);
            } else {
                logger.error((Object)("Not supported tables model " + tableModel.getClass().toString()));
            }
        }
        return row;
    }
}

