/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import mage.view.RoundView;
import mage.view.TournamentGameView;
import mage.view.TournamentView;

public class TournamentMatchesTableModel
extends AbstractTableModel {
    public static final int ACTION_COLUMN = 4;
    private final String[] columnNames = new String[]{"Round Number", "Players", "State", "Result", "Action"};
    private TournamentGameView[] games = new TournamentGameView[0];
    private boolean watchingAllowed;

    public void loadData(TournamentView tournament) {
        ArrayList views = new ArrayList();
        this.watchingAllowed = tournament.isWatchingAllowed();
        for (RoundView round : tournament.getRounds()) {
            views.addAll(round.getGames());
        }
        this.games = views.toArray(new TournamentGameView[0]);
        this.fireTableDataChanged();
    }

    public String getTableAndGameInfo(int row) {
        return this.games[row].getTableId().toString() + ";" + this.games[row].toString();
    }

    public String findTableAndGameInfoByRow(int row) {
        if (row >= 0 && row < this.games.length) {
            return this.getTableAndGameInfo(row);
        }
        return null;
    }

    public int findRowByTableAndGameInfo(String tableAndGame) {
        for (int i = 0; i < this.games.length; ++i) {
            String rowID = this.games[i].getTableId().toString() + ";" + this.games[i].toString();
            if (!tableAndGame.equals(rowID)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        return this.games.length;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        switch (arg1) {
            case 0: {
                return Integer.toString(this.games[arg0].getRoundNum());
            }
            case 1: {
                return this.games[arg0].getPlayers();
            }
            case 2: {
                return this.games[arg0].getState();
            }
            case 3: {
                return this.games[arg0].getResult();
            }
            case 4: {
                if (this.watchingAllowed && this.games[arg0].getState().startsWith("Dueling")) {
                    return "Watch";
                }
                return "";
            }
            case 5: {
                return this.games[arg0].getTableId().toString();
            }
            case 6: {
                return this.games[arg0].getMatchId().toString();
            }
            case 7: {
                return this.games[arg0].getGameId().toString();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int columnIndex) {
        String colName = "";
        if (columnIndex <= this.getColumnCount()) {
            colName = this.columnNames[columnIndex];
        }
        return colName;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 4;
    }
}

