/*
 * Decompiled with CFR 0.152.
 */
package mage.client.tournament;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.Optional;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.chat.ChatPanelBasic;
import mage.client.dialog.PreferencesDialog;
import mage.client.table.TablesButtonColumn;
import mage.client.table.TablesUtil;
import mage.client.table.TournamentMatchesTableModel;
import mage.client.tournament.TournamentPane;
import mage.client.tournament.TournamentPlayersTableModel;
import mage.client.tournament.UpdateTournamentTask;
import mage.client.util.Format;
import mage.client.util.GUISizeHelper;
import mage.client.util.gui.TableUtil;
import mage.client.util.gui.countryBox.CountryCellRenderer;
import mage.constants.PlayerAction;
import mage.view.TournamentPlayerView;
import mage.view.TournamentView;
import mage.view.UserRequestMessage;
import org.apache.log4j.Logger;

public class TournamentPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(TournamentPanel.class);
    private static final int[] DEFAULT_COLUMNS_WIDTH_PLAYERS = new int[]{30, 150, 150, 60, 400, 100};
    private static final int[] DEFAULT_COLUMNS_WIDTH_MATCHES = new int[]{60, 140, 140, 400, 80};
    private UUID tournamentId;
    private boolean firstInitDone = false;
    private final TournamentPlayersTableModel playersModel = new TournamentPlayersTableModel();
    private final TournamentMatchesTableModel matchesModel = new TournamentMatchesTableModel();
    private UpdateTournamentTask updateTask;
    private final DateFormat df;
    private final TablesButtonColumn actionButtonColumn1;
    private JPanel actionPanel;
    private JButton btnCloseWindow;
    private JButton btnQuitTournament;
    private ChatPanelBasic chatPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JLabel lblEndTime;
    private JLabel lblName;
    private JLabel lblStartTime;
    private JLabel lblState;
    private JLabel lblType;
    private JTable tableMatches;
    private JTable tablePlayers;
    private JTextField txtEndTime;
    private JTextField txtName;
    private JTextField txtStartTime;
    private JTextField txtTournamentState;
    private JTextField txtType;

    public TournamentPanel() {
        this.initComponents();
        this.restoreDividerLocations();
        this.btnQuitTournament.setVisible(false);
        this.df = DateFormat.getDateTimeInstance();
        this.tablePlayers.createDefaultColumnsFromModel();
        TableUtil.setColumnWidthAndOrder(this.tablePlayers, DEFAULT_COLUMNS_WIDTH_PLAYERS, "tournamentPlayerPanelColumnWidth", "tournamentPlayerPanelColumnSort");
        this.tablePlayers.setDefaultRenderer(Icon.class, new CountryCellRenderer());
        this.tableMatches.createDefaultColumnsFromModel();
        TableUtil.setColumnWidthAndOrder(this.tableMatches, DEFAULT_COLUMNS_WIDTH_MATCHES, "tournamentMatchPanelColumnWidth", "tournamentMatchPanelColumnSort");
        this.chatPanel1.useExtendedView(ChatPanelBasic.VIEW_MODE.NONE);
        this.chatPanel1.setChatType(ChatPanelBasic.ChatType.TOURNAMENT);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String searchID = e.getActionCommand();
                int modelRow = TablesUtil.findTableRowFromSearchId(TournamentPanel.this.matchesModel, searchID);
                if (modelRow == -1) {
                    return;
                }
                String state = (String)TournamentPanel.this.tableMatches.getValueAt(modelRow, TournamentPanel.this.tableMatches.convertColumnIndexToView(2));
                String actionText = (String)TournamentPanel.this.tableMatches.getValueAt(modelRow, TournamentPanel.this.tableMatches.convertColumnIndexToView(4));
                UUID tableId = UUID.fromString((String)TournamentPanel.this.matchesModel.getValueAt(modelRow, 5));
                UUID gameId = UUID.fromString((String)TournamentPanel.this.matchesModel.getValueAt(modelRow, 7));
                if (state.startsWith("Dueling") && actionText.equals("Watch")) {
                    LOGGER.info((Object)("Watching game " + gameId));
                    SessionHandler.watchTournamentTable(tableId);
                }
            }
        };
        this.actionButtonColumn1 = new TablesButtonColumn(this.tableMatches, action, this.tableMatches.convertColumnIndexToView(4));
        this.setGUISize();
    }

    public void cleanUp() {
        this.stopTasks();
        if (this.chatPanel1 != null) {
            this.chatPanel1.cleanUp();
        }
    }

    public void changeGUISize() {
        this.setGUISize();
    }

    private void setGUISize() {
        this.tablePlayers.getTableHeader().setFont(GUISizeHelper.tableFont);
        this.tablePlayers.setFont(GUISizeHelper.tableFont);
        this.tablePlayers.setRowHeight(GUISizeHelper.tableRowHeight);
        this.tableMatches.getTableHeader().setFont(GUISizeHelper.tableFont);
        this.tableMatches.setFont(GUISizeHelper.tableFont);
        this.tableMatches.setRowHeight(GUISizeHelper.tableRowHeight);
        this.jSplitPane1.setDividerSize(GUISizeHelper.dividerBarSize);
        this.jSplitPane2.setDividerSize(GUISizeHelper.dividerBarSize);
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(GUISizeHelper.scrollBarSize, 0));
        this.jScrollPane1.getHorizontalScrollBar().setPreferredSize(new Dimension(0, GUISizeHelper.scrollBarSize));
        this.jScrollPane2.getVerticalScrollBar().setPreferredSize(new Dimension(GUISizeHelper.scrollBarSize, 0));
        this.jScrollPane2.getHorizontalScrollBar().setPreferredSize(new Dimension(0, GUISizeHelper.scrollBarSize));
        this.actionButtonColumn1.changeGUISize();
    }

    private void saveDividerLocations() {
        Rectangle rec = MageFrame.getDesktop().getBounds();
        String sb = Double.toString(rec.getWidth()) + 'x' + rec.getHeight();
        PreferencesDialog.saveValue("gamepanelLastSize", sb);
        PreferencesDialog.saveValue("tournamentPanelDividerLocation1", Integer.toString(this.jSplitPane1.getDividerLocation()));
        PreferencesDialog.saveValue("tournamentPanelDividerLocation2", Integer.toString(this.jSplitPane2.getDividerLocation()));
    }

    private void restoreDividerLocations() {
        Rectangle rec = MageFrame.getDesktop().getBounds();
        if (rec != null) {
            String size = PreferencesDialog.getCachedValue("gamepanelLastSize", null);
            String sb = Double.toString(rec.getWidth()) + 'x' + rec.getHeight();
            if (size != null && size.equals(sb)) {
                String location = PreferencesDialog.getCachedValue("tournamentPanelDividerLocation1", null);
                if (location != null && this.jSplitPane1 != null) {
                    this.jSplitPane1.setDividerLocation(Integer.parseInt(location));
                }
                if ((location = PreferencesDialog.getCachedValue("tournamentPanelDividerLocation2", null)) != null && this.jSplitPane2 != null) {
                    this.jSplitPane2.setDividerLocation(Integer.parseInt(location));
                }
            }
        }
    }

    public synchronized void showTournament(UUID tournamentId) {
        this.tournamentId = tournamentId;
        Optional<UUID> chatRoomId = SessionHandler.getTournamentChatId(tournamentId);
        if (SessionHandler.joinTournament(tournamentId) && chatRoomId.isPresent()) {
            this.chatPanel1.connect(chatRoomId.get());
            this.startTasks();
            this.setVisible(true);
            this.repaint();
        } else {
            this.hideTournament();
        }
    }

    public UUID getTournamentId() {
        return this.tournamentId;
    }

    public void hideTournament() {
        Container c;
        this.stopTasks();
        if (this.chatPanel1 != null) {
            this.chatPanel1.cleanUp();
        }
        this.saveDividerLocations();
        TableUtil.saveColumnWidthAndOrderToPrefs(this.tablePlayers, "tournamentPlayerPanelColumnWidth", "tournamentPlayerPanelColumnSort");
        TableUtil.saveColumnWidthAndOrderToPrefs(this.tableMatches, "tournamentMatchPanelColumnWidth", "tournamentMatchPanelColumnSort");
        for (c = this.getParent(); c != null && !(c instanceof TournamentPane); c = c.getParent()) {
        }
        if (c != null) {
            ((TournamentPane)c).removeTournament();
        }
    }

    public void update(TournamentView tournament) {
        if (tournament == null) {
            return;
        }
        if (!this.firstInitDone) {
            Container c;
            for (c = this.getParent(); c != null && !(c instanceof TournamentPane); c = c.getParent()) {
            }
            if (c != null) {
                ((TournamentPane)c).setTitle("Tournament [" + tournament.getTournamentName() + ']');
            }
            this.txtName.setText(tournament.getTournamentName());
            this.txtType.setText(tournament.getTournamentType());
            this.txtStartTime.setText(this.df.format(tournament.getStartTime()));
            this.txtEndTime.setText("running...");
            this.firstInitDone = true;
        }
        switch (tournament.getTournamentState()) {
            case "Constructing": {
                String timeLeft = "";
                if (tournament.getStepStartTime() != null) {
                    timeLeft = Format.getDuration((long)tournament.getConstructionTime() - (tournament.getServerTime().getTime() - tournament.getStepStartTime().getTime()) / 1000L);
                }
                this.txtTournamentState.setText(tournament.getTournamentState() + " (" + timeLeft + ')');
                break;
            }
            case "Dueling": 
            case "Drafting": {
                String usedTime = "";
                if (tournament.getStepStartTime() != null) {
                    usedTime = Format.getDuration((tournament.getServerTime().getTime() - tournament.getStepStartTime().getTime()) / 1000L);
                }
                this.txtTournamentState.setText(tournament.getTournamentState() + " (" + usedTime + ")");
                break;
            }
            default: {
                this.txtTournamentState.setText(tournament.getTournamentState());
            }
        }
        if (!tournament.getRunningInfo().isEmpty()) {
            this.txtTournamentState.setText(this.txtTournamentState.getText() + ", " + tournament.getRunningInfo());
        }
        if (this.txtEndTime == null) {
            return;
        }
        if (this.txtEndTime.getText().equals("running...") && tournament.getEndTime() != null) {
            this.txtEndTime.setText(this.df.format(tournament.getEndTime()));
        }
        this.playersModel.loadData(tournament);
        this.matchesModel.loadData(tournament);
        this.tablePlayers.repaint();
        this.tableMatches.repaint();
        this.btnQuitTournament.setVisible(false);
        if (tournament.getEndTime() == null) {
            for (TournamentPlayerView player : tournament.getPlayers()) {
                if (!player.getName().equals(SessionHandler.getUserName())) continue;
                if (player.hasQuit()) break;
                this.btnQuitTournament.setVisible(true);
                break;
            }
        }
    }

    public void startTasks() {
        if (SessionHandler.getSession() != null && (this.updateTask == null || this.updateTask.isDone())) {
            this.updateTask = new UpdateTournamentTask(this.tournamentId, this);
            this.updateTask.execute();
        }
    }

    public void stopTasks() {
        if (this.updateTask != null) {
            this.updateTask.cancel(true);
        }
    }

    private void initComponents() {
        this.actionPanel = new JPanel();
        this.txtName = new JTextField();
        this.txtType = new JTextField();
        this.txtStartTime = new JTextField();
        this.txtEndTime = new JTextField();
        this.txtTournamentState = new JTextField();
        this.btnQuitTournament = new JButton();
        this.btnCloseWindow = new JButton();
        this.lblName = new JLabel();
        this.lblType = new JLabel();
        this.lblState = new JLabel();
        this.lblStartTime = new JLabel();
        this.lblEndTime = new JLabel();
        this.jSplitPane2 = new JSplitPane();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.tablePlayers = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.tableMatches = new JTable();
        this.chatPanel1 = new ChatPanelBasic();
        this.setPreferredSize(new Dimension(908, 580));
        this.actionPanel.setFont(new Font("Arial", 0, 10));
        this.txtName.setEditable(false);
        this.txtName.setHorizontalAlignment(2);
        this.txtName.setBorder(BorderFactory.createEtchedBorder());
        this.txtName.setFocusable(false);
        this.txtName.setMaximumSize(new Dimension(50, 22));
        this.txtName.setOpaque(false);
        this.txtName.setRequestFocusEnabled(false);
        this.txtName.addActionListener(evt -> this.txtNameActionPerformed(evt));
        this.txtType.setEditable(false);
        this.txtType.setHorizontalAlignment(2);
        this.txtType.setBorder(BorderFactory.createEtchedBorder());
        this.txtType.setFocusable(false);
        this.txtType.setOpaque(false);
        this.txtType.setRequestFocusEnabled(false);
        this.txtStartTime.setEditable(false);
        this.txtStartTime.setHorizontalAlignment(0);
        this.txtStartTime.setBorder(BorderFactory.createEtchedBorder());
        this.txtStartTime.setFocusable(false);
        this.txtStartTime.setOpaque(false);
        this.txtStartTime.setRequestFocusEnabled(false);
        this.txtEndTime.setEditable(false);
        this.txtEndTime.setHorizontalAlignment(0);
        this.txtEndTime.setBorder(BorderFactory.createEtchedBorder());
        this.txtEndTime.setFocusable(false);
        this.txtEndTime.setOpaque(false);
        this.txtEndTime.setRequestFocusEnabled(false);
        this.txtTournamentState.setEditable(false);
        this.txtTournamentState.setHorizontalAlignment(0);
        this.txtTournamentState.setBorder(BorderFactory.createEtchedBorder());
        this.txtTournamentState.setFocusable(false);
        this.txtTournamentState.setOpaque(false);
        this.txtTournamentState.setRequestFocusEnabled(false);
        this.btnQuitTournament.setText("Quit Tournament");
        this.btnQuitTournament.setHorizontalTextPosition(0);
        this.btnQuitTournament.addActionListener(evt -> this.btnQuitTournamentActionPerformed(evt));
        this.btnCloseWindow.setText("Close Window");
        this.btnCloseWindow.setHorizontalTextPosition(0);
        this.btnCloseWindow.addActionListener(evt -> this.btnCloseWindowActionPerformed(evt));
        this.lblName.setFont(new Font("Tahoma", 0, 10));
        this.lblName.setText("Name:");
        this.lblType.setFont(new Font("Tahoma", 0, 10));
        this.lblType.setText("Type:");
        this.lblState.setFont(new Font("Tahoma", 0, 10));
        this.lblState.setText("State:");
        this.lblStartTime.setFont(new Font("Tahoma", 0, 10));
        this.lblStartTime.setText("Start time:");
        this.lblEndTime.setFont(new Font("Tahoma", 0, 10));
        this.lblEndTime.setText("End time:");
        GroupLayout actionPanelLayout = new GroupLayout(this.actionPanel);
        this.actionPanel.setLayout(actionPanelLayout);
        actionPanelLayout.setHorizontalGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(actionPanelLayout.createSequentialGroup().addContainerGap().addGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblName).addComponent(this.lblState).addComponent(this.txtName, -1, 260, Short.MAX_VALUE).addComponent(this.txtTournamentState)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblType).addComponent(this.txtType, -2, 440, -2).addGroup(actionPanelLayout.createSequentialGroup().addGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtStartTime, -2, 220, -2).addComponent(this.lblStartTime)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblEndTime).addComponent(this.txtEndTime)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 126, Short.MAX_VALUE).addGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnQuitTournament, -1, -1, Short.MAX_VALUE).addComponent(this.btnCloseWindow, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        actionPanelLayout.setVerticalGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(actionPanelLayout.createSequentialGroup().addGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(actionPanelLayout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.lblName)).addGroup(GroupLayout.Alignment.TRAILING, actionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lblType))).addGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(actionPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtType, -2, -1, -2).addComponent(this.btnQuitTournament)).addGap(13, 13, 13).addComponent(this.btnCloseWindow)).addGroup(actionPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.txtName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblState).addComponent(this.lblStartTime).addComponent(this.lblEndTime)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(actionPanelLayout.createSequentialGroup().addComponent(this.txtTournamentState, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtStartTime).addComponent(this.txtEndTime, -2, -1, -2))))).addContainerGap()));
        this.jSplitPane2.setResizeWeight(1.0);
        this.jSplitPane1.setDividerLocation(230);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jScrollPane1.setCursor(new Cursor(0));
        this.jScrollPane1.setPreferredSize(new Dimension(400, 100));
        this.tablePlayers.setModel(this.playersModel);
        this.jScrollPane1.setViewportView(this.tablePlayers);
        this.jSplitPane1.setTopComponent(this.jScrollPane1);
        this.jScrollPane2.setPreferredSize(new Dimension(400, 100));
        this.tableMatches.setModel(this.matchesModel);
        this.jScrollPane2.setViewportView(this.tableMatches);
        this.jSplitPane1.setBottomComponent(this.jScrollPane2);
        this.jSplitPane2.setLeftComponent(this.jSplitPane1);
        this.jSplitPane2.setRightComponent(this.chatPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.actionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane2, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.actionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane2, -1, 454, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnCloseWindowActionPerformed(ActionEvent evt) {
        this.hideTournament();
    }

    private void btnQuitTournamentActionPerformed(ActionEvent evt) {
        UserRequestMessage message = new UserRequestMessage("Confirm quit tournament", "Are you sure you want to quit the tournament?");
        message.setButton1("No", null);
        message.setButton2("Yes", PlayerAction.CLIENT_QUIT_TOURNAMENT);
        message.setTournamentId(this.tournamentId);
        MageFrame.getInstance().showUserRequestDialog(message);
    }

    private void txtNameActionPerformed(ActionEvent evt) {
    }
}

