/*
 * Decompiled with CFR 0.152.
 */
package mage.client.tournament;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import mage.client.SessionHandler;
import mage.client.tournament.TournamentPanel;
import mage.view.TournamentView;
import org.apache.log4j.Logger;

class UpdateTournamentTask
extends SwingWorker<Void, TournamentView> {
    private final UUID tournamentId;
    private final TournamentPanel panel;
    private static final Logger logger = Logger.getLogger(UpdateTournamentTask.class);

    UpdateTournamentTask(UUID tournamentId, TournamentPanel panel) {
        this.tournamentId = tournamentId;
        this.panel = panel;
    }

    @Override
    protected Void doInBackground() throws Exception {
        while (!this.isCancelled()) {
            this.publish(SessionHandler.getTournament(this.tournamentId));
            TimeUnit.SECONDS.sleep(2L);
        }
        return null;
    }

    @Override
    protected void process(List<TournamentView> view) {
        if (view != null && !view.isEmpty()) {
            this.panel.update(view.get(0));
        }
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.fatal((Object)"Update Tournament Task error", (Throwable)ex);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }
}

