/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import java.awt.Desktop;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import mage.client.MageFrame;
import org.apache.log4j.Logger;

public class AppUtil {
    private static final Logger logger = Logger.getLogger(AppUtil.class);

    public static boolean isAppActive() {
        return MageFrame.getInstance().isActive();
    }

    public static boolean isGameActive(UUID gameId) {
        return MageFrame.getInstance().isGameFrameActive(gameId);
    }

    public static void setClipboardData(String text) {
        try {
            StringSelection data = new StringSelection(text);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(data, data);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
    }

    public static void openUrlInSystemBrowser(String url) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                URI uri = new URI(url);
                desktop.browse(uri);
            }
            catch (IOException | URISyntaxException e) {
                logger.error((Object)("Can't open url in browser: " + url), (Throwable)e);
            }
        } else {
            logger.error((Object)"Can't open url in browser: non supported desktop mode");
        }
    }
}

