/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import java.util.ArrayList;

public enum CardLanguage {
    ENGLISH("en", "English"),
    SPANISH("es", "Spanish"),
    FRENCH("fr", "French"),
    GERMAN("de", "German"),
    ITALIAN("it", "Italian"),
    PORTUGUESE("pt", "Portuguese"),
    JAPANESE("jp", "Japanese"),
    KOREAN("ko", "Korean"),
    RUSSIAN("ru", "Russian"),
    CHINES_SIMPLE("cns", "Chinese Simplified"),
    CHINES_TRADITION("cnt", "Chinese Traditional");

    private final String code;
    private final String text;

    private CardLanguage(String code, String text) {
        this.code = code;
        this.text = text;
    }

    public String toString() {
        return this.code;
    }

    public String getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public static String[] toList() {
        ArrayList<String> res = new ArrayList<String>();
        for (CardLanguage l : CardLanguage.values()) {
            res.add(l.toString());
        }
        return res.toArray(new String[0]);
    }

    public static CardLanguage valueByText(String text) {
        for (CardLanguage type : CardLanguage.values()) {
            if (!type.text.equals(text)) continue;
            return type;
        }
        return ENGLISH;
    }

    public static CardLanguage valueByCode(String code) {
        for (CardLanguage type : CardLanguage.values()) {
            if (!type.code.equals(code)) continue;
            return type;
        }
        return ENGLISH;
    }
}

