/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import java.util.ArrayList;

public enum CardRenderMode {
    MTGO("MTGO", 0),
    IMAGE("Image", 1),
    FORCED_M15("Forced M15", 2),
    FORCED_RETRO("Forced Retro", 3);

    private final String text;
    private final int id;

    private CardRenderMode(String text, int id) {
        this.text = text;
        this.id = id;
    }

    public String toString() {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public int getId() {
        return this.id;
    }

    public static String[] toList() {
        ArrayList<String> list = new ArrayList<String>();
        for (CardRenderMode mode : CardRenderMode.values()) {
            list.add(mode.toString());
        }
        return list.toArray(new String[0]);
    }

    public static CardRenderMode fromId(int id) {
        for (CardRenderMode mode : CardRenderMode.values()) {
            if (mode.getId() != id) continue;
            return mode;
        }
        return MTGO;
    }

    public static CardRenderMode fromString(String text) {
        for (CardRenderMode mode : CardRenderMode.values()) {
            if (!mode.text.equals(text)) continue;
            return mode;
        }
        return MTGO;
    }
}

