/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import mage.client.util.ClientEventType;

public class Event
implements Serializable {
    private final Object source;
    private final Component component;
    private final ClientEventType eventType;
    private final int number;
    private final int xPos;
    private final int yPos;
    private final MouseEvent mouseEvent;
    private final boolean mouseAltDown;

    public Event(Object source, ClientEventType eventType) {
        this(source, eventType, 0);
    }

    public Event(Object source, ClientEventType eventType, int number) {
        this(source, eventType, number, 0, 0, null);
    }

    public Event(Object source, ClientEventType eventType, int number, int xPos, int yPos, Component component) {
        this(source, eventType, number, xPos, yPos, component, null, false);
    }

    public Event(Object source, ClientEventType eventType, int number, int xPos, int yPos, Component component, MouseEvent mouseEvent, boolean mouseAltDown) {
        this.source = source;
        this.eventType = eventType;
        this.number = number;
        this.xPos = xPos;
        this.yPos = yPos;
        this.component = component;
        this.mouseEvent = mouseEvent;
        this.mouseAltDown = mouseAltDown;
    }

    public Object getSource() {
        return this.source;
    }

    public ClientEventType getEventType() {
        return this.eventType;
    }

    public int getNumber() {
        return this.number;
    }

    public int getxPos() {
        return this.xPos;
    }

    public int getyPos() {
        return this.yPos;
    }

    public Component getComponent() {
        return this.component;
    }

    public MouseEvent getMouseEvent() {
        if (this.mouseEvent == null) {
            throw new IllegalArgumentException("Error, found empty mouse event.");
        }
        return this.mouseEvent;
    }

    public boolean isMouseAltDown() {
        if (this.mouseEvent != null) {
            return this.mouseEvent.isAltDown();
        }
        return this.mouseAltDown;
    }
}

