/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.lang.reflect.Field;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import mage.client.MageFrame;
import mage.client.dialog.PreferencesDialog;
import mage.client.util.gui.GuiDisplayUtil;
import org.mage.card.arcane.CardRenderer;

public final class GUISizeHelper {
    static final int CARD_IMAGE_WIDTH = 312;
    static final int CARD_IMAGE_HEIGHT = 445;
    static final int CARD_IMAG_VALUE = 42;
    public static final float CARD_WIDTH_TO_HEIGHT_COEF = 1.426282f;
    public static final float CARD_HEIGHT_TO_WIDTH_COEF = 0.7011236f;
    public static String basicSymbolSize = "small";
    static final int MIN_FONT_SIZE = 7;
    public static int symbolCardSize = 15;
    public static int symbolTableSize = 15;
    public static int symbolChatSize = 15;
    public static int symbolDialogSize = 15;
    public static int symbolTooltipSize = 15;
    public static int symbolPaySize = 15;
    public static int symbolEditorSize = 15;
    public static int tableHeaderHeight = 24;
    public static int tableRowHeight = 20;
    public static int dividerBarSize;
    public static int scrollBarSize;
    public static int tableFlagHeight;
    public static Font chatFont;
    public static Font tableFont;
    public static Font dialogFont;
    public static Font cardTooltipFont;
    public static int gameFeedbackPanelMainMessageFontSize;
    public static int gameFeedbackPanelExtraMessageFontSize;
    public static int gameFeedbackPanelMaxHeight;
    public static int gamePhaseButtonSize;
    public static int gameCommandButtonHeight;
    public static Font gameFeedbackPanelFont;
    public static int gameFeedbackPanelButtonHeight;
    public static int gameFeedbackPanelButtonWidth;
    public static Dimension handCardDimension;
    public static float playerPanelGuiScale;
    public static float dialogGuiScale;
    public static Dimension otherZonesCardDimension;
    public static int otherZonesCardVerticalOffset;
    public static Dimension battlefieldCardMinDimension;
    public static Dimension battlefieldCardMaxDimension;
    public static Dimension editorCardDimension;
    public static int editorCardVertOffsetInStack;
    public static int cardTooltipLargeImageHeight;
    public static int cardTooltipLargeTextHeight;
    public static int cardTooltipLargeTextWidth;

    public static Font getCardFont() {
        return new Font("Arial", 0, 14);
    }

    public static void refreshGUIAndCards(boolean reloadTheme) {
        GUISizeHelper.calculateGUISizes();
        if (reloadTheme) {
            GuiDisplayUtil.refreshThemeSettings();
        }
        if (MageFrame.getInstance() != null) {
            MageFrame.getInstance().refreshGUIAndCards();
        }
    }

    public static void calculateGUISizes() {
        int dialogFontSize = PreferencesDialog.getCachedValue("guiDialogFontSize", 14);
        dialogFont = new Font("Arial", 0, dialogFontSize);
        symbolDialogSize = dialogFontSize;
        dialogGuiScale = (float)dialogFontSize / 14.0f;
        UIManager.put("InternalFrame.titleFont", new FontUIResource(dialogFont.deriveFont(1, Math.min(17.0f, 0.8f * (float)dialogFont.getSize()))));
        tableFont = new Font("Arial", 0, dialogFontSize);
        tableRowHeight = dialogFontSize + 4;
        tableHeaderHeight = dialogFontSize + 10;
        symbolTableSize = dialogFontSize;
        tableFlagHeight = dialogFontSize - 2;
        if (dialogFontSize > 15) {
            symbolEditorSize = dialogFontSize - 5;
            dividerBarSize = 10 + dialogFontSize / 4;
            scrollBarSize = 14 + dialogFontSize / 4;
        } else {
            symbolEditorSize = dialogFontSize;
            dividerBarSize = 10;
            scrollBarSize = 14;
        }
        gameFeedbackPanelFont = new Font("Arial", 0, dialogFontSize);
        gameFeedbackPanelMainMessageFontSize = dialogFontSize;
        gameFeedbackPanelExtraMessageFontSize = Math.max(7, dialogFontSize / 2 + 2);
        gameFeedbackPanelMaxHeight = 20 + 2 * gameFeedbackPanelMainMessageFontSize + 2 * gameFeedbackPanelExtraMessageFontSize;
        gameFeedbackPanelButtonHeight = dialogFontSize + 6;
        gameFeedbackPanelButtonWidth = dialogFontSize * 2 + 40;
        gamePhaseButtonSize = GUISizeHelper.dialogGuiScaleSize(36);
        gameCommandButtonHeight = GUISizeHelper.dialogGuiScaleSize(32);
        int chatFontSize = PreferencesDialog.getCachedValue("guiChatFontSize", 14);
        chatFont = new Font("Arial", 0, chatFontSize);
        symbolChatSize = chatFontSize;
        int tooltipFontSize = PreferencesDialog.getCachedValue("guiTooltipSize", 17);
        cardTooltipFont = new Font("Arial", 0, tooltipFontSize);
        symbolTooltipSize = tooltipFontSize;
        cardTooltipLargeImageHeight = 30 * tooltipFontSize;
        cardTooltipLargeTextWidth = Math.max(150, 20 * tooltipFontSize - 50);
        cardTooltipLargeTextHeight = Math.max(100, 12 * tooltipFontSize - 20);
        UIManager.put("ToolTip.font", new FontUIResource(cardTooltipFont));
        playerPanelGuiScale = (float)((double)PreferencesDialog.getCachedValue("guiPlayerPanelSize", 14) / 14.0);
        int handCardSize = PreferencesDialog.getCachedValue("guiCardHandSize", 14);
        handCardDimension = new Dimension(312 * handCardSize / 42, 445 * handCardSize / 42);
        int otherZonesCardSize = PreferencesDialog.getCachedValue("guiCardOtherZonesSize", 14);
        otherZonesCardDimension = new Dimension(312 * otherZonesCardSize / 42, 445 * otherZonesCardSize / 42);
        otherZonesCardVerticalOffset = PreferencesDialog.getRenderMode() == 0 ? CardRenderer.getCardTopHeight(GUISizeHelper.otherZonesCardDimension.width) : (otherZonesCardSize > 29 ? GUISizeHelper.otherZonesCardDimension.height / 8 : GUISizeHelper.otherZonesCardDimension.height / 10);
        int battlefieldCardAvgSize = PreferencesDialog.getCachedValue("guiCardBattlefieldSize", 14);
        int battlefieldMinSize = GUISizeHelper.guiSizeScale(battlefieldCardAvgSize, 0.5f);
        int battlefieldMaxSize = GUISizeHelper.guiSizeScale(battlefieldCardAvgSize, 1.5f);
        battlefieldCardMinDimension = new Dimension(312 * battlefieldMinSize / 42, 445 * battlefieldMinSize / 42);
        battlefieldCardMaxDimension = new Dimension(312 * battlefieldMaxSize / 42, 445 * battlefieldMaxSize / 42);
        int editorCardSize = PreferencesDialog.getCachedValue("guiCardEditorSize", 14);
        editorCardDimension = new Dimension(312 * editorCardSize / 42, 445 * editorCardSize / 42);
        editorCardVertOffsetInStack = PreferencesDialog.getCachedValue("cardRenderingMode", "false").equals("false") ? CardRenderer.getCardTopHeight(GUISizeHelper.editorCardDimension.width) : Math.round(1.3f * (float)GUISizeHelper.getImageRendererTitleFontSize(GUISizeHelper.editorCardDimension.height));
    }

    public static int getImageRendererMainFontSize(int cardHeight) {
        return cardHeight / 13;
    }

    public static int getImageRendererTitleFontSize(int cardHeight) {
        return Math.max(13, GUISizeHelper.getImageRendererMainFontSize(cardHeight));
    }

    public static void changePopupMenuFont(JPopupMenu popupMenu) {
        for (Component comp : popupMenu.getComponents()) {
            if (!(comp instanceof JMenuItem)) continue;
            comp.setFont(dialogFont);
            if (!(comp instanceof JMenu)) continue;
            comp.setFont(dialogFont);
            for (Component subComp : ((JMenu)comp).getMenuComponents()) {
                subComp.setFont(dialogFont);
            }
        }
    }

    public static int getCardsScrollbarUnitInc(int cardSize) {
        return Math.max(8, cardSize / 4);
    }

    public static int guiSizeScale(int value, float scaleMod) {
        if (value == 0) {
            return 0;
        }
        if (value < 0) {
            return Math.min(-1, Math.round((float)value * scaleMod));
        }
        return Math.max(1, Math.round((float)value * scaleMod));
    }

    public static float guiSizeScale(float value, float scaleMod) {
        return value * scaleMod;
    }

    public static int dialogGuiScaleSize(int value) {
        return GUISizeHelper.guiSizeScale(value, dialogGuiScale);
    }

    public static Dimension dialogGuiScaleSize(Dimension dimension) {
        return new Dimension(GUISizeHelper.dialogGuiScaleSize(dimension.width), GUISizeHelper.dialogGuiScaleSize(dimension.height));
    }

    public static String textToHtmlWithSize(String text, Font font) {
        return GUISizeHelper.textToHtmlWithSize(text, font.getSize());
    }

    public static String textToHtmlWithSize(String text, int fontSize) {
        if (text != null && !text.toLowerCase(Locale.ENGLISH).startsWith("<html>")) {
            return "<html><p style=\"font-size: " + fontSize + "pt;\">" + text + "</p>";
        }
        return text;
    }

    public static <T extends Component> T getComponentByFieldName(Window dialog, String name) {
        for (Field field : dialog.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                if (!name.equals(field.getName())) continue;
                Object potentialMatch = field.get(dialog);
                return (T)((Component)potentialMatch);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        chatFont = new Font("Arial", 0, 12);
        tableFont = new Font("Arial", 0, 12);
        dialogFont = new Font("Arial", 0, 12);
        cardTooltipFont = new Font("Arial", 0, 12);
        gameFeedbackPanelMainMessageFontSize = 16;
        gameFeedbackPanelExtraMessageFontSize = 11;
        gameFeedbackPanelMaxHeight = 0;
        gamePhaseButtonSize = 36;
        gameCommandButtonHeight = 32;
        gameFeedbackPanelFont = new Font("Arial", 0, 12);
    }
}

