/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import mage.client.MageFrame;
import mage.client.preference.MagePreferences;
import mage.view.ChatMessage;

public final class IgnoreList {
    private static final String USAGE = "<br><font color=yellow>\\ignore - shows your ignore list on this server.<br>\\ignore username - add username to ignore list (they won't be able to chat or join to your new game).<br>\\unignore username - remove a username from your ignore list on this server.</font>";
    public static final int MAX_IGNORE_LIST_SIZE = 500;
    public static final Set<ChatMessage.MessageType> IGNORED_MESSAGE_TYPES = ImmutableSet.of((Object)ChatMessage.MessageType.TALK, (Object)ChatMessage.MessageType.WHISPER_FROM);

    public static String usage(String serverAddress) {
        return "<br>Your ignored list on server " + serverAddress + ": " + IgnoreList.getIgnoredUsers(serverAddress).size() + USAGE;
    }

    public static Set<String> getIgnoredUsers(String serverAddress) {
        return MagePreferences.ignoreList(serverAddress);
    }

    public static String getIgnoreListInfo(String serverAddress) {
        ArrayList<String> list = new ArrayList<String>(IgnoreList.getIgnoredUsers(serverAddress));
        Collections.sort(list);
        return "<font color=yellow>Current ignore list on " + serverAddress + " (total: " + list.size() + "): [" + String.join((CharSequence)", ", list) + "]</font>";
    }

    public static String ignore(String serverAddress, String user) {
        if (user == null || user.isEmpty()) {
            return IgnoreList.getIgnoreListInfo(serverAddress);
        }
        if (MagePreferences.ignoreList(serverAddress).size() >= 500) {
            return "Your ignore list is too big (max 500), remove a user to be able to add a new one.";
        }
        if (IgnoreList.userIsIgnored(serverAddress, user)) {
            return user + " is already on your ignore list on " + serverAddress;
        }
        MagePreferences.addIgnoredUser(serverAddress, user);
        IgnoreList.updateServerLobbyTables();
        return "Added " + user + " to your ignore list on " + serverAddress + " (total: " + IgnoreList.getIgnoredUsers(serverAddress).size() + ")";
    }

    private static void updateServerLobbyTables() {
        MageFrame mageFrame = MageFrame.getInstance();
        if (mageFrame != null) {
            mageFrame.setServerLobbyTablesFilter();
        }
    }

    public static String unignore(String serverAddress, String user) {
        if (user == null || user.isEmpty()) {
            return IgnoreList.usage(serverAddress);
        }
        if (MagePreferences.removeIgnoredUser(serverAddress, user)) {
            IgnoreList.updateServerLobbyTables();
            return "Removed " + user + " from your ignore list on " + serverAddress + " (total: " + IgnoreList.getIgnoredUsers(serverAddress).size() + ")";
        }
        return "No such user \"" + user + "\" on your ignore list on " + serverAddress + " (total: " + IgnoreList.getIgnoredUsers(serverAddress).size() + ")";
    }

    public static boolean userIsIgnored(String serverAddress, String username) {
        return MagePreferences.ignoreList(serverAddress).contains(username);
    }
}

